/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.machine;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMaps;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_8490;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.blabber.Blabber;
import org.ladysnake.blabber.api.DialogueActionV2;
import org.ladysnake.blabber.api.illustration.DialogueIllustration;
import org.ladysnake.blabber.api.layout.DialogueLayout;
import org.ladysnake.blabber.impl.common.InstancedDialogueAction;
import org.ladysnake.blabber.impl.common.machine.AvailableChoice;
import org.ladysnake.blabber.impl.common.model.ChoiceResult;
import org.ladysnake.blabber.impl.common.model.DialogueChoice;
import org.ladysnake.blabber.impl.common.model.DialogueChoiceCondition;
import org.ladysnake.blabber.impl.common.model.DialogueState;
import org.ladysnake.blabber.impl.common.model.DialogueTemplate;
import org.ladysnake.blabber.impl.common.model.UnavailableAction;
import org.ladysnake.blabber.impl.common.model.UnavailableDisplay;
import org.ladysnake.blabber.impl.common.packets.ChoiceAvailabilityPacket;

public final class DialogueStateMachine {
    private static final DynamicCommandExceptionType INVALID_PREDICATE_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"blabber:commands.dialogue.start.predicate.invalid", (Object[])new Object[]{String.valueOf(id)}));
    private final class_2960 id;
    private final DialogueTemplate template;
    private final Map<String, Int2BooleanMap> conditionalChoices;
    @Nullable
    private String currentStateKey;
    private ImmutableList<AvailableChoice> availableChoices = ImmutableList.of();

    public DialogueStateMachine(class_2960 id, DialogueTemplate template, @Nullable String start) {
        this.template = template;
        this.id = id;
        this.conditionalChoices = DialogueStateMachine.gatherConditionalChoices(template);
        this.selectState(start == null ? template.start() : start);
    }

    private static Map<String, Int2BooleanMap> gatherConditionalChoices(DialogueTemplate template) {
        HashMap<String, Int2BooleanMap> conditionalChoices = new HashMap<String, Int2BooleanMap>();
        for (Map.Entry<String, DialogueState> entry : template.states().entrySet()) {
            List<DialogueChoice> choices = entry.getValue().choices();
            Int2BooleanOpenHashMap m = new Int2BooleanOpenHashMap();
            for (int i = 0; i < choices.size(); ++i) {
                DialogueChoice choice = choices.get(i);
                if (!choice.condition().isPresent()) continue;
                m.put(i, false);
            }
            if (m.isEmpty()) continue;
            conditionalChoices.put(entry.getKey(), (Int2BooleanMap)m);
        }
        return conditionalChoices;
    }

    public static void writeToPacket(class_2540 buf, DialogueStateMachine dialogue) {
        buf.method_10812(dialogue.getId());
        DialogueTemplate.writeToPacket(buf, dialogue.template);
        buf.method_10814(dialogue.getCurrentStateKey());
    }

    public DialogueStateMachine(class_2540 buf) {
        this(buf.method_10810(), new DialogueTemplate(buf), buf.method_19772());
    }

    private Map<String, DialogueState> getStates() {
        return this.template.states();
    }

    private DialogueState getCurrentState() {
        return this.getStates().get(this.getCurrentStateKey());
    }

    public class_2960 getId() {
        return this.id;
    }

    public DialogueLayout<?> getLayout() {
        return this.template.layout();
    }

    public class_2561 getCurrentText() {
        return this.getCurrentState().text();
    }

    public List<String> getCurrentIllustrations() {
        return this.getCurrentState().illustrations();
    }

    public Map<String, DialogueIllustration> getIllustrations() {
        return this.template.illustrations();
    }

    public ImmutableList<AvailableChoice> getAvailableChoices() {
        return this.availableChoices;
    }

    public boolean hasConditions() {
        return !this.conditionalChoices.isEmpty();
    }

    @Nullable
    public ChoiceAvailabilityPacket updateConditions(class_47 context) throws CommandSyntaxException {
        ChoiceAvailabilityPacket ret = null;
        for (Map.Entry<String, Int2BooleanMap> conditionalState : this.conditionalChoices.entrySet()) {
            List<DialogueChoice> availableChoices = this.getStates().get(conditionalState.getKey()).choices();
            for (Int2BooleanMap.Entry conditionalChoice : conditionalState.getValue().int2BooleanEntrySet()) {
                class_2960 predicateId = availableChoices.get(conditionalChoice.getIntKey()).condition().orElseThrow().predicate();
                class_5341 condition = (class_5341)context.method_299().method_8503().method_3857().getElement(class_8490.field_44496, predicateId);
                if (condition == null) {
                    throw INVALID_PREDICATE_EXCEPTION.create((Object)predicateId);
                }
                boolean testResult = DialogueStateMachine.runTest(condition, context);
                if (testResult == conditionalChoice.setValue(testResult)) continue;
                if (ret == null) {
                    ret = new ChoiceAvailabilityPacket();
                }
                ret.markUpdated(conditionalState.getKey(), conditionalChoice.getIntKey(), testResult);
            }
        }
        return ret;
    }

    public ChoiceAvailabilityPacket createFullAvailabilityUpdatePacket() {
        return new ChoiceAvailabilityPacket(this.conditionalChoices);
    }

    private static boolean runTest(class_5341 condition, class_47 context) {
        class_47.class_8487 lootEntry = class_47.method_51187((class_5341)condition);
        context.method_298(lootEntry);
        boolean testResult = condition.test((Object)context);
        context.method_295(lootEntry);
        return testResult;
    }

    public void applyAvailabilityUpdate(ChoiceAvailabilityPacket payload) {
        payload.updatedChoices().forEach((stateKey, choiceIndices) -> {
            Int2BooleanMap conditionalState = this.conditionalChoices.get(stateKey);
            for (Int2BooleanMap.Entry updatedChoice : choiceIndices.int2BooleanEntrySet()) {
                conditionalState.put(updatedChoice.getIntKey(), updatedChoice.getBooleanValue());
            }
            this.availableChoices = this.rebuildAvailableChoices();
        });
    }

    public boolean isAvailable(int choice) {
        return this.conditionalChoices.getOrDefault(this.currentStateKey, (Int2BooleanMap)Int2BooleanMaps.EMPTY_MAP).getOrDefault(choice, true);
    }

    public Optional<InstancedDialogueAction<?>> getStartAction() {
        return this.getStates().get(this.template.start()).action();
    }

    public ChoiceResult choose(int choice, Consumer<DialogueActionV2> actionRunner) {
        if (choice == AvailableChoice.ESCAPE_HATCH.originalChoiceIndex() && IntStream.range(0, this.getCurrentState().choices().size()).noneMatch(this::isAvailable)) {
            Blabber.LOGGER.warn("(Blabber) Escape hatch used on {}#{}", (Object)this.getId(), (Object)this.currentStateKey);
            return ChoiceResult.END_DIALOGUE;
        }
        this.validateChoice(choice);
        DialogueState nextState = this.selectState(this.getCurrentState().getNextState(choice));
        nextState.action().map(InstancedDialogueAction::action).ifPresent(actionRunner);
        return nextState.type();
    }

    private void validateChoice(int choice) {
        if (choice < 0 || choice >= this.getCurrentState().choices().size()) {
            throw new IllegalStateException("only choices 0 to %d available".formatted(this.getCurrentState().choices().size() - 1));
        }
        if (!this.isAvailable(choice)) {
            throw new IllegalStateException("condition %s is not fulfilled".formatted(this.getCurrentState().choices().get(choice).condition()));
        }
    }

    public DialogueState selectState(String state) {
        if (!this.getStates().containsKey(state)) {
            throw new IllegalArgumentException(state + " is not an available dialogue state");
        }
        this.currentStateKey = state;
        DialogueState currentState = this.getStates().get(state);
        this.availableChoices = this.rebuildAvailableChoices();
        return currentState;
    }

    private ImmutableList<AvailableChoice> rebuildAvailableChoices() {
        ImmutableList.Builder newChoices = ImmutableList.builder();
        List<DialogueChoice> availableChoices = this.getCurrentState().choices();
        boolean allUnavailable = true;
        for (int i = 0; i < availableChoices.size(); ++i) {
            DialogueChoice c = availableChoices.get(i);
            boolean available = this.conditionalChoices.getOrDefault(this.currentStateKey, (Int2BooleanMap)Int2BooleanMaps.EMPTY_MAP).getOrDefault(i, true);
            Optional<UnavailableAction> whenUnavailable = c.condition().map(DialogueChoiceCondition::whenUnavailable);
            allUnavailable &= !available;
            if (!available && !whenUnavailable.filter(t -> t.display() == UnavailableDisplay.GRAYED_OUT).isPresent()) continue;
            newChoices.add((Object)new AvailableChoice(i, c.text(), c.illustrations(), whenUnavailable.filter(t -> !available).flatMap(a -> a.message().or(DialogueStateMachine::defaultLockedMessage))));
        }
        if (allUnavailable) {
            Blabber.LOGGER.warn("[Blabber] No choice available in state '{}' of {} ({} were all unavailable)", (Object)this.currentStateKey, (Object)this.id, availableChoices);
            newChoices.add((Object)AvailableChoice.ESCAPE_HATCH);
        }
        return newChoices.build();
    }

    private static Optional<class_2561> defaultLockedMessage() {
        return Optional.of(class_2561.method_43471((String)"blabber:dialogue.locked_choice"));
    }

    public String getCurrentStateKey() {
        return Objects.requireNonNull(this.currentStateKey, () -> String.valueOf(this) + " has not been initialized !");
    }

    public boolean isUnskippable() {
        return this.template.unskippable();
    }

    public String toString() {
        return "DialogueStateMachine" + String.valueOf(this.getStates());
    }
}

