/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.illustrations.entity;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.blabber.api.illustration.DialogueIllustrationType;
import org.ladysnake.blabber.impl.common.illustrations.entity.DialogueIllustrationEntity;
import org.ladysnake.blabber.impl.common.illustrations.entity.StareTarget;
import org.ladysnake.blabber.impl.common.model.IllustrationAnchor;
import org.ladysnake.blabber.impl.common.serialization.EitherMapCodec;
import org.ladysnake.blabber.impl.common.serialization.FailingOptionalFieldCodec;
import org.ladysnake.blabber.impl.common.serialization.OptionalSerialization;

public class DialogueIllustrationSelectorEntity
implements DialogueIllustrationEntity {
    public static final Codec<DialogueIllustrationSelectorEntity> CODEC = Spec.CODEC.xmap(DialogueIllustrationSelectorEntity::new, DialogueIllustrationSelectorEntity::spec).codec();
    public static final DialogueIllustrationType<DialogueIllustrationSelectorEntity> TYPE = new DialogueIllustrationType<DialogueIllustrationSelectorEntity>(CODEC, buf -> new DialogueIllustrationSelectorEntity(new Spec((class_2540)buf), buf.method_10816()), (buf, i) -> {
        i.spec().writeToBuffer((class_2540)buf);
        buf.method_10804(i.selectedEntityId);
    });
    private static final int NO_ENTITY_FOUND = -1;
    private final Spec spec;
    private int selectedEntityId;

    public DialogueIllustrationSelectorEntity(Spec spec) {
        this(spec, -1);
    }

    private DialogueIllustrationSelectorEntity(Spec spec, int selectedEntityId) {
        this.spec = spec;
        this.selectedEntityId = selectedEntityId;
    }

    public class_1309 getSelectedEntity(class_1937 world) {
        class_1309 living;
        if (this.selectedEntityId == -1) {
            return null;
        }
        class_1297 e = world.method_8469(this.selectedEntityId);
        return e instanceof class_1309 ? (living = (class_1309)e) : null;
    }

    public Spec spec() {
        return this.spec;
    }

    @Override
    public StareTarget stareAt() {
        return this.spec.stareAt();
    }

    @Override
    public float yOffset() {
        return this.spec.yOffset();
    }

    @Override
    public int entitySize() {
        return this.spec.entitySize();
    }

    @Override
    public IllustrationAnchor anchor() {
        return this.spec.anchor();
    }

    @Override
    public int x() {
        return this.spec.x();
    }

    @Override
    public int y() {
        return this.spec.y();
    }

    @Override
    public int width() {
        return this.spec.width();
    }

    @Override
    public int height() {
        return this.spec.height();
    }

    public DialogueIllustrationType<?> getType() {
        return TYPE;
    }

    @Override
    public DialogueIllustrationSelectorEntity parseText(@Nullable class_2168 source, @Nullable class_1297 sender) throws CommandSyntaxException {
        class_2300 entitySelector;
        class_1297 e;
        if (source != null && (e = (entitySelector = new class_2303(new StringReader(this.spec().selector())).method_9882()).method_9809(source)) instanceof class_1309) {
            class_1309 living = (class_1309)e;
            this.selectedEntityId = living.method_5628();
        }
        return this;
    }

    public record Spec(String selector, IllustrationAnchor anchor, int x, int y, int width, int height, int entitySize, float yOffset, StareTarget stareAt) {
        private static final MapCodec<Spec> CODEC_V0 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("entity").forGetter(Spec::selector), (App)FailingOptionalFieldCodec.of(IllustrationAnchor.CODEC, "anchor", IllustrationAnchor.TOP_LEFT).forGetter(Spec::anchor), (App)Codec.INT.fieldOf("x1").forGetter(Spec::x), (App)Codec.INT.fieldOf("y1").forGetter(Spec::y), (App)Codec.INT.fieldOf("x2").forGetter(s -> s.x() + s.width()), (App)Codec.INT.fieldOf("y2").forGetter(s -> s.y() + s.height()), (App)Codec.INT.fieldOf("size").forGetter(Spec::entitySize), (App)FailingOptionalFieldCodec.of(Codec.FLOAT, "y_offset", Float.valueOf(0.0f)).forGetter(Spec::yOffset), (App)OptionalSerialization.optionalIntField("stare_at_x").forGetter(s -> s.stareAt().x()), (App)OptionalSerialization.optionalIntField("stare_at_y").forGetter(s -> s.stareAt().y())).apply((Applicative)instance, (id, anchor, x1, y1, x2, y2, size, yOff, stareAtX, stareAtY) -> {
            int minX = Math.min(x1, x2);
            int minY = Math.min(y1, y2);
            int maxX = Math.max(x1, x2);
            int maxY = Math.max(y1, y2);
            return new Spec((String)id, (IllustrationAnchor)((Object)((Object)anchor)), minX, minY, maxX - minX, maxY - minY, (int)size, yOff.floatValue(), new StareTarget(Optional.empty(), (OptionalInt)stareAtX, (OptionalInt)stareAtY));
        }));
        private static final MapCodec<Spec> CODEC_V1 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("entity").forGetter(Spec::selector), (App)FailingOptionalFieldCodec.of(IllustrationAnchor.CODEC, "anchor", IllustrationAnchor.TOP_LEFT).forGetter(Spec::anchor), (App)Codec.INT.fieldOf("x").forGetter(Spec::x), (App)Codec.INT.fieldOf("y").forGetter(Spec::y), (App)Codec.INT.fieldOf("width").forGetter(Spec::width), (App)Codec.INT.fieldOf("height").forGetter(Spec::height), (App)Codec.INT.fieldOf("entity_size").forGetter(Spec::entitySize), (App)FailingOptionalFieldCodec.of(Codec.FLOAT, "y_offset", Float.valueOf(0.0f)).forGetter(Spec::yOffset), (App)FailingOptionalFieldCodec.of(StareTarget.CODEC, "stare_at", StareTarget.FOLLOW_MOUSE).forGetter(Spec::stareAt)).apply((Applicative)instance, Spec::new));
        public static final MapCodec<Spec> CODEC = EitherMapCodec.alternatively(CODEC_V0, CODEC_V1);

        public Spec(class_2540 buf) {
            this(buf.method_19772(), (IllustrationAnchor)buf.method_10818(IllustrationAnchor.class), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readFloat(), new StareTarget(buf));
        }

        public void writeToBuffer(class_2540 buf) {
            buf.method_10814(this.selector());
            buf.method_10817((Enum)this.anchor());
            buf.writeInt(this.x());
            buf.writeInt(this.y());
            buf.writeInt(this.width());
            buf.writeInt(this.height());
            buf.writeInt(this.entitySize());
            buf.writeFloat(this.yOffset());
            StareTarget.writeToPacket(buf, this.stareAt());
        }
    }
}

