/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.illustrations;

import java.util.EnumMap;
import org.joml.Vector2i;
import org.ladysnake.blabber.impl.common.model.IllustrationAnchor;

public class PositionTransform {
    private final EnumMap<IllustrationAnchor, Vector2i> anchors;

    public PositionTransform(EnumMap<IllustrationAnchor, Vector2i> anchors) {
        this.anchors = anchors;
    }

    private Vector2i getPos(IllustrationAnchor anchor) {
        return this.anchors.get((Object)anchor);
    }

    public int transformX(IllustrationAnchor anchor, int x) {
        return this.getPos(anchor).x() + x;
    }

    public int inverseTransformX(IllustrationAnchor anchor, int x) {
        return x - this.getPos(anchor).x();
    }

    public int transformY(IllustrationAnchor anchor, int y) {
        return this.getPos(anchor).y() + y;
    }

    public int inverseTransformY(IllustrationAnchor anchor, int y) {
        return y - this.getPos(anchor).y();
    }

    public void setControlPoints(int x1, int y1, int x2, int y2) {
        this.getPos(IllustrationAnchor.TOP_LEFT).set(x1, y1);
        this.getPos(IllustrationAnchor.TOP_RIGHT).set(x2, y1);
        this.getPos(IllustrationAnchor.BOTTOM_LEFT).set(x1, y2);
        this.getPos(IllustrationAnchor.BOTTOM_RIGHT).set(x2, y2);
        this.getPos(IllustrationAnchor.CENTER).set((x1 + x2) / 2, (y1 + y2) / 2);
    }
}

