/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_47;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.blabber.Blabber;
import org.ladysnake.blabber.impl.common.CommandDialogueAction;
import org.ladysnake.blabber.impl.common.DialogueRegistry;
import org.ladysnake.blabber.impl.common.DialogueScreenHandler;
import org.ladysnake.blabber.impl.common.DialogueScreenHandlerFactory;
import org.ladysnake.blabber.impl.common.machine.DialogueStateMachine;
import org.ladysnake.blabber.impl.common.model.DialogueTemplate;
import org.ladysnake.blabber.impl.common.packets.ChoiceAvailabilityPacket;

public final class PlayerDialogueTracker
implements ServerTickingComponent {
    public static final ComponentKey<PlayerDialogueTracker> KEY = ComponentRegistry.getOrCreate((class_2960)Blabber.id("dialogue_tracker"), PlayerDialogueTracker.class);
    private final class_1657 player;
    @Nullable
    private DialogueStateMachine currentDialogue;
    @Nullable
    private class_1297 interlocutor;
    @Nullable
    private DeserializedState deserializedState;
    private int resumptionAttempts = 0;

    public PlayerDialogueTracker(class_1657 player) {
        this.player = player;
    }

    public static PlayerDialogueTracker get(class_1657 player) {
        return (PlayerDialogueTracker)KEY.get((Object)player);
    }

    public void startDialogue(class_2960 id, @Nullable class_1297 interlocutor) throws CommandSyntaxException {
        DialogueTemplate template = DialogueRegistry.getOrEmpty(id).orElseThrow(() -> new IllegalArgumentException("Unknown dialogue " + String.valueOf(id)));
        DialogueStateMachine currentDialogue = this.startDialogue0(id, template, template.start(), interlocutor);
        currentDialogue.getStartAction().ifPresent(a -> a.action().handle((class_3222)this.player, interlocutor));
    }

    private DialogueStateMachine startDialogue0(class_2960 id, DialogueTemplate template, @Nullable String start, @Nullable class_1297 interlocutor) throws CommandSyntaxException {
        class_3222 serverPlayer = (class_3222)this.player;
        this.interlocutor = interlocutor;
        try {
            DialogueTemplate parsedTemplate = template.parseText(CommandDialogueAction.getSource(serverPlayer), (class_1297)serverPlayer);
            this.currentDialogue = new DialogueStateMachine(id, parsedTemplate, start);
            this.updateConditions(serverPlayer, this.currentDialogue);
            this.openDialogueScreen();
            return this.currentDialogue;
        }
        catch (CommandSyntaxException e) {
            this.interlocutor = null;
            throw e;
        }
    }

    public void endDialogue() {
        this.currentDialogue = null;
        this.interlocutor = null;
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 sp = (class_3222)class_16572;
            if (this.player.field_7512 instanceof DialogueScreenHandler) {
                sp.method_7346();
            }
        }
    }

    public Optional<DialogueStateMachine> getCurrentDialogue() {
        return Optional.ofNullable(this.currentDialogue);
    }

    public Optional<class_1297> getInterlocutor() {
        return Optional.ofNullable(this.interlocutor);
    }

    public void updateDialogue() {
        DialogueStateMachine oldDialogue = this.currentDialogue;
        class_1297 oldInterlocutor = this.interlocutor;
        if (oldDialogue != null) {
            this.endDialogue();
            DialogueRegistry.getOrEmpty(oldDialogue.getId()).ifPresent(template -> this.tryResumeDialogue(oldDialogue.getId(), (DialogueTemplate)template, oldDialogue.getCurrentStateKey(), oldInterlocutor));
        }
    }

    public void readFromNbt(class_2487 tag) {
        Optional<DialogueTemplate> dialogueTemplate;
        class_2960 dialogueId;
        if (tag.method_10573("current_dialogue_id", 8) && (dialogueId = class_2960.method_12829((String)tag.method_10558("current_dialogue_id"))) != null && (dialogueTemplate = DialogueRegistry.getOrEmpty(dialogueId)).isPresent()) {
            UUID interlocutorUuid = tag.method_25928("interlocutor") ? tag.method_25926("interlocutor") : null;
            String selectedState = tag.method_10573("current_dialogue_state", 8) ? tag.method_10558("current_dialogue_state") : null;
            this.deserializedState = new DeserializedState(dialogueId, dialogueTemplate.get(), selectedState, interlocutorUuid);
        }
    }

    public void writeToNbt(class_2487 tag) {
        if (this.currentDialogue != null) {
            tag.method_10582("current_dialogue_id", this.currentDialogue.getId().toString());
            tag.method_10582("current_dialogue_state", this.currentDialogue.getCurrentStateKey());
            if (this.interlocutor != null) {
                tag.method_25927("interlocutor", this.interlocutor.method_5667());
            }
        }
    }

    public void serverTick() {
        DeserializedState saved = this.deserializedState;
        class_3222 serverPlayer = (class_3222)this.player;
        if (saved != null) {
            if (this.resumptionAttempts++ < 200) {
                class_1297 interlocutor;
                if (saved.interlocutorUuid() != null) {
                    interlocutor = serverPlayer.method_51469().method_14190(saved.interlocutorUuid());
                    if (interlocutor == null) {
                        return;
                    }
                } else {
                    interlocutor = null;
                }
                this.tryResumeDialogue(saved.dialogueId(), saved.template(), saved.selectedState(), interlocutor);
            }
            this.resumptionAttempts = 0;
            this.deserializedState = null;
        }
        if (this.currentDialogue != null) {
            if (this.player.field_7512 == this.player.field_7498) {
                if (this.currentDialogue.isUnskippable()) {
                    this.openDialogueScreen();
                } else {
                    this.endDialogue();
                    return;
                }
            }
            try {
                ChoiceAvailabilityPacket update = this.updateConditions(serverPlayer, this.currentDialogue);
                if (update != null) {
                    ServerPlayNetworking.send((class_3222)serverPlayer, (FabricPacket)update);
                }
            }
            catch (CommandSyntaxException e) {
                throw new IllegalStateException("Error while updating dialogue conditions", e);
            }
        }
    }

    private void tryResumeDialogue(class_2960 id, DialogueTemplate template, String selectedState, class_1297 interlocutor) {
        try {
            this.startDialogue0(id, template, selectedState, interlocutor);
        }
        catch (CommandSyntaxException e) {
            Blabber.LOGGER.error("(Blabber) Failed to load dialogue template {}", (Object)id, (Object)e);
        }
    }

    @Nullable
    private ChoiceAvailabilityPacket updateConditions(class_3222 player, DialogueStateMachine currentDialogue) throws CommandSyntaxException {
        if (currentDialogue.hasConditions()) {
            return currentDialogue.updateConditions(new class_47.class_48(new class_8567.class_8568(player.method_51469()).method_51874(class_181.field_24424, (Object)player.method_19538()).method_51877(class_181.field_1226, (Object)player).method_51875(class_173.field_20761)).method_309(null));
        }
        return null;
    }

    private void openDialogueScreen() {
        Preconditions.checkState((this.currentDialogue != null ? 1 : 0) != 0);
        this.player.method_17355((class_3908)new DialogueScreenHandlerFactory(this.currentDialogue, class_2561.method_30163((String)"Blabber Dialogue Screen"), this.interlocutor));
    }

    private record DeserializedState(class_2960 dialogueId, DialogueTemplate template, String selectedState, @Nullable UUID interlocutorUuid) {
    }
}

