/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.api.client;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.ladysnake.blabber.Blabber;
import org.ladysnake.blabber.api.client.illustration.DialogueIllustrationRenderer;
import org.ladysnake.blabber.api.layout.DialogueLayout;
import org.ladysnake.blabber.impl.client.BlabberClient;
import org.ladysnake.blabber.impl.common.DialogueScreenHandler;
import org.ladysnake.blabber.impl.common.illustrations.PositionTransform;
import org.ladysnake.blabber.impl.common.machine.AvailableChoice;
import org.ladysnake.blabber.impl.common.model.ChoiceResult;
import org.ladysnake.blabber.impl.common.model.IllustrationAnchor;
import org.ladysnake.blabber.impl.common.settings.BlabberSetting;
import org.ladysnake.blabber.impl.common.settings.BlabberSettingsComponent;

@ApiStatus.Experimental
public class BlabberDialogueScreen<P extends DialogueLayout.Params>
extends class_465<DialogueScreenHandler> {
    public static final List<class_2960> DIALOGUE_ARROWS = IntStream.range(1, 6).mapToObj(i -> Blabber.id("textures/gui/sprites/container/dialogue/dialogue_arrow_" + i + ".png")).toList();
    public static final List<class_2960> DIALOGUE_LOCKS = IntStream.range(1, 4).mapToObj(i -> Blabber.id("textures/gui/sprites/container/dialogue/dialogue_lock_" + i + ".png")).toList();
    public static final int DEFAULT_TITLE_GAP = 20;
    public static final int DEFAULT_TEXT_MAX_WIDTH = 300;
    public static final int DEFAULT_INSTRUCTIONS_BOTTOM_MARGIN = 30;
    public static final int[] DEBUG_COLORS = new int[]{4372578, 12075586, 12085826, 4372605, 4372664, 4352696, 6963896, 12075704};
    protected final class_2561 instructions;
    protected class_2960 selectionIconTexture = DIALOGUE_ARROWS.get(0);
    protected class_2960 lockIconTexture = DIALOGUE_LOCKS.get(0);
    protected int mainTextMinY = 40;
    protected int choiceGap = 8;
    protected int mainTextMinX = 10;
    protected int instructionsMinY;
    protected int mainTextMaxWidth = 300;
    protected int choiceListMaxWidth = 300;
    protected int choiceListMinX = 25;
    protected int selectionIconMinX = 4;
    protected int selectionIconMarginTop = -4;
    protected int selectionIconSize = 16;
    protected EnumMap<IllustrationAnchor, Vector2i> illustrationSlots;
    protected int mainTextColor = 0xFFFFFF;
    protected int lockedChoiceColor = 0x808080;
    protected int selectedChoiceColor = 0xE0E044;
    protected int choiceColor = 0xA0A0A0;
    protected int choiceListMinY;
    protected int selectedChoice;
    protected boolean hoveringChoice;
    protected Map<String, DialogueIllustrationRenderer<?>> illustrations = new HashMap();

    public BlabberDialogueScreen(DialogueScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        class_315 options = class_310.method_1551().field_1690;
        this.instructions = class_2561.method_43469((String)"blabber:dialogue.instructions", (Object[])new Object[]{options.field_1894.method_16007(), options.field_1881.method_16007(), options.field_1822.method_16007()});
        this.illustrationSlots = new EnumMap(IllustrationAnchor.class);
        for (IllustrationAnchor anchor : IllustrationAnchor.values()) {
            this.illustrationSlots.put(anchor, new Vector2i(-999, -999));
        }
    }

    protected P params() {
        return (P)((DialogueScreenHandler)this.field_2797).getLayout().params();
    }

    protected void method_25426() {
        super.method_25426();
        this.prepareLayout();
        this.illustrations.clear();
        ((DialogueScreenHandler)this.field_2797).getIllustrations().forEach((key, illustration) -> this.illustrations.put((String)key, BlabberClient.createRenderer(illustration)));
    }

    protected void prepareLayout() {
        this.computeMargins();
        this.layoutIllustrationAnchors();
    }

    protected void computeMargins() {
        this.instructionsMinY = this.field_22790 - 30;
        class_2561 text = ((DialogueScreenHandler)this.field_2797).getCurrentText();
        this.choiceListMinY = this.mainTextMinY + this.field_22793.method_44378((class_5348)text, this.mainTextMaxWidth) + 20;
    }

    protected void layoutIllustrationAnchors() {
        this.illustrationSlots.get((Object)IllustrationAnchor.BEFORE_MAIN_TEXT).set(this.mainTextMinX, this.mainTextMinY);
        this.illustrationSlots.get((Object)IllustrationAnchor.SPOT_1).set(this.field_22789 * 3 / 4, this.choiceListMinY);
        this.illustrationSlots.get((Object)IllustrationAnchor.SPOT_2).set(this.field_22789 * 2 / 5, this.field_22790 * 2 / 3);
    }

    public boolean method_25422() {
        return !((DialogueScreenHandler)this.field_2797).isUnskippable();
    }

    public boolean method_25402(double x, double y, int button) {
        if (this.hoveringChoice) {
            this.confirmChoice(this.selectedChoice);
        }
        return true;
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        boolean shift;
        class_315 options = class_310.method_1551().field_1690;
        if (key == 257 || options.field_1822.method_1417(key, scancode)) {
            this.confirmChoice(this.selectedChoice);
            return true;
        }
        boolean tab = 258 == key;
        boolean down = options.field_1881.method_1417(key, scancode);
        boolean bl = shift = (1 & modifiers) != 0;
        if (tab || down || options.field_1894.method_1417(key, scancode)) {
            this.scrollDialogueChoice(tab && !shift || down ? -1.0 : 1.0);
            return true;
        }
        return super.method_25404(key, scancode, modifiers);
    }

    @Nullable
    private ChoiceResult confirmChoice(int selectedChoice) {
        assert (this.field_22787 != null);
        if (((AvailableChoice)((DialogueScreenHandler)this.field_2797).getAvailableChoices().get(selectedChoice)).unavailabilityMessage().isPresent()) {
            return null;
        }
        ChoiceResult result = this.makeChoice(selectedChoice);
        switch (result) {
            case END_DIALOGUE: {
                this.field_22787.method_1507(null);
                break;
            }
            case ASK_CONFIRMATION: {
                ImmutableList<AvailableChoice> choices = ((DialogueScreenHandler)this.field_2797).getAvailableChoices();
                this.field_22787.method_1507((class_437)new class_410(this::onBigChoiceMade, ((DialogueScreenHandler)this.field_2797).getCurrentText(), (class_2561)class_2561.method_43473(), ((AvailableChoice)choices.get(0)).text(), ((AvailableChoice)choices.get(1)).text()));
                break;
            }
            default: {
                this.selectedChoice = 0;
                this.hoveringChoice = false;
                this.prepareLayout();
            }
        }
        return result;
    }

    private void onBigChoiceMade(boolean yes) {
        assert (this.field_22787 != null);
        if (this.confirmChoice(yes ? 0 : 1) == ChoiceResult.DEFAULT) {
            this.field_22787.method_1507((class_437)this);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double verticalAmount) {
        this.scrollDialogueChoice(class_3532.method_15350((double)verticalAmount, (double)-1.0, (double)1.0));
        return true;
    }

    protected void scrollDialogueChoice(double scrollAmount) {
        ImmutableList<AvailableChoice> availableChoices = ((DialogueScreenHandler)this.field_2797).getAvailableChoices();
        if (!availableChoices.isEmpty()) {
            this.selectedChoice = Math.floorMod((int)((double)this.selectedChoice - scrollAmount), availableChoices.size());
        }
    }

    public void method_16014(double mouseX, double mouseY) {
        ImmutableList<AvailableChoice> choices = ((DialogueScreenHandler)this.field_2797).getAvailableChoices();
        int y = this.choiceListMinY;
        for (int i = 0; i < choices.size(); ++i) {
            int strWidth;
            class_2561 choice = ((AvailableChoice)choices.get(i)).text();
            int strHeight = this.field_22793.method_44378((class_5348)choice, this.choiceListMaxWidth);
            int n = strWidth = strHeight == 9 ? this.field_22793.method_27525((class_5348)choice) : this.choiceListMaxWidth;
            if (this.shouldSelectChoice(mouseX, mouseY, y, strHeight, strWidth)) {
                this.selectedChoice = i;
                this.hoveringChoice = true;
                return;
            }
            y += strHeight + this.choiceGap;
            this.hoveringChoice = false;
        }
    }

    protected boolean shouldSelectChoice(double mouseX, double mouseY, int choiceY, int choiceHeight, int choiceWidth) {
        return mouseX >= 0.0 && mouseX < (double)(this.choiceListMinX + choiceWidth) && mouseY > (double)choiceY && mouseY < (double)(choiceY + choiceHeight);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        this.method_25420(context);
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        PositionTransform positionTransform = this.createPositionTransform();
        positionTransform.setControlPoints(0, 0, this.field_22789, this.field_22790);
        int y = this.mainTextMinY;
        for (String illustrationName : ((DialogueScreenHandler)this.field_2797).getCurrentIllustrations()) {
            this.getIllustrationRenderer(illustrationName).render(context, this.field_22793, positionTransform, mouseX, mouseY, tickDelta);
        }
        class_2561 mainText = ((DialogueScreenHandler)this.field_2797).getCurrentText();
        context.method_51440(this.field_22793, (class_5348)mainText, this.mainTextMinX, y, this.mainTextMaxWidth, this.mainTextColor);
        y = this.choiceListMinY;
        ImmutableList<AvailableChoice> choices = ((DialogueScreenHandler)this.field_2797).getAvailableChoices();
        for (int i = 0; i < choices.size(); ++i) {
            boolean selected;
            AvailableChoice choice = (AvailableChoice)choices.get(i);
            int strHeight = this.field_22793.method_44378((class_5348)choice.text(), this.choiceListMaxWidth);
            boolean bl = selected = i == this.selectedChoice;
            int choiceColor = choice.unavailabilityMessage().isPresent() ? this.lockedChoiceColor : (selected ? this.selectedChoiceColor : this.choiceColor);
            context.method_51440(this.field_22793, (class_5348)choice.text(), this.choiceListMinX, y, this.choiceListMaxWidth, choiceColor);
            positionTransform.setControlPoints(this.choiceListMinX, y, this.choiceListMinX + this.choiceListMaxWidth, y + strHeight);
            for (String illustrationName : choice.illustrations()) {
                this.getIllustrationRenderer(illustrationName).render(context, this.field_22793, positionTransform, mouseX, mouseY, tickDelta);
            }
            if (selected) {
                if (choice.unavailabilityMessage().isPresent()) {
                    context.method_25291(this.lockIconTexture, this.selectionIconMinX, y + this.selectionIconMarginTop, 0, 0.0f, 0.0f, this.selectionIconSize, this.selectionIconSize, this.selectionIconSize, this.selectionIconSize);
                    context.method_51438(this.field_22793, choice.unavailabilityMessage().get(), this.hoveringChoice ? mouseX : this.choiceListMaxWidth, this.hoveringChoice ? mouseY : y);
                } else {
                    context.method_25291(this.selectionIconTexture, this.selectionIconMinX, y + this.selectionIconMarginTop, 0, 0.0f, 0.0f, this.selectionIconSize, this.selectionIconSize, this.selectionIconSize, this.selectionIconSize);
                }
            }
            y += strHeight + this.choiceGap;
        }
        context.method_51440(this.field_22793, (class_5348)this.instructions, Math.max((this.field_22789 - this.field_22793.method_27525((class_5348)this.instructions)) / 2, 5), this.instructionsMinY, this.field_22789 - 5, 0x808080);
        BlabberSettingsComponent settings = BlabberSettingsComponent.get((class_1657)this.field_22787.field_1724);
        if (settings.isDebugEnabled()) {
            positionTransform.setControlPoints(0, 0, this.field_22789, this.field_22790);
            this.renderDebugInfo(settings, context, positionTransform, mouseX, mouseY);
        }
    }

    private DialogueIllustrationRenderer<?> getIllustrationRenderer(String illustrationName) {
        DialogueIllustrationRenderer<?> renderer = this.illustrations.get(illustrationName);
        if (renderer == null) {
            throw new IllegalArgumentException("Unknown illustration " + illustrationName);
        }
        return renderer;
    }

    @NotNull
    protected PositionTransform createPositionTransform() {
        return new PositionTransform(this.illustrationSlots);
    }

    protected void renderDebugInfo(BlabberSettingsComponent settings, class_332 context, PositionTransform positionTransform, int mouseX, int mouseY) {
        if (settings.isEnabled(BlabberSetting.DEBUG_ANCHORS)) {
            this.renderAnchorDebugInfo(context, positionTransform, mouseX, mouseY);
        }
    }

    protected void renderAnchorDebugInfo(class_332 context, PositionTransform positionTransform, int mouseX, int mouseY) {
        block3: for (IllustrationAnchor anchor : IllustrationAnchor.values()) {
            int color = DEBUG_COLORS[anchor.ordinal() % DEBUG_COLORS.length];
            context.method_51433(this.field_22793, "x", positionTransform.transformX(anchor, -3), positionTransform.transformY(anchor, -5), color, true);
            class_5250 text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)anchor.method_15434()).method_27694(s -> s.method_36139(color))).method_27693(" > X: " + positionTransform.inverseTransformX(anchor, mouseX) + ", Y: " + positionTransform.inverseTransformY(anchor, mouseY));
            switch (anchor) {
                case TOP_LEFT: 
                case TOP_RIGHT: {
                    context.method_51438(this.field_22793, (class_2561)text, positionTransform.transformX(anchor, 0), 15);
                    continue block3;
                }
                default: {
                    context.method_51438(this.field_22793, (class_2561)text, positionTransform.transformX(anchor, 0), positionTransform.transformY(anchor, 0));
                }
            }
        }
    }

    protected void method_2389(class_332 matrices, float delta, int mouseX, int mouseY) {
    }

    protected void method_2388(class_332 matrices, int mouseX, int mouseY) {
    }

    public ChoiceResult makeChoice(int choice) {
        int originalChoiceIndex = ((AvailableChoice)((DialogueScreenHandler)this.field_2797).getAvailableChoices().get(choice)).originalChoiceIndex();
        ChoiceResult result = ((DialogueScreenHandler)this.field_2797).makeChoice(originalChoiceIndex);
        BlabberClient.sendDialogueActionMessage(originalChoiceIndex);
        return result;
    }
}

