/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.blabber.DialogueAction;
import org.ladysnake.blabber.api.DialogueActionV2;
import org.ladysnake.blabber.api.illustration.DialogueIllustrationType;
import org.ladysnake.blabber.api.layout.DialogueLayoutType;
import org.ladysnake.blabber.impl.common.BlabberRegistrar;
import org.ladysnake.blabber.impl.common.CommandDialogueAction;
import org.ladysnake.blabber.impl.common.DialogueInitializationException;
import org.ladysnake.blabber.impl.common.PlayerDialogueTracker;
import org.ladysnake.blabber.impl.common.commands.BlabberCommand;
import org.ladysnake.blabber.impl.common.illustrations.DialogueIllustrationCollection;
import org.ladysnake.blabber.impl.common.illustrations.DialogueIllustrationItem;
import org.ladysnake.blabber.impl.common.illustrations.DialogueIllustrationTexture;
import org.ladysnake.blabber.impl.common.illustrations.entity.DialogueIllustrationFakePlayer;
import org.ladysnake.blabber.impl.common.illustrations.entity.DialogueIllustrationNbtEntity;
import org.ladysnake.blabber.impl.common.illustrations.entity.DialogueIllustrationSelectorEntity;
import org.ladysnake.blabber.impl.common.machine.DialogueStateMachine;

public final class Blabber
implements ModInitializer {
    public static final String MOD_ID = "blabber";
    public static final Logger LOGGER = LogManager.getLogger((String)"blabber");

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static void startDialogue(class_3222 player, class_2960 id) {
        Blabber.startDialogue(player, id, null);
    }

    public static void startDialogue(class_3222 player, class_2960 id, @Nullable class_1297 interlocutor) {
        try {
            PlayerDialogueTracker.get((class_1657)player).startDialogue(id, interlocutor);
        }
        catch (CommandSyntaxException e) {
            throw new DialogueInitializationException("Failed to parse texts in dialogue template " + String.valueOf(id), e);
        }
    }

    public static void endDialogue(class_3222 player, @Nullable class_2960 expectedDialogue) {
        class_2960 currentDialogueId = PlayerDialogueTracker.get((class_1657)player).getCurrentDialogue().map(DialogueStateMachine::getId).orElse(null);
        if (currentDialogueId != null && (expectedDialogue == null || expectedDialogue.equals((Object)currentDialogueId))) {
            PlayerDialogueTracker.get((class_1657)player).endDialogue();
        }
    }

    public static void registerAction(class_2960 actionId, DialogueAction action) {
        Blabber.registerAction(actionId, (Codec<? extends DialogueActionV2>)Codec.unit((Object)action));
    }

    public static void registerAction(class_2960 actionId, DialogueActionV2 action) {
        Blabber.registerAction(actionId, (Codec<? extends DialogueActionV2>)Codec.unit((Object)action));
    }

    public static void registerAction(class_2960 actionId, Codec<? extends DialogueActionV2> codec) {
        class_2378.method_10230(BlabberRegistrar.ACTION_REGISTRY, (class_2960)actionId, codec);
    }

    public static void registerIllustration(class_2960 illustrationId, DialogueIllustrationType<?> type) {
        class_2378.method_10230(BlabberRegistrar.ILLUSTRATION_REGISTRY, (class_2960)illustrationId, type);
    }

    @ApiStatus.Experimental
    public static void registerLayout(class_2960 layoutId, DialogueLayoutType<?> type) {
        class_2378.method_10230(BlabberRegistrar.LAYOUT_REGISTRY, (class_2960)layoutId, type);
    }

    public void onInitialize() {
        BlabberRegistrar.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> BlabberCommand.register((CommandDispatcher<class_2168>)dispatcher));
        Blabber.registerAction(Blabber.id("command"), CommandDialogueAction.CODEC);
        Blabber.registerLayout(Blabber.id("classic"), BlabberRegistrar.CLASSIC_LAYOUT);
        Blabber.registerLayout(Blabber.id("rpg"), BlabberRegistrar.RPG_LAYOUT);
        Blabber.registerIllustration(Blabber.id("group"), DialogueIllustrationCollection.TYPE);
        Blabber.registerIllustration(Blabber.id("item"), DialogueIllustrationItem.TYPE);
        Blabber.registerIllustration(Blabber.id("fake_entity"), DialogueIllustrationNbtEntity.TYPE);
        Blabber.registerIllustration(Blabber.id("fake_player"), DialogueIllustrationFakePlayer.TYPE);
        Blabber.registerIllustration(Blabber.id("entity"), DialogueIllustrationSelectorEntity.TYPE);
        Blabber.registerIllustration(Blabber.id("texture"), DialogueIllustrationTexture.TYPE);
    }
}

