/*
 * Decompiled with CFR 0.152.
 */
package ru.intezium.ender_dragon_egg_respawn.mixin;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1510;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2881;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2881.class}, priority=-2147483648)
public abstract class EnderDragonFightMixin {
    @Shadow
    private final class_3218 field_13108;
    @Shadow
    private class_2338 field_13117;
    @Shadow
    private boolean field_13114;

    protected EnderDragonFightMixin(class_3218 world) {
        this.field_13108 = world;
    }

    @Inject(method={"dragonKilled(Lnet/minecraft/entity/boss/dragon/EnderDragonEntity;)V"}, at={@At(value="HEAD")})
    private void dragonKilled(class_1510 dragon, CallbackInfo info) {
        if (this.field_13114) {
            class_2338 eggSpawnPos = this.searchEggSpawnPos(this.getPosAbovePortal(this.field_13117));
            this.field_13108.method_8501(eggSpawnPos, class_2246.field_10081.method_9564());
        }
    }

    private class_2338 getPosAbovePortal(class_2338 portalPos) {
        class_2338 abovePortalPos = new class_2338((class_2382)portalPos);
        while (this.field_13108.method_8320(abovePortalPos).method_27852(class_2246.field_9987)) {
            abovePortalPos = abovePortalPos.method_10084();
        }
        return abovePortalPos;
    }

    private class_2338 searchEggSpawnPos(class_2338 abovePortalPos) {
        class_2338 eggSpawnPos = new class_2338((class_2382)abovePortalPos);
        while (!this.isUpperWorldLimit(eggSpawnPos)) {
            class_2680 blockState = this.getBlockState(eggSpawnPos);
            if (blockState.method_26215()) {
                return eggSpawnPos;
            }
            if (!blockState.method_27852(class_2246.field_10081)) {
                return this.searchEggSpawnPosExtended(abovePortalPos);
            }
            eggSpawnPos = eggSpawnPos.method_10084();
        }
        return this.searchEggSpawnPosExtended(abovePortalPos);
    }

    private class_2338 searchEggSpawnPosExtended(class_2338 abovePortalPos) {
        ArrayList<class_2338> blockPosList = new ArrayList<class_2338>();
        int centerX = abovePortalPos.method_10263();
        int centerZ = abovePortalPos.method_10260();
        int minSearchRadius = 4;
        int maxSearchRadius = 12;
        int searchHeight = 3;
        for (int radius = minSearchRadius; radius <= maxSearchRadius; ++radius) {
            for (int height = 0; height < searchHeight; ++height) {
                int z = radius;
                int delta = 3 - 2 * radius;
                int centerY = abovePortalPos.method_10264() + height;
                for (int x = 0; x <= z; ++x) {
                    blockPosList.add(new class_2338(centerX + x, centerY, centerZ + z));
                    blockPosList.add(new class_2338(centerX + x, centerY, centerZ - z));
                    blockPosList.add(new class_2338(centerX - x, centerY, centerZ + z));
                    blockPosList.add(new class_2338(centerX - x, centerY, centerZ - z));
                    blockPosList.add(new class_2338(centerX + z, centerY, centerZ + x));
                    blockPosList.add(new class_2338(centerX + z, centerY, centerZ - x));
                    blockPosList.add(new class_2338(centerX - z, centerY, centerZ + x));
                    blockPosList.add(new class_2338(centerX - z, centerY, centerZ - x));
                    class_2338 airBlockPos = this.searchLowerAirBlockPos(blockPosList);
                    if (airBlockPos != null) {
                        return airBlockPos;
                    }
                    blockPosList.clear();
                    if (delta < 0) {
                        delta += 4 * x + 6;
                        continue;
                    }
                    delta += 4 * (x - z--) + 10;
                }
            }
        }
        return abovePortalPos;
    }

    private class_2338 searchLowerAirBlockPos(List<class_2338> blockPosList) {
        for (class_2338 blockPos : blockPosList) {
            class_2338 lowerAirBlockPos;
            class_2338 bottomBlockPos;
            class_2680 bottomBlockState;
            if (!this.getBlockState(blockPos).method_26215() || !(bottomBlockState = this.getBlockState(bottomBlockPos = (lowerAirBlockPos = this.getLowerAirBlockPos(blockPos)).method_10074())).method_26212((class_1922)this.field_13108, bottomBlockPos) || bottomBlockState.method_27852(class_2246.field_9987)) continue;
            return lowerAirBlockPos;
        }
        return null;
    }

    private class_2338 getLowerAirBlockPos(class_2338 originBlockPos) {
        if (!this.getBlockState(originBlockPos.method_10074()).method_26215()) {
            return originBlockPos;
        }
        class_2338 bottomBlockPos = new class_2338((class_2382)originBlockPos);
        while (bottomBlockPos.method_10264() > this.field_13108.method_31607() && this.getBlockState(bottomBlockPos.method_10074()).method_26215()) {
            bottomBlockPos = bottomBlockPos.method_10074();
        }
        return bottomBlockPos;
    }

    private boolean isUpperWorldLimit(class_2338 blockPos) {
        return blockPos.method_10264() >= this.field_13108.method_31605();
    }

    private class_2680 getBlockState(class_2338 blockPos) {
        return this.field_13108.method_8320(blockPos);
    }
}

