/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity;

import com.izofar.bygonenether.entity.IShieldedMob;
import com.izofar.bygonenether.entity.ai.goal.ShieldGoal;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class WitherSkeletonKnight
extends class_1639
implements IShieldedMob {
    private static final class_2940<Boolean> DATA_IS_SHIELDED = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_SHIELD_HAND = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_SHIELD_COOLDOWN = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13327);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("3520BCE0-D755-458F-944B-A528DB8EF9DC");
    private static final class_1322 SPEED_MODIFIER_BLOCKING = new class_1322(SPEED_MODIFIER_ATTACKING_UUID, "Shielded speed penalty", -0.1, class_1322.class_1323.field_6328);
    private static final class_2940<Boolean> DATA_IS_DISARMORED = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13323);
    private static final float BREAK_HEALTH = 20.0f;

    public WitherSkeletonKnight(class_1299<? extends class_1639> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, new ShieldGoal<WitherSkeletonKnight>(this, class_1657.class));
        super.method_5959();
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.decrementShieldCooldown();
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23724, 2.0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Disarmored", this.isDisarmored());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setDisarmored(tag.method_10577("Disarmored"));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_IS_DISARMORED, (Object)false);
        this.field_6011.method_12784(DATA_IS_SHIELDED, (Object)false);
        this.field_6011.method_12784(DATA_SHIELD_HAND, (Object)false);
        this.field_6011.method_12784(DATA_SHIELD_COOLDOWN, (Object)0);
    }

    public boolean isDisarmored() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_DISARMORED);
    }

    private void setDisarmored(boolean disarmored) {
        this.field_6011.method_12778(DATA_IS_DISARMORED, (Object)disarmored);
    }

    public void method_5964(class_5819 randomSource, class_1266 difficulty) {
        super.method_5964(randomSource, difficulty);
        this.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8255));
    }

    public boolean method_5643(class_1282 source, float damage) {
        boolean result = super.method_5643(source, damage);
        if (!this.isDisarmored() && this.method_6032() < 20.0f) {
            this.setDisarmored(true);
            this.method_5783(class_3417.field_15239, 1.2f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
            this.method_6125(0.25f);
        }
        return result;
    }

    public void method_6005(double strength, double x, double z) {
        if (!this.isUsingShield()) {
            super.method_6005(strength, x, z);
        } else {
            this.method_5783(class_3417.field_15150, 1.0f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
        }
    }

    protected void method_6090(class_1309 attacker) {
        super.method_6090(attacker);
        if (IShieldedMob.canDisableShield(this.field_6277)) {
            this.disableShield();
        }
    }

    private void disableShield() {
        this.setShieldCooldown(60);
        this.stopUsingShield();
        this.method_37908().method_8421((class_1297)this, (byte)30);
        this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
    }

    @Override
    public boolean isShieldDisabled() {
        return this.getShieldCooldown() > 0;
    }

    @Override
    public void startUsingShield() {
        if (this.isUsingShield() || this.isShieldDisabled()) {
            return;
        }
        for (class_1268 interactionhand : class_1268.values()) {
            if (!(this.method_5998(interactionhand).method_7909() instanceof class_1819)) continue;
            this.method_6019(interactionhand);
            this.setUsingShield(true);
            this.setShieldMainhand(interactionhand == class_1268.field_5808);
            class_1324 attributeinstance = this.method_5996(class_5134.field_23719);
            if (attributeinstance == null || attributeinstance.method_6196(SPEED_MODIFIER_BLOCKING)) continue;
            attributeinstance.method_26835(SPEED_MODIFIER_BLOCKING);
        }
    }

    @Override
    public void stopUsingShield() {
        if (!this.isUsingShield()) {
            return;
        }
        for (class_1268 interactionhand : class_1268.values()) {
            if (!(this.method_5998(interactionhand).method_7909() instanceof class_1819)) continue;
            this.method_6021();
            this.setUsingShield(false);
            class_1324 attributeinstance = this.method_5996(class_5134.field_23719);
            if (attributeinstance == null) continue;
            attributeinstance.method_6202(SPEED_MODIFIER_BLOCKING);
        }
    }

    public boolean isUsingShield() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_SHIELDED);
    }

    public void setUsingShield(boolean isShielded) {
        this.field_6011.method_12778(DATA_IS_SHIELDED, (Object)isShielded);
    }

    private boolean isShieldMainhand() {
        return (Boolean)this.field_6011.method_12789(DATA_SHIELD_HAND);
    }

    private void setShieldMainhand(boolean isShieldedMainHand) {
        this.field_6011.method_12778(DATA_SHIELD_HAND, (Object)isShieldedMainHand);
    }

    private int getShieldCooldown() {
        return (Integer)this.field_6011.method_12789(DATA_SHIELD_COOLDOWN);
    }

    private void setShieldCooldown(int newShieldCooldown) {
        this.field_6011.method_12778(DATA_SHIELD_COOLDOWN, (Object)newShieldCooldown);
    }

    private void decrementShieldCooldown() {
        this.setShieldCooldown(Math.max(this.getShieldCooldown() - 1, 0));
    }

    public class_1268 getShieldHand() {
        return this.isUsingShield() ? (this.isShieldMainhand() ? class_1268.field_5808 : class_1268.field_5810) : null;
    }
}

