/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity;

import com.google.common.collect.ImmutableList;
import com.izofar.bygonenether.entity.ai.PiglinPrisonerAi;
import com.izofar.bygonenether.init.ModItems;
import com.izofar.bygonenether.init.ModSensorTypes;
import com.izofar.bygonenether.util.ModLists;
import com.izofar.bygonenether.util.random.ModWeightedEntry;
import com.mojang.serialization.Dynamic;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3745;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4837;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5996;
import net.minecraft.class_6067;
import org.jetbrains.annotations.Nullable;

public class PiglinPrisoner
extends class_5418
implements class_3745,
class_6067 {
    private static final class_2940<Boolean> DATA_IS_CHARGING_CROSSBOW = class_2945.method_12791(PiglinPrisoner.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_DANCING = class_2945.method_12791(PiglinPrisoner.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> DATA_OWNERUUID_ID = class_2945.method_12791(PiglinPrisoner.class, (class_2941)class_2943.field_13313);
    protected static final int RESCUE_TIME = 75;
    protected int timeBeingRescued;
    protected boolean isBeingRescued;
    protected boolean hasTempter;
    protected static final ImmutableList<class_4149<? extends class_4148<? super PiglinPrisoner>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_18469, ModSensorTypes.PIGLIN_PRISONER_SPECIFIC_SENSOR);
    protected static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_26389, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18444, (Object)class_4140.field_22343, (Object)class_4140.field_25755, (Object)class_4140.field_22332, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object[])new class_4140[]{class_4140.field_22355, class_4140.field_22475, class_4140.field_18447, class_4140.field_18449, class_4140.field_22333, class_4140.field_22357, class_4140.field_22334, class_4140.field_25813, class_4140.field_22473, class_4140.field_25814, class_4140.field_22337, class_4140.field_25159, class_4140.field_25360, class_4140.field_22346, class_4140.field_22347, class_4140.field_22349, class_4140.field_22350, class_4140.field_22474, class_4140.field_28325, class_4140.field_28327});
    private final class_1277 inventory = new class_1277(8);

    public PiglinPrisoner(class_1299<? extends class_5418> entitytype, class_1937 world) {
        super(entitytype, world);
        this.field_6194 = 5;
        this.method_5971();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236 && !this.hasTempter && this.getTempter() != null) {
            this.hasTempter = true;
            this.spawnHeartParticles();
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10566("Inventory", (class_2520)this.inventory.method_7660());
        tag.method_10569("TimeBeingRescued", this.timeBeingRescued);
        tag.method_10556("IsBeingRescued", this.isBeingRescued);
        if (this.getTempterUUID() != null) {
            tag.method_25927("Tempter", this.getTempterUUID());
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.inventory.method_7659(tag.method_10554("Inventory", 10));
        this.timeBeingRescued = tag.method_10550("TimeBeingRescued");
        this.isBeingRescued = tag.method_10577("IsBeingRescued");
        if (tag.method_25928("Tempter")) {
            UUID uuid = tag.method_25926("Tempter");
            this.setTempterUUID(uuid);
            this.hasTempter = true;
            PiglinPrisonerAi.reloadAllegiance(this, this.getTempter());
        }
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("piglinBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        PiglinPrisonerAi.updateActivity(this);
        this.timeBeingRescued = this.isBeingRescued ? ++this.timeBeingRescued : 0;
        if (this.timeBeingRescued > 75) {
            this.method_30238();
            this.finishRescue();
        }
        super.method_5958();
    }

    protected void method_6099(class_1282 source, int rand, boolean doDrop) {
        super.method_6099(source, rand, doDrop);
        this.inventory.method_24514().forEach(arg_0 -> ((PiglinPrisoner)this).method_5775(arg_0));
    }

    public void addToInventory(class_1799 stack) {
        this.inventory.method_5491(stack);
    }

    public boolean canAddToInventory(class_1799 stack) {
        return this.inventory.method_27070(stack);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        this.field_6011.method_12784(DATA_IS_DANCING, (Object)false);
        this.field_6011.method_12784(DATA_OWNERUUID_ID, Optional.empty());
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, (double)0.35f).method_26868(class_5134.field_23721, 6.0);
    }

    protected boolean method_23734() {
        return false;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_5947();
    }

    protected class_4095.class_5303<PiglinPrisoner> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return PiglinPrisonerAi.makeBrain(this, (class_4095<PiglinPrisoner>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<PiglinPrisoner> method_18868() {
        return super.method_18868();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1269 interactionresult = super.method_5992(player, hand);
        if (interactionresult.method_23665()) {
            return interactionresult;
        }
        if (!this.method_37908().field_9236) {
            return PiglinPrisonerAi.mobInteract(this, player, hand);
        }
        boolean flag = PiglinPrisonerAi.canAdmire(this, player.method_5998(hand)) && this.method_24705() != class_4837.field_22385;
        return flag ? class_1269.field_5812 : class_1269.field_5811;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return this.method_6109() ? 0.93f : 1.74f;
    }

    public double method_5621() {
        return (double)this.method_17682() * 0.92;
    }

    public boolean method_6109() {
        return false;
    }

    public int method_6110() {
        return this.field_6194;
    }

    protected void method_24694(class_3218 serverLevel) {
        PiglinPrisonerAi.cancelAdmiring(this);
        this.inventory.method_24514().forEach(arg_0 -> ((PiglinPrisoner)this).method_5775(arg_0));
        super.method_24694(serverLevel);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_CHARGING_CROSSBOW);
    }

    public void method_7110(boolean bool) {
        this.field_6011.method_12778(DATA_IS_CHARGING_CROSSBOW, (Object)bool);
    }

    public void method_24651() {
        this.field_6278 = 0;
    }

    public void method_7105(class_1309 entity, float vel) {
        this.method_24654((class_1309)this, 1.6f);
    }

    public void method_18811(class_1309 piglin, class_1799 itemstack, class_1676 projectile, float vel) {
        this.method_24652((class_1309)this, piglin, projectile, vel, 1.6f);
    }

    public boolean method_25938(class_1811 item) {
        return item == class_1802.field_8399;
    }

    @class_5996
    public class_1277 method_35199() {
        return this.inventory;
    }

    protected boolean method_26952() {
        return false;
    }

    public class_4837 method_24705() {
        if (this.isDancing()) {
            return class_4837.field_25166;
        }
        if (PiglinPrisonerAi.isLovedItem(this.method_6079())) {
            return class_4837.field_22385;
        }
        if (this.method_6510() && this.method_30237()) {
            return class_4837.field_25165;
        }
        if (this.isChargingCrossbow()) {
            return class_4837.field_22384;
        }
        return this.method_6510() && this.method_24520(is -> is.method_7909() instanceof class_1764) ? class_4837.field_22383 : class_4837.field_22386;
    }

    public boolean isDancing() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_DANCING);
    }

    public void setDancing(boolean isDancing) {
        this.field_6011.method_12778(DATA_IS_DANCING, (Object)isDancing);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean flag = super.method_5643(source, amount);
        if (this.method_37908().field_9236) {
            return false;
        }
        if (flag && source.method_5529() instanceof class_1309) {
            PiglinPrisonerAi.wasHurtBy(this, (class_1309)source.method_5529());
        }
        return flag;
    }

    public void holdInMainHand(class_1799 stack) {
        this.method_24834(class_1304.field_6173, stack);
    }

    public void holdInOffHand(class_1799 stack) {
        if (PiglinPrisonerAi.isPiglinCurrency(stack)) {
            this.method_5673(class_1304.field_6171, stack);
            this.method_25939(class_1304.field_6171);
        } else {
            this.method_24834(class_1304.field_6171, stack);
        }
    }

    public boolean method_20820(class_1799 itemstack) {
        return this.method_37908().method_8450().method_8355(class_1928.field_19388) && this.method_5936() && PiglinPrisonerAi.wantsToPickup(this, itemstack);
    }

    public boolean canReplaceCurrentItem(class_1799 replacementStack) {
        class_1304 equipmentslot = class_1308.method_32326((class_1799)replacementStack);
        class_1799 itemstack = this.method_6118(equipmentslot);
        return this.method_5955(replacementStack, itemstack);
    }

    protected boolean method_5955(class_1799 newStack, class_1799 oldStack) {
        boolean flag1;
        if (class_1890.method_8224((class_1799)oldStack)) {
            return false;
        }
        boolean flag = PiglinPrisonerAi.isLovedItem(newStack) || newStack.method_31574(class_1802.field_8399);
        boolean bl = flag1 = PiglinPrisonerAi.isLovedItem(oldStack) || oldStack.method_31574(class_1802.field_8399);
        if (flag && !flag1) {
            return true;
        }
        if (!flag && flag1) {
            return false;
        }
        return (!this.method_30236() || newStack.method_31574(class_1802.field_8399) || !oldStack.method_31574(class_1802.field_8399)) && super.method_5955(newStack, oldStack);
    }

    protected void method_5949(class_1542 itemEntity) {
        this.method_29499(itemEntity);
        PiglinPrisonerAi.pickUpItem(this, itemEntity);
    }

    protected class_3414 method_5994() {
        return this.method_37908().field_9236 ? null : (class_3414)PiglinPrisonerAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_22269;
    }

    protected class_3414 method_6002() {
        return class_3417.field_22267;
    }

    protected void method_5712(class_2338 blockpos, class_2680 blockstate) {
        this.method_5783(class_3417.field_22271, 0.15f, 1.0f);
    }

    public void method_43077(class_3414 sound) {
        this.method_5783(sound, this.method_6107(), this.method_6017());
    }

    protected void method_30238() {
        this.method_43077(class_3417.field_22272);
    }

    @Nullable
    public class_1657 getTempter() {
        try {
            UUID uuid = this.getTempterUUID();
            return uuid == null ? null : this.method_37908().method_18470(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getTempterUUID() {
        return ((Optional)this.field_6011.method_12789(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setTempterUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    @Environment(value=EnvType.CLIENT)
    public void spawnHeartParticles() {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_5974.method_43059() * 0.02;
            double d1 = this.field_5974.method_43059() * 0.02;
            double d2 = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d0, d1, d2);
        }
    }

    public void rescue() {
        PiglinPrisonerAi.startDancing(this);
        PiglinPrisonerAi.broadcastBeingRescued(this);
        class_1657 class_16572 = this.getTempter();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            class_174.field_1182.method_9124(serverPlayer, (class_1297)this);
        }
        this.isBeingRescued = true;
    }

    protected void finishRescue() {
        PiglinPrisonerAi.throwItems(this, Collections.singletonList(new class_1799((class_1935)ModItems.GILDED_NETHERITE_SHIELD)));
        class_5418 piglin = (class_5418)this.method_29243((class_1299)((Supplier)((ModWeightedEntry)ModLists.PIGLIN_PRISONER_CONVERSIONS.method_34992(this.field_5974).get()).getData()).get(), true);
        if (piglin != null) {
            piglin.method_6092(new class_1293(class_1294.field_5916, 200, 0));
            class_1657 class_16572 = this.getTempter();
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                class_174.field_1182.method_9124(serverPlayer, (class_1297)this);
            }
        }
    }
}

