/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.techreborn;

import com.kneelawk.extramodintegrations.techreborn.TREmiRecipe;
import com.kneelawk.extramodintegrations.techreborn.TRFluidSlotWidget;
import com.kneelawk.extramodintegrations.techreborn.TRIntegration;
import com.kneelawk.extramodintegrations.techreborn.TRUIUtils;
import com.kneelawk.extramodintegrations.util.LongHolder;
import com.kneelawk.extramodintegrations.util.UIUtils;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.api.recipe.recipes.IndustrialSawmillRecipe;

public class IndustrialSawmillEmiRecipe
extends TREmiRecipe<IndustrialSawmillRecipe> {
    private final List<EmiIngredient> inputsWithFluids;
    private final LongHolder capacityHolder;

    public IndustrialSawmillEmiRecipe(IndustrialSawmillRecipe recipe, LongHolder capacityHolder) {
        super(recipe);
        this.capacityHolder = capacityHolder;
        FluidInstance instance = recipe.getFluidInstance();
        long amount = instance.getAmount().getRawValue();
        this.inputsWithFluids = Stream.concat(this.inputs.stream(), Stream.of(EmiStack.of((class_3611)instance.getFluid(), (class_2487)instance.getTag(), (long)amount))).toList();
        if (amount > capacityHolder.getValue()) {
            capacityHolder.setValue(amount);
        }
    }

    public EmiRecipeCategory getCategory() {
        return TRIntegration.INDUSTRIAL_SAWMILL_CATEGORY;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return this.inputsWithFluids;
    }

    public int getDisplayWidth() {
        return 100;
    }

    public int getDisplayHeight() {
        return 56;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.getInput(0), 40, 19);
        widgets.add((Widget)new TRFluidSlotWidget(((IndustrialSawmillRecipe)this.recipe).getFluidInstance(), 16, 0, this.capacityHolder.getValue()));
        widgets.addSlot((EmiIngredient)this.getOutput(0), 82, 1).recipeContext((EmiRecipe)this);
        widgets.addSlot((EmiIngredient)this.getOutput(1), 82, 19).recipeContext((EmiRecipe)this);
        widgets.addSlot((EmiIngredient)this.getOutput(2), 82, 37).recipeContext((EmiRecipe)this);
        TRUIUtils.energyBar(widgets, this.recipe, 10, 0, 3);
        TRUIUtils.arrowRight(widgets, this.recipe, 62, 23);
        UIUtils.cookTime(widgets, ((IndustrialSawmillRecipe)this.recipe).getTime(), 40, 0);
    }
}

