/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.tconstruct.recipe.modifiers;

import com.kneelawk.extramodintegrations.tconstruct.TiCCategories;
import com.kneelawk.extramodintegrations.tconstruct.stack.ModifierEmiStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.DrawableWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4730;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierEmiRecipe
extends BasicEmiRecipe {
    protected static final class_2960 BACKGROUND_LOC = TConstruct.getResource((String)"textures/gui/jei/tinker_station.png");
    private static final List<class_2561> TEXT_FREE = Collections.singletonList(TConstruct.makeTranslation((String)"jei", (String)"modifiers.free"));
    private static final List<class_2561> TEXT_INCREMENTAL = Collections.singletonList(TConstruct.makeTranslation((String)"jei", (String)"modifiers.incremental"));
    private static final String KEY_SLOT = TConstruct.makeTranslationKey((String)"jei", (String)"modifiers.slot");
    private static final String KEY_SLOTS = TConstruct.makeTranslationKey((String)"jei", (String)"modifiers.slots");
    private static final String KEY_MAX = TConstruct.makeTranslationKey((String)"jei", (String)"modifiers.max");
    private final boolean hasRequirements;
    private final boolean isIncremental;
    private final int maxLevel;
    private final SlotType.SlotCount slots;
    private final String requirementsError;
    private final EmiIngredient toolWithoutModifier;
    private final EmiIngredient toolWithModifier;
    private final Map<SlotType, class_1058> slotTypeSprites;

    public ModifierEmiRecipe(IDisplayModifierRecipe recipe) {
        class_2960 class_29602;
        if (recipe instanceof class_1860) {
            class_1860 r = (class_1860)recipe;
            class_29602 = r.method_8114();
        } else {
            class_29602 = null;
        }
        super(TiCCategories.MODIFIERS, class_29602, 128, 77);
        this.slotTypeSprites = new HashMap<SlotType, class_1058>();
        this.inputs = List.of(EmiIngredient.of(recipe.getDisplayItems(0).stream().map(EmiStack::of).toList()), EmiIngredient.of(recipe.getDisplayItems(1).stream().map(EmiStack::of).toList()), EmiIngredient.of(recipe.getDisplayItems(2).stream().map(EmiStack::of).toList()), EmiIngredient.of(recipe.getDisplayItems(3).stream().map(EmiStack::of).toList()), EmiIngredient.of(recipe.getDisplayItems(4).stream().map(EmiStack::of).toList()));
        this.outputs = List.of(ModifierEmiStack.of(recipe.getDisplayResult()));
        this.hasRequirements = recipe.hasRequirements();
        this.isIncremental = recipe.isIncremental();
        this.maxLevel = recipe.getMaxLevel();
        this.slots = recipe.getSlots();
        this.requirementsError = recipe.getRequirementsError();
        this.toolWithoutModifier = EmiIngredient.of(recipe.getToolWithoutModifier().stream().map(EmiStack::of).toList());
        this.toolWithModifier = EmiIngredient.of(recipe.getToolWithModifier().stream().map(EmiStack::of).toList());
    }

    public List<EmiIngredient> getInputs() {
        return Stream.concat(Stream.of(this.toolWithoutModifier), this.inputs.stream()).toList();
    }

    private DrawableWidget drawSlotType(WidgetHolder widgets, int x, int y) {
        SlotType slotType = this.slots == null ? null : this.slots.getType();
        class_310 minecraft = class_310.method_1551();
        class_1058 sprite = this.slotTypeSprites.computeIfAbsent(slotType, s -> {
            class_1092 modelManager = minecraft.method_1554();
            class_1087 model = minecraft.method_1480().method_4012().method_3304((class_1792)TinkerModifiers.creativeSlotItem.get());
            if (model != null && model.method_4710() instanceof NBTKeyModel.Overrides) {
                class_4730 material = ((NBTKeyModel.Overrides)model.method_4710()).getTexture(s == null ? "slotless" : s.getName());
                return modelManager.method_24153(material.method_24144()).method_4608(material.method_24147());
            }
            return modelManager.method_24153(class_1723.field_21668).method_4608(class_1047.method_4539());
        });
        return widgets.addDrawable(x, y, 16, 16, (graphics, mouseX, mouseY, delta) -> {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
            graphics.method_25298(0, 0, 0, 16, 16, sprite);
        });
    }

    private void drawSlot(WidgetHolder widgets, List<EmiIngredient> stacks, int slot, int x, int y) {
        if (stacks.get(slot).isEmpty()) {
            widgets.addTexture(BACKGROUND_LOC, x + 1, y + 1, 16, 16, 128 + slot * 16, 0);
        }
    }

    public void addWidgets(WidgetHolder widgets) {
        int count;
        widgets.addTexture(BACKGROUND_LOC, 0, 0, 128, 77, 0, 0);
        if (this.maxLevel > 0) {
            widgets.addText((class_2561)class_2561.method_43471((String)KEY_MAX).method_27693(String.valueOf(this.maxLevel)), 66, 16, 0x808080, false);
        }
        List<class_5684> slotTypeTooltip = this.slots != null ? ((count = this.slots.getCount()) == 1 ? List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)KEY_SLOT, (Object[])new Object[]{this.slots.getType().getDisplayName()}).method_30937())) : List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)KEY_SLOTS, (Object[])new Object[]{this.slots.getType().getDisplayName()}).method_30937()))) : TEXT_FREE.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList();
        this.drawSlotType(widgets, 110, 58).tooltip(slotTypeTooltip);
        if (this.slots != null) {
            widgets.addText((class_2561)class_2561.method_43470((String)String.valueOf(this.slots.getCount())), 111, 63, 0x808080, false).horizontalAlign(TextWidget.Alignment.END);
        }
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 2, 32).drawBack(false);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), 24, 14).drawBack(false);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), 46, 32).drawBack(false);
        widgets.addSlot((EmiIngredient)this.inputs.get(3), 42, 57).drawBack(false);
        widgets.addSlot((EmiIngredient)this.inputs.get(4), 6, 57).drawBack(false);
        widgets.addSlot(this.toolWithoutModifier, 24, 37).drawBack(false);
        widgets.addSlot(this.toolWithModifier, 100, 29).drawBack(false).large(true).recipeContext((EmiRecipe)this);
        widgets.addText(((EmiStack)this.outputs.get(0)).getName(), 64, 2, -1, true).horizontalAlign(TextWidget.Alignment.CENTER);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 104, 10).drawBack(false).recipeContext((EmiRecipe)this);
        this.drawSlot(widgets, this.inputs, 0, 2, 32);
        this.drawSlot(widgets, this.inputs, 1, 24, 14);
        this.drawSlot(widgets, this.inputs, 2, 46, 32);
        this.drawSlot(widgets, this.inputs, 3, 42, 57);
        this.drawSlot(widgets, this.inputs, 4, 6, 57);
        if (this.hasRequirements) {
            widgets.addTexture(BACKGROUND_LOC, 66, 58, 16, 16, 128, 17).tooltipText(List.of(class_2561.method_43471((String)this.requirementsError)));
        }
        if (this.isIncremental) {
            widgets.addTexture(BACKGROUND_LOC, 83, 59, 16, 16, 128, 33).tooltipText(TEXT_INCREMENTAL);
        }
    }
}

