/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.tconstruct;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.kneelawk.extramodintegrations.AbstractTiCIntegration;
import com.kneelawk.extramodintegrations.tconstruct.TiCCategories;
import com.kneelawk.extramodintegrations.tconstruct.handler.CraftingStationHandler;
import com.kneelawk.extramodintegrations.tconstruct.handler.TinkerStationHandler;
import com.kneelawk.extramodintegrations.tconstruct.recipe.AlloyEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.MoldingEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.casting.CastingBasinEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.casting.CastingTableEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.entity.SeveringEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.melting.EntityMeltingEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.melting.FoundryEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.melting.MeltingEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.modifiers.ModifierEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.modifiers.ModifierWorktableEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.recipe.partbuilder.PartBuilderEmiRecipe;
import com.kneelawk.extramodintegrations.tconstruct.stack.ModifierEmiStack;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.api.widget.Bounds;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.plugin.jei.entity.DefaultEntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class TiCIntegration
extends AbstractTiCIntegration {
    @Override
    protected void registerImpl(EmiRegistry registry) {
        TiCIntegration.registerCategories(registry);
        TiCIntegration.registerComparisons(registry);
        TiCIntegration.registerEntries(registry);
        TiCIntegration.registerRecipes(registry);
        TiCIntegration.registerExclusionAreas(registry);
        TiCIntegration.registerHandlers(registry);
    }

    @Override
    protected void initializeImpl(EmiInitRegistry registry) {
        registry.addIngredientSerializer(ModifierEmiStack.class, (EmiIngredientSerializer)new ModifierEmiStack.Serializer());
    }

    private static void registerCategories(EmiRegistry registry) {
        registry.addCategory(TiCCategories.CASTING_BASIN);
        registry.addCategory(TiCCategories.CASTING_TABLE);
        registry.addCategory(TiCCategories.MOLDING);
        registry.addCategory(TiCCategories.MELTING);
        registry.addCategory(TiCCategories.ALLOY);
        registry.addCategory(TiCCategories.ENTITY_MELTING);
        registry.addCategory(TiCCategories.FOUNDRY);
        registry.addCategory(TiCCategories.MODIFIERS);
        registry.addCategory(TiCCategories.SEVERING);
        registry.addCategory(TiCCategories.PART_BUILDER);
        registry.addCategory(TiCCategories.MODIFIER_WORKTABLE);
        registry.addWorkstation(TiCCategories.PART_BUILDER, (EmiIngredient)EmiStack.of((class_1935)TinkerTables.partBuilder));
        registry.addWorkstation(TiCCategories.MODIFIERS, (EmiIngredient)EmiStack.of((class_1935)TinkerTables.tinkerStation));
        registry.addWorkstation(TiCCategories.MODIFIERS, (EmiIngredient)EmiStack.of((class_1935)TinkerTables.tinkersAnvil));
        registry.addWorkstation(TiCCategories.MODIFIERS, (EmiIngredient)EmiStack.of((class_1935)TinkerTables.scorchedAnvil));
        registry.addWorkstation(TiCCategories.MODIFIER_WORKTABLE, (EmiIngredient)EmiStack.of((class_1935)TinkerTables.modifierWorktable));
        registry.addWorkstation(TiCCategories.MELTING, (EmiIngredient)EmiStack.of((class_1935)TinkerSmeltery.searedMelter));
        registry.addWorkstation(VanillaEmiRecipeCategories.FUEL, (EmiIngredient)EmiStack.of((class_1935)TinkerSmeltery.searedHeater));
        TiCIntegration.addCastingCatalyst(registry, (class_1935)TinkerSmeltery.searedTable, TiCCategories.CASTING_TABLE, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()));
        TiCIntegration.addCastingCatalyst(registry, (class_1935)TinkerSmeltery.searedBasin, TiCCategories.CASTING_BASIN, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()));
        TiCIntegration.addCatalysts(registry, EmiStack.of((class_1935)TinkerSmeltery.smelteryController), TiCCategories.MELTING, TiCCategories.ALLOY, TiCCategories.ENTITY_MELTING);
        registry.addWorkstation(TiCCategories.ALLOY, (EmiIngredient)EmiStack.of((class_1935)TinkerSmeltery.scorchedAlloyer));
        TiCIntegration.addCastingCatalyst(registry, (class_1935)TinkerSmeltery.scorchedTable, TiCCategories.CASTING_TABLE, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()));
        TiCIntegration.addCastingCatalyst(registry, (class_1935)TinkerSmeltery.scorchedBasin, TiCCategories.CASTING_BASIN, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()));
        registry.addWorkstation(TiCCategories.FOUNDRY, (EmiIngredient)EmiStack.of((class_1935)TinkerSmeltery.foundryController));
        registry.addWorkstation(TiCCategories.SEVERING, EmiIngredient.of((class_6862)TinkerTags.Items.MELEE));
    }

    private static void registerEntries(EmiRegistry registry) {
        class_1863 manager = registry.getRecipeManager();
        List<ModifierEntry> modifiers = Collections.emptyList();
        if (((Boolean)Config.CLIENT.showModifiersInJEI.get()).booleanValue()) {
            modifiers = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.TINKER_STATION.get()), IDisplayModifierRecipe.class).stream().map(recipe -> recipe.getDisplayResult().getModifier()).distinct().sorted(Comparator.comparing(Modifier::getId)).map(mod -> new ModifierEntry(mod, 1)).collect(Collectors.toList());
        }
        modifiers.forEach(entry -> registry.addEmiStack(ModifierEmiStack.of(entry)));
        TiCIntegration.removeFluid(registry, (class_3611)TinkerFluids.moltenSoulsteel.get(), TinkerFluids.moltenSoulsteel.method_8389());
        TiCIntegration.removeFluid(registry, (class_3611)TinkerFluids.moltenKnightslime.get(), TinkerFluids.moltenKnightslime.method_8389());
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            Iterable<class_6880<class_1792>> ingot = TiCIntegration.getTag(new class_2960("c", compat.getName() + "_ingots"));
            if (!Iterables.isEmpty(ingot)) continue;
            TiCIntegration.removeFluid(registry, (class_3611)compat.getFluid().get(), compat.getBucket());
        }
        if (!FabricLoader.getInstance().isModLoaded("ceramics")) {
            TiCIntegration.removeFluid(registry, (class_3611)TinkerFluids.moltenPorcelain.get(), TinkerFluids.moltenPorcelain.method_8389());
        }
        TiCIntegration.optionalItem(registry, (class_1935)TinkerMaterials.necroniumBone, "uranium_ingots");
    }

    private static void registerRecipes(EmiRegistry registry) {
        class_1863 manager = registry.getRecipeManager();
        RecipeHelper.getJEIRecipes(manager.method_30027((class_3956)TinkerRecipeTypes.CASTING_BASIN.get()).stream(), IDisplayableCastingRecipe.class).stream().map(CastingBasinEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        RecipeHelper.getJEIRecipes(manager.method_30027((class_3956)TinkerRecipeTypes.CASTING_TABLE.get()).stream(), IDisplayableCastingRecipe.class).stream().map(CastingTableEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        List meltingRecipes = RecipeHelper.getJEIRecipes(manager.method_30027((class_3956)TinkerRecipeTypes.MELTING.get()).stream(), MeltingRecipe.class);
        meltingRecipes.forEach(meltingRecipe -> registry.addRecipe((EmiRecipe)MeltingEmiRecipe.of(meltingRecipe)));
        meltingRecipes.forEach(meltingRecipe -> registry.addRecipe((EmiRecipe)FoundryEmiRecipe.of(meltingRecipe)));
        MeltingFuelHandler.setMeltngFuels((List)RecipeHelper.getRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.FUEL.get()), MeltingFuel.class));
        List entityMeltingRecipes = manager.method_30027((class_3956)TinkerRecipeTypes.ENTITY_MELTING.get());
        Streams.concat((Stream[])new Stream[]{entityMeltingRecipes.stream(), Stream.of(new DefaultEntityMeltingRecipe(entityMeltingRecipes))}).forEach(entityMeltingRecipe -> registry.addRecipe((EmiRecipe)new EntityMeltingEmiRecipe((EntityMeltingRecipe)entityMeltingRecipe)));
        manager.method_30027((class_3956)TinkerRecipeTypes.ALLOYING.get()).forEach(alloyRecipe -> registry.addRecipe((EmiRecipe)new AlloyEmiRecipe((AlloyRecipe)alloyRecipe)));
        ImmutableList moldingRecipes = ImmutableList.builder().addAll((Iterable)manager.method_30027((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get())).addAll((Iterable)manager.method_30027((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get())).build();
        moldingRecipes.forEach(moldingRecipe -> registry.addRecipe((EmiRecipe)new MoldingEmiRecipe((MoldingRecipe)moldingRecipe)));
        RecipeHelper.getJEIRecipes(manager.method_30027((class_3956)TinkerRecipeTypes.TINKER_STATION.get()).stream(), IDisplayModifierRecipe.class).forEach(modifierRecipe -> registry.addRecipe((EmiRecipe)new ModifierEmiRecipe((IDisplayModifierRecipe)modifierRecipe)));
        manager.method_30027((class_3956)TinkerRecipeTypes.SEVERING.get()).forEach(severingRecipe -> registry.addRecipe((EmiRecipe)new SeveringEmiRecipe((SeveringRecipe)severingRecipe)));
        List materialRecipes = manager.method_30027((class_3956)TinkerRecipeTypes.MATERIAL.get());
        MaterialItemList.setRecipes((List)materialRecipes);
        RecipeHelper.getJEIRecipes(manager.method_30027((class_3956)TinkerRecipeTypes.PART_BUILDER.get()).stream(), IDisplayPartBuilderRecipe.class).forEach(partRecipe -> registry.addRecipe((EmiRecipe)PartBuilderEmiRecipe.of(partRecipe)));
        manager.method_30027((class_3956)TinkerRecipeTypes.MODIFIER_WORKTABLE.get()).forEach(iModifierWorktableRecipe -> registry.addRecipe((EmiRecipe)new ModifierWorktableEmiRecipe((IModifierWorktableRecipe)iModifierWorktableRecipe)));
    }

    private static void registerComparisons(EmiRegistry registry) {
        Comparison compareToolMaterials = Comparison.compareData(s -> MaterialIdNBT.from((class_1799)s.getItemStack()));
        Comparison comparePartMaterial = Comparison.compareData(s -> IMaterialItem.getMaterialFromStack((class_1799)s.getItemStack()));
        TiCIntegration.getTag((class_6862<class_1792>)TinkerTags.Items.TOOL_PARTS).forEach(i -> registry.setDefaultComparison(i.comp_349(), comparePartMaterial));
        registry.setDefaultComparison(TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET), compareToolMaterials);
    }

    private static void registerExclusionAreas(EmiRegistry registry) {
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (screen instanceof MultiModuleScreen) {
                MultiModuleScreen mm = (MultiModuleScreen)screen;
                mm.getModuleAreas().stream().map(r -> new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())).forEach(consumer::accept);
            }
        });
    }

    private static void registerHandlers(EmiRegistry registry) {
        registry.addRecipeHandler((class_3917)TinkerTables.craftingStationContainer.get(), (EmiRecipeHandler)new CraftingStationHandler());
        registry.addRecipeHandler((class_3917)TinkerTables.tinkerStationContainer.get(), (EmiRecipeHandler)new TinkerStationHandler());
    }

    private static void removeFluid(EmiRegistry manager, class_3611 fluid, class_1792 bucket) {
        manager.removeEmiStacks(EmiStack.of((class_3611)fluid));
        manager.removeEmiStacks(EmiStack.of((class_1935)bucket));
    }

    private static Iterable<class_6880<class_1792>> getTag(class_2960 name) {
        return TiCIntegration.getTag((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)name));
    }

    private static Iterable<class_6880<class_1792>> getTag(class_6862<class_1792> name) {
        return Objects.requireNonNull(class_7923.field_41178.method_40286(name));
    }

    private static void optionalItem(EmiRegistry manager, class_1935 item, String tagName) {
        Iterable<class_6880<class_1792>> tag = TiCIntegration.getTag(new class_2960("c", tagName));
        if (Iterables.isEmpty(tag)) {
            manager.removeEmiStacks(EmiStack.of((class_1935)item));
        }
    }

    private static void optionalCast(EmiRegistry manager, CastItemObject cast) {
        Iterable<class_6880<class_1792>> tag = TiCIntegration.getTag(new class_2960("c", cast.getName().method_12832() + "_blocks"));
        if (Iterables.isEmpty(tag)) {
            cast.values().stream().map(EmiStack::of).forEach(arg_0 -> ((EmiRegistry)manager).addEmiStack(arg_0));
        }
    }

    private static <T extends class_1860<C>, C extends class_1263> void addCastingCatalyst(EmiRegistry registry, class_1935 item, EmiRecipeCategory ownCategory, class_3956<MoldingRecipe> type) {
        EmiStack stack = EmiStack.of((class_1935)item);
        registry.addWorkstation(ownCategory, (EmiIngredient)stack);
        if (!registry.getRecipeManager().method_30027(type).isEmpty()) {
            registry.addWorkstation(TiCCategories.MOLDING, (EmiIngredient)stack);
        }
    }

    private static void addCatalysts(EmiRegistry registry, EmiStack entryStack, EmiRecipeCategory ... categoryIdentifiers) {
        for (EmiRecipeCategory categoryIdentifier : categoryIdentifiers) {
            registry.addWorkstation(categoryIdentifier, (EmiIngredient)entryStack);
        }
    }
}

