/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.appeng;

import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.kneelawk.extramodintegrations.appeng.AE2Integration;
import com.kneelawk.extramodintegrations.appeng.AE2Textures;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class InscriberEmiRecipe
implements EmiRecipe {
    private final InscriberRecipe recipe;
    private final class_2960 id;
    private final EmiIngredient middle;
    private final EmiIngredient top;
    private final EmiIngredient bottom;
    private final List<EmiIngredient> inputs;
    private final EmiStack output;

    public InscriberEmiRecipe(InscriberRecipe recipe) {
        this.recipe = recipe;
        this.id = recipe.method_8114();
        this.middle = EmiIngredient.of((class_1856)recipe.getMiddleInput());
        this.top = EmiIngredient.of((class_1856)recipe.getTopOptional());
        this.bottom = EmiIngredient.of((class_1856)recipe.getBottomOptional());
        this.output = EmiStack.of((class_1799)recipe.getResultItem());
        this.inputs = Lists.newArrayList();
        this.inputs.add(this.middle);
        this.inputs.add(this.top);
        this.inputs.add(this.bottom);
        if (recipe.getProcessType() == InscriberProcessType.INSCRIBE) {
            this.top.getEmiStacks().forEach(stack -> {
                if (!stack.isEmpty()) {
                    stack.setRemainder(stack);
                }
            });
            this.bottom.getEmiStacks().forEach(stack -> {
                if (!stack.isEmpty()) {
                    stack.setRemainder(stack);
                }
            });
        }
    }

    public EmiRecipeCategory getCategory() {
        return AE2Integration.INSCRIBER_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 97;
    }

    public int getDisplayHeight() {
        return 64;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(AE2Textures.INSCRIBER_BACKGROUND, 0, 0);
        widgets.addSlot(this.middle, 18, 23).drawBack(false);
        widgets.addSlot(this.top, 0, 0).drawBack(false).catalyst(this.recipe.getProcessType() == InscriberProcessType.INSCRIBE && !this.top.isEmpty());
        widgets.addSlot(this.bottom, 0, 46).drawBack(false).catalyst(this.recipe.getProcessType() == InscriberProcessType.INSCRIBE && !this.bottom.isEmpty());
        widgets.addSlot((EmiIngredient)this.output, 64, 20).drawBack(false).large(true).recipeContext((EmiRecipe)this);
    }
}

