/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.worldevent;

import java.util.UUID;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import team.lodestar.lodestone.network.worldevent.SyncWorldEventPacket;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.registry.common.LodestoneWorldEventTypeRegistry;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public abstract class WorldEventInstance {
    public UUID uuid = UUID.randomUUID();
    public WorldEventType type;
    public class_1937 level;
    public boolean discarded;
    public boolean dirty;
    public boolean frozen = false;

    public WorldEventInstance(WorldEventType type) {
        this.type = type;
    }

    public void sync(class_1937 level) {
        if (!level.field_9236 && this.type.isClientSynced()) {
            WorldEventInstance.sync(this);
        }
    }

    public void start(class_1937 level) {
        this.level = level;
    }

    public void tick(class_1937 level) {
    }

    public void end(class_1937 level) {
        this.discarded = true;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public class_2487 serializeNBT(class_2487 tag) {
        tag.method_25927("uuid", this.uuid);
        tag.method_10582("type", this.type.id.toString());
        tag.method_10556("discarded", this.discarded);
        tag.method_10556("frozen", this.frozen);
        return tag;
    }

    public WorldEventInstance deserializeNBT(class_2487 tag) {
        this.uuid = tag.method_25926("uuid");
        this.type = LodestoneWorldEventTypeRegistry.EVENT_TYPES.get(new class_2960(tag.method_10558("type")));
        this.discarded = tag.method_10577("discarded");
        this.frozen = tag.method_10577("frozen");
        return this;
    }

    public static <T extends WorldEventInstance> void sync(T instance) {
        LodestonePacketRegistry.LODESTONE_CHANNEL.sendToClientsInCurrentServer((S2CPacket)new SyncWorldEventPacket(instance.type.id, true, instance.serializeNBT(new class_2487())));
    }

    public static <T extends WorldEventInstance> void sync(T instance, class_3222 player) {
        LodestonePacketRegistry.LODESTONE_CHANNEL.sendToClient((S2CPacket)new SyncWorldEventPacket(instance.type.id, false, instance.serializeNBT(new class_2487())), player);
    }

    public class_2487 synchronizeNBT() {
        return this.serializeNBT(new class_2487());
    }
}

