/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.textureloader;

import java.awt.Color;
import net.minecraft.class_1011;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.easing.Easing;

public class LodestoneTextureLoader {
    protected static final ColorLerp GRADIENT = (image, x, y, luminosity, s) -> (float)(y % 16) / 16.0f;
    protected static final ColorLerp LUMINOUS_GRADIENT = (image, x, y, luminosity, s) -> ((float)(y % 16) / 16.0f + luminosity / s) / 2.0f;
    protected static final ColorLerp LUMINOUS = (image, x, y, luminosity, s) -> luminosity / s;

    public static class_1011 applyGrayscale(class_1011 nativeimage) {
        for (int x = 0; x < nativeimage.method_4307(); ++x) {
            for (int y = 0; y < nativeimage.method_4323(); ++y) {
                int pixel = nativeimage.method_4315(x, y);
                int L = (int)(0.299 * (double)(pixel & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel >> 16 & 0xFF));
                nativeimage.method_4305(x, y, class_5253.class_8045.method_48344((int)(pixel >> 24 & 0xFF), (int)L, (int)L, (int)L));
            }
        }
        return nativeimage;
    }

    public static class_1011 applyMultiColorGradient(Easing easing, class_1011 nativeimage, ColorLerp colorLerp, Color ... colors) {
        int luminosity;
        int alpha;
        int pixel;
        int y;
        int x;
        int colorCount = colors.length - 1;
        int lowestLuminosity = 255;
        int highestLuminosity = 0;
        for (x = 0; x < nativeimage.method_4307(); ++x) {
            for (y = 0; y < nativeimage.method_4323(); ++y) {
                pixel = nativeimage.method_4315(x, y);
                alpha = pixel >> 24 & 0xFF;
                if (alpha == 0) continue;
                luminosity = (int)(0.299 * (double)(pixel & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel >> 16 & 0xFF));
                if (luminosity < lowestLuminosity) {
                    lowestLuminosity = luminosity;
                }
                if (luminosity <= highestLuminosity) continue;
                highestLuminosity = luminosity;
            }
        }
        for (x = 0; x < nativeimage.method_4307(); ++x) {
            for (y = 0; y < nativeimage.method_4323(); ++y) {
                pixel = nativeimage.method_4315(x, y);
                alpha = pixel >> 24 & 0xFF;
                if (alpha == 0) continue;
                luminosity = (int)(0.299 * (double)(pixel & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel >> 16 & 0xFF));
                float pct = (float)luminosity / 255.0f;
                float newLuminosity = class_3532.method_16439((float)pct, (float)lowestLuminosity, (float)highestLuminosity);
                float lerp = 1.0f - colorLerp.lerp(pixel, x, y, newLuminosity, highestLuminosity);
                float colorIndex = (float)(2 * colorCount) * lerp;
                int index = (int)class_3532.method_15363((float)colorIndex, (float)0.0f, (float)colorCount);
                Color color = colors[index];
                Color nextColor = index == colorCount ? color : colors[index + 1];
                Color transition = ColorHelper.colorLerp(easing, colorIndex - (float)((int)colorIndex), color, nextColor);
                nativeimage.method_4305(x, y, class_5253.class_8045.method_48344((int)alpha, (int)transition.getBlue(), (int)transition.getGreen(), (int)transition.getRed()));
            }
        }
        return nativeimage;
    }

    public static interface ColorLerp {
        public float lerp(int var1, int var2, int var3, float var4, float var5);
    }

    public static interface TextureModifier {
        public class_1011 modifyTexture(class_1011 var1);
    }
}

