/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.screenshake;

import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.screenshake.ScreenshakeInstance;

public class PositionedScreenshakeInstance
extends ScreenshakeInstance {
    public final class_243 position;
    public final float falloffDistance;
    public final float maxDistance;
    public final Easing falloffEasing;

    public PositionedScreenshakeInstance(int duration, class_243 position, float falloffDistance, float maxDistance, Easing falloffEasing) {
        super(duration);
        this.position = position;
        this.falloffDistance = falloffDistance;
        this.maxDistance = maxDistance;
        this.falloffEasing = falloffEasing;
    }

    public PositionedScreenshakeInstance(int duration, class_243 position, float falloffDistance, float maxDistance) {
        this(duration, position, falloffDistance, maxDistance, Easing.LINEAR);
    }

    @Override
    public float updateIntensity(class_4184 camera, class_5819 random) {
        float intensity = super.updateIntensity(camera, random);
        float distance = (float)this.position.method_1022(camera.method_19326());
        if (distance > this.maxDistance) {
            return 0.0f;
        }
        float distanceMultiplier = 1.0f;
        if (distance > this.falloffDistance) {
            float remaining = this.maxDistance - this.falloffDistance;
            float current = distance - this.falloffDistance;
            distanceMultiplier = 1.0f - current / remaining;
        }
        Vector3f lookDirection = camera.method_19335();
        class_243 directionToScreenshake = this.position.method_1020(camera.method_19326()).method_1029();
        float angle = Math.max(0.0f, lookDirection.dot((Vector3fc)new Vector3f((float)directionToScreenshake.field_1352, (float)directionToScreenshake.field_1351, (float)directionToScreenshake.field_1350)));
        return (intensity * distanceMultiplier + intensity * angle) * 0.5f;
    }
}

