/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.ghost;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_296;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_777;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import team.lodestar.lodestone.handlers.PlacementAssistantHandler;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.systems.rendering.ghost.GhostBlockOptions;

public abstract class GhostBlockRenderer {
    public static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();
    public static final GhostBlockRenderer TRANSPARENT = new TransparentGhostBlockRenderer();

    public static GhostBlockRenderer standard() {
        return STANDARD;
    }

    public static GhostBlockRenderer transparent() {
        return TRANSPARENT;
    }

    public abstract void render(class_4587 var1, GhostBlockOptions var2);

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(class_4587 ps, GhostBlockOptions options) {
            ps.method_22903();
            class_776 dispatch = class_310.method_1551().method_1541();
            class_1087 bakedModel = dispatch.method_3349(options.blockState);
            class_1921 renderType = class_4696.method_23683((class_2680)options.blockState, (boolean)false);
            class_4588 consumer = RenderHandler.DELAYED_RENDER.getTarget().getBuffer(renderType);
            class_2338 pos = options.blockPos;
            ps.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            dispatch.method_3350().method_3367(ps.method_23760(), consumer, options.blockState, bakedModel, 1.0f, 1.0f, 1.0f, 0xF000F0, class_4608.field_21444);
            ps.method_22909();
        }
    }

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(class_4587 ps, GhostBlockOptions options) {
            ps.method_22903();
            class_310 minecraft = class_310.method_1551();
            class_776 dispatch = minecraft.method_1541();
            class_1087 bakedModel = dispatch.method_3349(options.blockState);
            class_1921 renderType = class_1921.method_23583();
            class_4588 consumer = RenderHandler.DELAYED_RENDER.getTarget().getBuffer(renderType);
            class_2338 pos = options.blockPos;
            ps.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            ps.method_22904(0.5, 0.5, 0.5);
            ps.method_22905(0.85f, 0.85f, 0.85f);
            ps.method_22904(-0.5, -0.5, -0.5);
            float alpha = options.alphaSupplier.get().floatValue() * 0.75f * PlacementAssistantHandler.getCurrentAlpha();
            TransparentGhostBlockRenderer.renderModel(ps.method_23760(), consumer, options.blockState, bakedModel, 1.0f, 1.0f, 1.0f, alpha, class_761.method_23794((class_1920)minecraft.field_1687, (class_2338)pos), class_4608.field_21444, minecraft.field_1687.method_8409());
            ps.method_22909();
        }

        public static void renderModel(class_4587.class_4665 pose, class_4588 consumer, class_2680 state, class_1087 model, float red, float green, float blue, float alpha, int packedLight, int packedOverlay, class_5819 random) {
            for (class_2350 direction : class_2350.values()) {
                random.method_43052(42L);
                TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.method_4707(state, direction, random), packedLight, packedOverlay);
            }
            random.method_43052(42L);
            TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.method_4707(state, null, random), packedLight, packedOverlay);
        }

        private static void renderQuadList(class_4587.class_4665 pose, class_4588 consumer, float red, float green, float blue, float alpha, List<class_777> quads, int packedLight, int packedOverlay) {
            for (class_777 quad : quads) {
                float b;
                float g;
                float r;
                if (quad.method_3360()) {
                    r = class_3532.method_15363((float)red, (float)0.0f, (float)1.0f);
                    g = class_3532.method_15363((float)green, (float)0.0f, (float)1.0f);
                    b = class_3532.method_15363((float)blue, (float)0.0f, (float)1.0f);
                } else {
                    r = 1.0f;
                    g = 1.0f;
                    b = 1.0f;
                }
                TransparentGhostBlockRenderer.putBulkData(consumer, pose, quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, alpha, new int[]{packedLight, packedLight, packedLight, packedLight}, packedOverlay, true);
            }
        }

        private static int findOffset(class_296 element) {
            int index = class_290.field_1590.method_1357().indexOf((Object)element);
            return index < 0 ? -1 : class_290.field_1590.getOffset(index) / 4;
        }

        static int applyBakedLighting(int packedLight, ByteBuffer data) {
            int bl = packedLight & 0xFFFF;
            int sl = packedLight >> 16 & 0xFFFF;
            int offset = TransparentGhostBlockRenderer.findOffset(class_290.field_20886) * 4;
            int blBaked = Short.toUnsignedInt(data.getShort(offset));
            int slBaked = Short.toUnsignedInt(data.getShort(offset + 2));
            bl = Math.max(bl, blBaked);
            sl = Math.max(sl, slBaked);
            return bl | sl << 16;
        }

        static void applyBakedNormals(Vector3f generated, ByteBuffer data, Matrix3f normalTransform) {
            byte nx = data.get(28);
            byte ny = data.get(29);
            byte nz = data.get(30);
            if (nx != 0 || ny != 0 || nz != 0) {
                generated.set((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
                generated.mul((Matrix3fc)normalTransform);
            }
        }

        static void putBulkData(class_4588 vertexConsumer, class_4587.class_4665 poseEntry, class_777 quad, float[] colorMuls, float red, float green, float blue, float alpha, int[] combinedLights, int combinedOverlay, boolean mulColor) {
            float[] fs = new float[]{colorMuls[0], colorMuls[1], colorMuls[2], colorMuls[3]};
            int[] is = new int[]{combinedLights[0], combinedLights[1], combinedLights[2], combinedLights[3]};
            int[] js = quad.method_3357();
            class_2382 vec3i = quad.method_3358().method_10163();
            Matrix4f matrix4f = poseEntry.method_23761();
            Vector3f vector3f = poseEntry.method_23762().transform(new Vector3f((float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260()));
            int j = js.length / 8;
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                ByteBuffer byteBuffer = memoryStack.malloc(class_290.field_1590.method_1362());
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                for (int k = 0; k < j; ++k) {
                    float q;
                    float p;
                    float o;
                    float n;
                    float m;
                    intBuffer.clear();
                    intBuffer.put(js, k * 8, 8);
                    float f = byteBuffer.getFloat(0);
                    float g = byteBuffer.getFloat(4);
                    float h = byteBuffer.getFloat(8);
                    if (mulColor) {
                        float l = (float)(byteBuffer.get(12) & 0xFF) / 255.0f;
                        m = (float)(byteBuffer.get(13) & 0xFF) / 255.0f;
                        n = (float)(byteBuffer.get(14) & 0xFF) / 255.0f;
                        o = l * fs[k] * red;
                        p = m * fs[k] * green;
                        q = n * fs[k] * blue;
                    } else {
                        o = fs[k] * red;
                        p = fs[k] * green;
                        q = fs[k] * blue;
                    }
                    int r = TransparentGhostBlockRenderer.applyBakedLighting(combinedLights[k], byteBuffer);
                    m = byteBuffer.getFloat(16);
                    n = byteBuffer.getFloat(20);
                    Vector4f vector4f = matrix4f.transform(new Vector4f(f, g, h, 1.0f));
                    TransparentGhostBlockRenderer.applyBakedNormals(vector3f, byteBuffer, poseEntry.method_23762());
                    float vertexAlpha = mulColor ? alpha * (float)(byteBuffer.get(15) & 0xFF) / 255.0f : alpha;
                    vertexConsumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), o, p, q, vertexAlpha, m, n, combinedOverlay, r, vector3f.x(), vector3f.y(), vector3f.z());
                }
            }
        }
    }
}

