/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.ghost;

import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import team.lodestar.lodestone.handlers.PlacementAssistantHandler;

public class GhostBlockOptions {
    protected final class_2680 blockState;
    protected class_2338 blockPos;
    protected Supplier<Float> alphaSupplier;
    protected Supplier<Float> scaleSupplier;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    protected class_1921 renderType = class_1921.method_23583();

    private GhostBlockOptions(class_2680 state) {
        this.blockState = state;
        this.blockPos = class_2338.field_10980;
        this.alphaSupplier = () -> Float.valueOf(PlacementAssistantHandler.getCurrentAlpha() * 0.75f);
        this.scaleSupplier = () -> Float.valueOf(1.0f);
    }

    public static GhostBlockOptions create(class_2680 state, class_2338 pos) {
        return new GhostBlockOptions(state).at(pos);
    }

    public static GhostBlockOptions create(class_2680 state) {
        return new GhostBlockOptions(state);
    }

    public static GhostBlockOptions create(class_2248 block, class_2338 pos) {
        return GhostBlockOptions.create(block.method_9564(), pos);
    }

    public static GhostBlockOptions create(class_2248 block) {
        return GhostBlockOptions.create(block.method_9564());
    }

    public GhostBlockOptions at(class_2338 pos) {
        this.blockPos = pos;
        return this;
    }

    public GhostBlockOptions at(int x, int y, int z) {
        return this.at(new class_2338(x, y, z));
    }

    public GhostBlockOptions withAlpha(Supplier<Float> alphaSupplier) {
        this.alphaSupplier = alphaSupplier;
        return this;
    }

    public GhostBlockOptions withScale(Supplier<Float> scaleSupplier) {
        this.scaleSupplier = scaleSupplier;
        return this;
    }

    public GhostBlockOptions withColor(Color color) {
        return this.withColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }

    public GhostBlockOptions withColor(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        return this;
    }

    public GhostBlockOptions withRenderType(class_1921 renderType) {
        this.renderType = renderType;
        return this;
    }
}

