/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RenderHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.rendering.trail.TrailPoint;
import team.lodestar.lodestone.systems.rendering.trail.TrailRenderPoint;

public class VFXBuilders {
    public static ScreenVFXBuilder createScreen() {
        return new ScreenVFXBuilder();
    }

    public static WorldVFXBuilder createWorld() {
        return new WorldVFXBuilder();
    }

    public static class ScreenVFXBuilder {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        int light = -1;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 1.0f;
        float y1 = 1.0f;
        int zLevel;
        class_293 format;
        Supplier<class_5944> shader = class_757::method_34542;
        class_2960 texture;
        ScreenVertexPlacementSupplier supplier;
        class_287 bufferbuilder = class_289.method_1348().method_1349();

        public ScreenVFXBuilder setPosTexDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.method_22918(l, x, y, (float)this.zLevel).method_22913(u, v).method_1344();
            this.format = class_290.field_1585;
            return this;
        }

        public ScreenVFXBuilder setPosColorDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.method_22918(l, x, y, (float)this.zLevel).method_22915(this.r, this.g, this.b, this.a).method_1344();
            this.format = class_290.field_1576;
            return this;
        }

        public ScreenVFXBuilder setPosColorTexDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.method_22918(l, x, y, (float)this.zLevel).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_1344();
            this.format = class_290.field_20887;
            return this;
        }

        public ScreenVFXBuilder setPosColorTexLightmapDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.method_22918(l, x, y, (float)this.zLevel).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_22916(this.light).method_1344();
            this.format = class_290.field_20888;
            return this;
        }

        public ScreenVFXBuilder setFormat(class_293 format) {
            this.format = format;
            return this;
        }

        public ScreenVFXBuilder setShaderTexture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public ScreenVFXBuilder setShader(Supplier<class_5944> shader) {
            this.shader = shader;
            return this;
        }

        public ScreenVFXBuilder setShader(class_5944 shader) {
            this.shader = () -> shader;
            return this;
        }

        public ScreenVFXBuilder setVertexSupplier(ScreenVertexPlacementSupplier supplier) {
            this.supplier = supplier;
            return this;
        }

        public ScreenVFXBuilder overrideBufferBuilder(class_287 builder) {
            this.bufferbuilder = builder;
            return this;
        }

        public ScreenVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public ScreenVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public ScreenVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public ScreenVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public ScreenVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public ScreenVFXBuilder setColorRaw(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public ScreenVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public ScreenVFXBuilder setPositionWithWidth(float x, float y, float width, float height) {
            return this.setPosition(x, y, x + width, y + height);
        }

        public ScreenVFXBuilder setPosition(float x0, float y0, float x1, float y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            return this;
        }

        public ScreenVFXBuilder setZLevel(int z) {
            this.zLevel = z;
            return this;
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSize) {
            return this.setUVWithWidth(u, v, width, height, canvasSize, canvasSize);
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSizeX, float canvasSizeY) {
            return this.setUVWithWidth(u / canvasSizeX, v / canvasSizeY, width / canvasSizeX, height / canvasSizeY);
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height) {
            this.u0 = u;
            this.v0 = v;
            this.u1 = u + width;
            this.v1 = v + height;
            return this;
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSize) {
            return this.setUV(u0, v0, u1, v1, canvasSize, canvasSize);
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSizeX, float canvasSizeY) {
            return this.setUV(u0 / canvasSizeX, v0 / canvasSizeY, u1 / canvasSizeX, v1 / canvasSizeY);
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public ScreenVFXBuilder blit(class_4587 stack) {
            Matrix4f last = stack.method_23760().method_23761();
            RenderSystem.setShader(this.shader);
            if (this.texture != null) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            }
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y1, this.u0, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y1, this.u1, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y0, this.u1, this.v0);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y0, this.u0, this.v0);
            return this;
        }

        public ScreenVFXBuilder draw(class_4587 stack) {
            if (this.bufferbuilder.method_22893()) {
                this.bufferbuilder.method_1326();
            }
            this.begin();
            this.blit(stack);
            this.end();
            return this;
        }

        public ScreenVFXBuilder endAndProceed() {
            return this.end().begin();
        }

        public ScreenVFXBuilder begin() {
            this.bufferbuilder.method_1328(class_293.class_5596.field_27382, this.format);
            return this;
        }

        public ScreenVFXBuilder end() {
            class_286.method_43433((class_287.class_7433)this.bufferbuilder.method_1326());
            return this;
        }

        private static interface ScreenVertexPlacementSupplier {
            public void placeVertex(class_287 var1, Matrix4f var2, float var3, float var4, float var5, float var6);
        }
    }

    public static class WorldVFXBuilder {
        protected float r = 1.0f;
        protected float g = 1.0f;
        protected float b = 1.0f;
        protected float a = 1.0f;
        protected int light = 0xF000F0;
        protected float u0 = 0.0f;
        protected float v0 = 0.0f;
        protected float u1 = 1.0f;
        protected float v1 = 1.0f;
        protected class_4597 bufferSource = RenderHandler.DELAYED_RENDER.getTarget();
        protected class_1921 renderType;
        protected class_293 format;
        protected WorldVertexConsumerActor supplier;
        protected class_4588 vertexConsumer;
        protected HashMap<Object, Consumer<WorldVFXBuilder>> modularActors = new HashMap();
        protected int modularActorAddIndex;
        protected int modularActorGetIndex;
        public static final HashMap<class_296, WorldVertexConsumerActor> CONSUMER_INFO_MAP = new HashMap();

        public WorldVFXBuilder replaceBufferSource(RenderHandler.LodestoneRenderLayer renderLayer) {
            return this.replaceBufferSource((class_4597)renderLayer.getTarget());
        }

        public WorldVFXBuilder replaceBufferSource(class_4597 bufferSource) {
            this.bufferSource = bufferSource;
            return this;
        }

        public WorldVFXBuilder setRenderType(class_1921 renderType) {
            return this.setRenderTypeRaw(renderType).setFormat(renderType.method_23031()).setVertexConsumer(this.bufferSource.getBuffer(renderType));
        }

        public WorldVFXBuilder setRenderTypeRaw(class_1921 renderType) {
            this.renderType = renderType;
            return this;
        }

        public WorldVFXBuilder setFormat(class_293 format) {
            ImmutableList elements = format.method_1357();
            return this.setFormatRaw(format).setVertexSupplier((consumer, last, builder, x, y, z, u, v) -> {
                for (class_296 element : elements) {
                    CONSUMER_INFO_MAP.get(element).placeVertex(consumer, last, this, x, y, z, u, v);
                }
                consumer.method_1344();
            });
        }

        public WorldVFXBuilder setFormatRaw(class_293 format) {
            this.format = format;
            return this;
        }

        public WorldVFXBuilder setVertexSupplier(WorldVertexConsumerActor supplier) {
            this.supplier = supplier;
            return this;
        }

        public WorldVFXBuilder setVertexConsumer(class_4588 vertexConsumer) {
            this.vertexConsumer = vertexConsumer;
            return this;
        }

        public class_4588 getVertexConsumer() {
            if (this.vertexConsumer == null) {
                this.setVertexConsumer(this.bufferSource.getBuffer(this.renderType));
            }
            return this.vertexConsumer;
        }

        public WorldVFXBuilder addModularActor(Consumer<WorldVFXBuilder> actor) {
            return this.addModularActor(this.modularActorAddIndex, actor);
        }

        public WorldVFXBuilder addModularActor(Object key, Consumer<WorldVFXBuilder> actor) {
            if (this.modularActors == null) {
                this.modularActors = new HashMap();
            }
            this.modularActors.put(key, actor);
            return this;
        }

        public Optional<HashMap<Object, Consumer<WorldVFXBuilder>>> getModularActors() {
            return Optional.ofNullable(this.modularActors);
        }

        public Optional<Consumer<WorldVFXBuilder>> getNextModularActor() {
            return Optional.ofNullable(this.modularActors).map(m -> (Consumer)m.get(this.modularActorGetIndex++));
        }

        public class_4597 getBufferSource() {
            return this.bufferSource;
        }

        public class_1921 getRenderType() {
            return this.renderType;
        }

        public class_293 getFormat() {
            return this.format;
        }

        public WorldVertexConsumerActor getSupplier() {
            return this.supplier;
        }

        public WorldVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public WorldVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public WorldVFXBuilder setColorRaw(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public WorldVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public WorldVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public WorldVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public WorldVFXBuilder renderBeam(Matrix4f last, class_2338 start, class_2338 end, float width) {
            return this.renderBeam(last, VecHelper.getCenterOf((class_2382)start), VecHelper.getCenterOf((class_2382)end), width);
        }

        public WorldVFXBuilder renderBeam(@Nullable Matrix4f last, class_243 start, class_243 end, float width) {
            class_310 minecraft = class_310.method_1551();
            class_243 cameraPosition = minecraft.method_31975().field_4344.method_19326();
            return this.renderBeam(last, start, end, width, cameraPosition);
        }

        public WorldVFXBuilder renderBeam(@Nullable Matrix4f last, class_243 start, class_243 end, float width, Consumer<WorldVFXBuilder> consumer) {
            class_310 minecraft = class_310.method_1551();
            class_243 cameraPosition = minecraft.method_31975().field_4344.method_19326();
            return this.renderBeam(last, start, end, width, cameraPosition, consumer);
        }

        public WorldVFXBuilder renderBeam(@Nullable Matrix4f last, class_243 start, class_243 end, float width, class_243 cameraPosition) {
            return this.renderBeam(last, start, end, width, cameraPosition, builder -> {});
        }

        public WorldVFXBuilder renderBeam(@Nullable Matrix4f last, class_243 start, class_243 end, float width, class_243 cameraPosition, Consumer<WorldVFXBuilder> consumer) {
            class_243 delta = end.method_1020(start);
            class_243 normal = start.method_1020(cameraPosition).method_1036(delta).method_1029().method_18805((double)(width / 2.0f), (double)(width / 2.0f), (double)(width / 2.0f));
            class_243[] positions = new class_243[]{start.method_1020(normal), start.method_1019(normal), end.method_1019(normal), end.method_1020(normal)};
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[0].field_1352, (float)positions[0].field_1351, (float)positions[0].field_1350, this.u0, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[1].field_1352, (float)positions[1].field_1351, (float)positions[1].field_1350, this.u1, this.v1);
            consumer.accept(this);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[2].field_1352, (float)positions[2].field_1351, (float)positions[2].field_1350, this.u1, this.v0);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[3].field_1352, (float)positions[3].field_1351, (float)positions[3].field_1350, this.u0, this.v0);
            return this;
        }

        public WorldVFXBuilder renderTrail(class_4587 stack, List<TrailPoint> trailSegments, float width) {
            return this.renderTrail(stack, trailSegments, (Float f) -> Float.valueOf(width), (Float f) -> {});
        }

        public WorldVFXBuilder renderTrail(class_4587 stack, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc) {
            return this.renderTrail(stack, trailSegments, widthFunc, (Float f) -> {});
        }

        public WorldVFXBuilder renderTrail(class_4587 stack, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            return this.renderTrail(stack.method_23760().method_23761(), trailSegments, widthFunc, vfxOperator);
        }

        public WorldVFXBuilder renderTrail(Matrix4f pose, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            if (trailSegments.size() < 2) {
                return this;
            }
            List<Vector4f> positions = trailSegments.stream().map(TrailPoint::getMatrixPosition).peek(p -> p.mul((Matrix4fc)pose)).toList();
            int count = trailSegments.size() - 1;
            float increment = 1.0f / (float)count;
            TrailRenderPoint[] points = new TrailRenderPoint[trailSegments.size()];
            for (int i = 1; i < count; ++i) {
                float width = widthFunc.apply(Float.valueOf(increment * (float)i)).floatValue();
                Vector4f previous = positions.get(i - 1);
                Vector4f current = positions.get(i);
                Vector4f next = positions.get(i + 1);
                points[i] = new TrailRenderPoint(current, RenderHelper.perpendicularTrailPoints(previous, next, width));
            }
            points[0] = new TrailRenderPoint(positions.get(0), RenderHelper.perpendicularTrailPoints(positions.get(0), positions.get(1), widthFunc.apply(Float.valueOf(0.0f)).floatValue()));
            points[count] = new TrailRenderPoint(positions.get(count), RenderHelper.perpendicularTrailPoints(positions.get(count - 1), positions.get(count), widthFunc.apply(Float.valueOf(1.0f)).floatValue()));
            return this.renderPoints(points, this.u0, this.v0, this.u1, this.v1, vfxOperator);
        }

        public WorldVFXBuilder renderPoints(TrailRenderPoint[] points, float u0, float v0, float u1, float v1, Consumer<Float> vfxOperator) {
            int count = points.length - 1;
            float increment = 1.0f / (float)count;
            vfxOperator.accept(Float.valueOf(0.0f));
            points[0].renderStart(this.getVertexConsumer(), this, u0, v0, u1, class_3532.method_16439((float)increment, (float)v0, (float)v1));
            for (int i = 1; i < count; ++i) {
                float current = class_3532.method_16439((float)((float)i * increment), (float)v0, (float)v1);
                vfxOperator.accept(Float.valueOf(current));
                points[i].renderMid(this.getVertexConsumer(), this, u0, current, u1, current);
            }
            vfxOperator.accept(Float.valueOf(1.0f));
            points[count].renderEnd(this.getVertexConsumer(), this, u0, class_3532.method_16439((float)((float)count * increment), (float)v0, (float)v1), u1, v1);
            return this;
        }

        public WorldVFXBuilder renderQuad(class_4587 stack, float size) {
            return this.renderQuad(stack, size, size);
        }

        public WorldVFXBuilder renderQuad(class_4587 stack, float width, float height) {
            Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f)};
            return this.renderQuad(stack, positions, width, height);
        }

        public WorldVFXBuilder renderQuad(class_4587 stack, Vector3f[] positions, float size) {
            return this.renderQuad(stack, positions, size, size);
        }

        public WorldVFXBuilder renderQuad(class_4587 stack, Vector3f[] positions, float width, float height) {
            for (Vector3f position : positions) {
                position.mul(width, height, width);
            }
            return this.renderQuad(stack.method_23760().method_23761(), positions);
        }

        public WorldVFXBuilder renderQuad(Matrix4f last, Vector3f[] positions) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.u0, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.u1, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.u1, this.v0);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.u0, this.v0);
            return this;
        }

        public WorldVFXBuilder renderSphere(class_4587 stack, float radius, int longs, int lats) {
            Matrix4f last = stack.method_23760().method_23761();
            float startU = this.u0;
            float startV = this.v0;
            float endU = (float)Math.PI * 2 * this.u1;
            float endV = (float)Math.PI * this.v1;
            float stepU = (endU - startU) / (float)longs;
            float stepV = (endV - startV) / (float)lats;
            for (int i = 0; i < longs; ++i) {
                for (int j = 0; j < lats; ++j) {
                    float u = (float)i * stepU + startU;
                    float v = (float)j * stepV + startV;
                    float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                    float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                    Vector3f p0 = RenderHelper.parametricSphere(u, v, radius);
                    Vector3f p1 = RenderHelper.parametricSphere(u, vn, radius);
                    Vector3f p2 = RenderHelper.parametricSphere(un, v, radius);
                    Vector3f p3 = RenderHelper.parametricSphere(un, vn, radius);
                    float textureU = u / endU * radius;
                    float textureV = v / endV * radius;
                    float textureUN = un / endU * radius;
                    float textureVN = vn / endV * radius;
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p0.x(), p0.y(), p0.z(), textureU, textureV);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p2.x(), p2.y(), p2.z(), textureUN, textureV);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p1.x(), p1.y(), p1.z(), textureU, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p3.x(), p3.y(), p3.z(), textureUN, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p1.x(), p1.y(), p1.z(), textureU, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p2.x(), p2.y(), p2.z(), textureUN, textureV);
                }
            }
            return this;
        }

        static {
            CONSUMER_INFO_MAP.put(class_290.field_1587, (consumer, last, builder, x, y, z, u, v) -> {
                if (last == null) {
                    consumer.method_22912((double)x, (double)y, (double)z);
                } else {
                    consumer.method_22918(last, x, y, z);
                }
            });
            CONSUMER_INFO_MAP.put(class_290.field_1581, (consumer, last, builder, x, y, z, u, v) -> consumer.method_22915(builder.r, builder.g, builder.b, builder.a));
            CONSUMER_INFO_MAP.put(class_290.field_1591, (consumer, last, builder, x, y, z, u, v) -> consumer.method_22913(u, v));
            CONSUMER_INFO_MAP.put(class_290.field_20886, (consumer, last, builder, x, y, z, u, v) -> consumer.method_22916(builder.light));
        }

        public static interface WorldVertexConsumerActor {
            public void placeVertex(class_4588 var1, Matrix4f var2, WorldVFXBuilder var3, float var4, float var5, float var6, float var7, float var8);
        }
    }
}

