/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.postprocess;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_280;
import net.minecraft.class_283;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.LodestoneLib;

public abstract class PostProcessor {
    protected static final class_310 MC = class_310.method_1551();
    public static final Collection<Pair<String, Consumer<class_284>>> COMMON_UNIFORMS = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"cameraPos", u -> u.method_34413(new Vector3f((Vector3fc)PostProcessor.MC.field_1773.method_19418().method_19326().method_46409()))), Pair.of((Object)"lookVector", u -> u.method_34413(PostProcessor.MC.field_1773.method_19418().method_19335())), Pair.of((Object)"upVector", u -> u.method_34413(PostProcessor.MC.field_1773.method_19418().method_19336())), Pair.of((Object)"leftVector", u -> u.method_34413(PostProcessor.MC.field_1773.method_19418().method_35689())), Pair.of((Object)"invViewMat", u -> {
        Matrix4f invertedViewMatrix = new Matrix4f((Matrix4fc)viewModelStack.method_23760().method_23761());
        invertedViewMatrix.invert();
        u.method_1250(invertedViewMatrix);
    }), Pair.of((Object)"invProjMat", u -> {
        Matrix4f invertedProjectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        invertedProjectionMatrix.invert();
        u.method_1250(invertedProjectionMatrix);
    }), Pair.of((Object)"nearPlaneDistance", u -> u.method_1251(0.05f)), Pair.of((Object)"farPlaneDistance", u -> u.method_1251(PostProcessor.MC.field_1773.method_32796())), Pair.of((Object)"fov", u -> u.method_1251((float)Math.toRadians(PostProcessor.MC.field_1773.method_3196(PostProcessor.MC.field_1773.method_19418(), MC.method_1488(), true)))), Pair.of((Object)"aspectRatio", u -> u.method_1251((float)MC.method_22683().method_4489() / (float)MC.method_22683().method_4506()))});
    public static class_4587 viewModelStack;
    private boolean initialized = false;
    protected class_279 postChain;
    protected class_280[] effects;
    private class_276 tempDepthBuffer;
    private Collection<Pair<class_284, Consumer<class_284>>> defaultUniforms;
    private boolean isActive = true;
    protected double time;

    public abstract class_2960 getPostChainLocation();

    public void init() {
        this.loadPostChain();
        if (this.postChain != null) {
            this.tempDepthBuffer = this.postChain.method_1264("depthMain");
            this.defaultUniforms = new ArrayList<Pair<class_284, Consumer<class_284>>>();
            for (class_280 e : this.effects) {
                for (Pair<String, Consumer<class_284>> pair : COMMON_UNIFORMS) {
                    class_284 u = e.method_1271((String)pair.getFirst());
                    if (u == null) continue;
                    this.defaultUniforms.add((Pair<class_284, Consumer<class_284>>)Pair.of((Object)u, (Object)((Consumer)pair.getSecond())));
                }
            }
        }
        this.initialized = true;
    }

    public final void loadPostChain() {
        if (this.postChain != null) {
            this.postChain.close();
            this.postChain = null;
        }
        try {
            class_2960 file = this.getPostChainLocation();
            file = new class_2960(file.method_12836(), "shaders/post/" + file.method_12832() + ".json");
            this.postChain = new class_279(MC.method_1531(), MC.method_1478(), MC.method_1522(), file);
            this.postChain.method_1259(MC.method_22683().method_4489(), MC.method_22683().method_4506());
            this.effects = (class_280[])this.postChain.field_1497.stream().map(class_283::method_1295).toArray(class_280[]::new);
        }
        catch (JsonParseException | IOException e) {
            LodestoneLib.LOGGER.error("Failed to load post-processing shader: ", e);
        }
    }

    public final void copyDepthBuffer() {
        if (this.isActive) {
            if (this.postChain == null || this.tempDepthBuffer == null) {
                return;
            }
            this.tempDepthBuffer.method_29329(MC.method_1522());
            GlStateManager._glBindFramebuffer((int)36009, (int)PostProcessor.MC.method_1522().field_1476);
        }
    }

    public void resize(int width, int height) {
        if (this.postChain != null) {
            this.postChain.method_1259(width, height);
            if (this.tempDepthBuffer != null) {
                this.tempDepthBuffer.method_1234(width, height, class_310.field_1703);
            }
        }
    }

    private void applyDefaultUniforms() {
        Arrays.stream(this.effects).forEach(e -> e.method_1275("time").method_1251((float)this.time));
        this.defaultUniforms.forEach(pair -> ((Consumer)pair.getSecond()).accept((class_284)pair.getFirst()));
    }

    public final void applyPostProcess() {
        if (this.isActive) {
            if (!this.initialized) {
                this.init();
            }
            if (this.postChain != null) {
                this.time += (double)MC.method_1534() / 20.0;
                this.applyDefaultUniforms();
                this.beforeProcess(viewModelStack);
                if (!this.isActive) {
                    return;
                }
                this.postChain.method_1258(MC.method_1488());
                GlStateManager._glBindFramebuffer((int)36009, (int)PostProcessor.MC.method_1522().field_1476);
                this.afterProcess();
            }
        }
    }

    public abstract void beforeProcess(class_4587 var1);

    public abstract void afterProcess();

    public final void setActive(boolean active) {
        this.isActive = active;
        if (!active) {
            this.time = 0.0;
        }
    }

    public final boolean isActive() {
        return this.isActive;
    }
}

