/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.world;

import java.awt.Color;
import java.util.Collection;
import java.util.function.Consumer;
import net.fabricmc.fabric.impl.client.particle.FabricSpriteProviderImpl;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class LodestoneWorldParticle
extends class_4003 {
    public final class_3999 renderType;
    public final LodestoneParticleBehavior behavior;
    public final LodestoneBehaviorComponent behaviorComponent;
    public final RenderHandler.LodestoneRenderLayer renderLayer;
    public final boolean shouldCull;
    public final FabricSpriteProviderImpl spriteSet;
    public final SimpleParticleOptions.ParticleSpritePicker spritePicker;
    public final SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType;
    public final ColorParticleData colorData;
    public final GenericParticleData transparencyData;
    public final GenericParticleData scaleData;
    public final SpinParticleData spinData;
    public final Collection<Consumer<LodestoneWorldParticle>> tickActors;
    public final Collection<Consumer<LodestoneWorldParticle>> renderActors;
    public final int particleLight;
    private boolean reachedPositiveAlpha;
    private boolean reachedPositiveScale;
    public int lifeDelay;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public LodestoneWorldParticle(class_638 world, WorldParticleOptions options, FabricSpriteProviderImpl spriteSet, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z);
        this.renderType = options.renderType;
        this.behavior = options.behavior;
        this.behaviorComponent = this.behavior.getComponent(options.behaviorComponent);
        this.renderLayer = options.renderLayer;
        this.shouldCull = options.shouldCull;
        this.spriteSet = spriteSet;
        this.spritePicker = options.spritePicker;
        this.discardFunctionType = options.discardFunctionType;
        this.colorData = options.colorData;
        this.transparencyData = GenericParticleData.constrictTransparency(options.transparencyData);
        this.scaleData = options.scaleData;
        this.spinData = options.spinData;
        this.tickActors = options.tickActors;
        this.renderActors = options.renderActors;
        this.particleLight = options.particleLight;
        this.field_3839 = options.spinData.spinOffset + options.spinData.startingValue;
        this.field_3852 = xd;
        this.field_3869 = yd;
        this.field_3850 = zd;
        this.method_3077((Integer)options.lifetimeSupplier.get());
        this.lifeDelay = (Integer)options.lifeDelaySupplier.get();
        this.field_3844 = ((Float)options.gravityStrengthSupplier.get()).floatValue();
        this.field_28786 = ((Float)options.frictionStrengthSupplier.get()).floatValue();
        this.field_3862 = !options.noClip;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r1)), (int)(255.0f * Math.min(1.0f, this.colorData.g1)), (int)(255.0f * Math.min(1.0f, this.colorData.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r2)), (int)(255.0f * Math.min(1.0f, this.colorData.g2)), (int)(255.0f * Math.min(1.0f, this.colorData.b2)), this.hsv2);
        if (spriteSet != null) {
            if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE)) {
                this.method_18140((class_4002)spriteSet);
            }
            if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.FIRST_INDEX) || this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
                this.pickSprite(0);
            }
            if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.LAST_INDEX)) {
                this.pickSprite(spriteSet.getSprites().size() - 1);
            }
        }
        options.spawnActors.forEach(actor -> actor.accept(this));
        this.updateTraits();
    }

    public SimpleParticleOptions.ParticleSpritePicker getSpritePicker() {
        return this.spritePicker;
    }

    public class_4588 getVertexConsumer(class_4588 original) {
        class_3999 class_39992;
        class_4588 consumerToUse = original;
        if (ClientConfig.DELAYED_PARTICLE_RENDERING.getConfigValue().booleanValue() && (class_39992 = this.renderType) instanceof LodestoneWorldParticleRenderType) {
            LodestoneWorldParticleRenderType lodestoneRenderType = (LodestoneWorldParticleRenderType)class_39992;
            consumerToUse = this.renderLayer.getParticleTarget().getBuffer((class_1921)lodestoneRenderType.renderType);
        }
        return consumerToUse;
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.getSprites().size() && spriteIndex >= 0) {
            this.method_18141((class_1058)this.spriteSet.getSprites().get(spriteIndex));
        }
    }

    public void pickColor(float colorCoeff) {
        float h = class_3532.method_17821((float)colorCoeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = class_3532.method_16439((float)colorCoeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = class_3532.method_16439((float)colorCoeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)class_5253.class_5254.method_27765((int)packed) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)packed) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)packed) / 255.0f;
        this.method_3084(r, g, b);
    }

    protected void updateTraits() {
        boolean shouldAttemptRemoval;
        boolean bl = shouldAttemptRemoval = this.discardFunctionType == SimpleParticleOptions.ParticleDiscardFunctionType.INVISIBLE;
        if (this.discardFunctionType == SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE && (this.scaleData.getProgress(this.field_3866, this.field_3847) > 0.5f || this.transparencyData.getProgress(this.field_3866, this.field_3847) > 0.5f)) {
            shouldAttemptRemoval = true;
        }
        if (shouldAttemptRemoval && (this.reachedPositiveAlpha && this.field_3841 <= 0.0f || this.reachedPositiveScale && this.field_17867 <= 0.0f)) {
            this.method_3085();
            return;
        }
        if (!this.reachedPositiveAlpha && this.field_3841 > 0.0f) {
            this.reachedPositiveAlpha = true;
        }
        if (!this.reachedPositiveScale && this.field_17867 > 0.0f) {
            this.reachedPositiveScale = true;
        }
        this.pickColor(this.colorData.colorCurveEasing.ease(this.colorData.getProgress(this.field_3866, this.field_3847), 0.0f, 1.0f, 1.0f));
        this.field_17867 = this.scaleData.getValue(this.field_3866, this.field_3847);
        this.field_3841 = this.transparencyData.getValue(this.field_3866, this.field_3847);
        this.field_3857 = this.field_3839;
        this.field_3839 += this.spinData.getValue(this.field_3866, this.field_3847);
        if (!this.tickActors.isEmpty()) {
            this.tickActors.forEach(a -> a.accept(this));
        }
        if (this.behaviorComponent != null) {
            this.behaviorComponent.tick(this);
        }
    }

    public int method_3068(float pPartialTick) {
        if (this.particleLight == -1) {
            return super.method_3068(pPartialTick);
        }
        return this.particleLight;
    }

    public void method_3070() {
        if (this.lifeDelay > 0) {
            --this.lifeDelay;
            return;
        }
        this.updateTraits();
        if (this.spriteSet != null && this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
            this.method_18142((class_4002)this.spriteSet);
        }
        super.method_3070();
    }

    public void method_3074(class_4588 consumer, class_4184 camera, float partialTicks) {
        if (this.lifeDelay > 0) {
            return;
        }
        this.renderActors.forEach(actor -> actor.accept(this));
        if (this.behavior != null) {
            this.behavior.render(this, this.getVertexConsumer(consumer), camera, partialTicks);
        }
    }

    public boolean shouldCull() {
        return this.shouldCull;
    }

    public class_3999 method_18122() {
        return this.renderType;
    }

    public float method_18132(float pScaleFactor) {
        return super.method_18132(pScaleFactor);
    }

    public float method_18133() {
        return super.method_18133();
    }

    public float method_18134() {
        return super.method_18134();
    }

    public float method_18135() {
        return super.method_18135();
    }

    public float method_18136() {
        return super.method_18136();
    }

    public float getRoll() {
        return this.field_3839;
    }

    public float getORoll() {
        return this.field_3857;
    }

    public float getRed() {
        return this.field_3861;
    }

    public float getGreen() {
        return this.field_3842;
    }

    public float getBlue() {
        return this.field_3859;
    }

    public float getAlpha() {
        return this.field_3841;
    }

    public double getX() {
        return this.field_3874;
    }

    public double getY() {
        return this.field_3854;
    }

    public double getZ() {
        return this.field_3871;
    }

    public double getXOld() {
        return this.field_3858;
    }

    public double getYOld() {
        return this.field_3838;
    }

    public double getZOld() {
        return this.field_3856;
    }

    public double getXMotion() {
        return this.field_3852;
    }

    public double getYMotion() {
        return this.field_3869;
    }

    public double getZMotion() {
        return this.field_3850;
    }

    public class_243 getParticlePosition() {
        return new class_243(this.getX(), this.getY(), this.getZ());
    }

    public void setParticlePosition(class_243 pos) {
        this.method_3063(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public class_243 getParticleSpeed() {
        return new class_243(this.getXMotion(), this.getYMotion(), this.getZMotion());
    }

    public void setParticleSpeed(class_243 speed) {
        this.method_34753(speed.field_1352, speed.field_1351, speed.field_1350);
    }

    public int method_3082() {
        return this.field_3847;
    }

    public int getAge() {
        return this.field_3866;
    }

    public class_5819 getRandom() {
        return this.field_3840;
    }

    public void tick(int times) {
        for (int i = 0; i < times; ++i) {
            this.method_3070();
        }
    }
}

