/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.screen.base;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneScreenParticleRenderType;

@Environment(value=EnvType.CLIENT)
public abstract class ScreenParticle {
    public final class_638 level;
    public double xOld;
    public double yOld;
    public double x;
    public double y;
    public double xMotion;
    public double yMotion;
    public double xMoved;
    public double yMoved;
    public boolean removed;
    public final class_5819 random = class_5819.method_43047();
    public int age;
    public int lifetime;
    public float gravity;
    public float size = 1.0f;
    public float rCol = 1.0f;
    public float gCol = 1.0f;
    public float bCol = 1.0f;
    public float alpha = 1.0f;
    public float roll;
    public float oRoll;
    public float friction = 0.98f;

    protected ScreenParticle(class_638 pLevel, double pX, double pY) {
        this.level = pLevel;
        this.setSize(0.2f);
        this.x = pX;
        this.y = pY;
        this.xOld = pX;
        this.yOld = pY;
        this.lifetime = (int)(4.0f / (this.random.method_43057() * 0.9f + 0.1f));
    }

    public ScreenParticle(class_638 pLevel, double pX, double pY, double pXSpeed, double pYSpeed) {
        this(pLevel, pX, pY);
        this.xMotion = pXSpeed + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.yMotion = pYSpeed + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        double d0 = (Math.random() + Math.random() + 1.0) * (double)0.15f;
        double d1 = Math.sqrt(this.xMotion * this.xMotion + this.yMotion * this.yMotion);
        this.xMotion = this.xMotion / d1 * d0 * (double)0.4f;
        this.yMotion = this.yMotion / d1 * d0 * (double)0.4f + (double)0.1f;
    }

    public void setParticleSpeed(double pXd, double pYd) {
        this.xMotion = pXd;
        this.yMotion = pYd;
    }

    public ScreenParticle setSize(float size) {
        this.size = size;
        return this;
    }

    public void setColor(float pParticleRed, float pParticleGreen, float pParticleBlue) {
        this.rCol = pParticleRed;
        this.gCol = pParticleGreen;
        this.bCol = pParticleBlue;
    }

    protected void setAlpha(float pAlpha) {
        this.alpha = pAlpha;
    }

    public void setLifetime(int pParticleLifeTime) {
        this.lifetime = pParticleLifeTime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void tick() {
        this.xOld = this.x;
        this.yOld = this.y;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yMotion -= 0.04 * (double)this.gravity;
            this.xMotion *= (double)this.friction;
            this.yMotion *= (double)this.friction;
            this.x += this.xMotion;
            this.y += this.yMotion;
            this.xMoved += this.xMotion;
            this.yMoved += this.yMotion;
        }
    }

    public abstract void render(class_287 var1);

    public abstract LodestoneScreenParticleRenderType getRenderType();

    public void remove() {
        this.removed = true;
    }

    public boolean isAlive() {
        return !this.removed;
    }
}

