/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.screen.base;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

@Environment(value=EnvType.CLIENT)
public abstract class QuadScreenParticle
extends ScreenParticle {
    protected float quadSize;

    protected QuadScreenParticle(class_638 pLevel, double pX, double pY) {
        super(pLevel, pX, pY);
        this.quadSize = 0.1f * (this.random.method_43057() * 0.5f + 0.5f) * 2.0f;
    }

    protected QuadScreenParticle(class_638 pLevel, double pX, double pY, double pXSpeed, double pYSpeed) {
        super(pLevel, pX, pY, pXSpeed, pYSpeed);
        this.quadSize = 0.1f * (this.random.method_43057() * 0.5f + 0.5f) * 2.0f;
    }

    @Override
    public void render(class_287 bufferBuilder) {
        float partialTicks = class_310.method_1551().field_1728.field_1970;
        float size = this.getQuadSize(partialTicks) * 10.0f;
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        float roll = class_3532.method_16439((float)partialTicks, (float)this.oRoll, (float)this.roll);
        Vector3f[] vectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Quaternionf rotation = new Quaternionf(new AxisAngle4f(roll, (Vector3fc)VecHelper.Vector3fHelper.ZP));
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vectors[i];
            vector3f.rotate((Quaternionfc)rotation);
            vector3f.mul(size);
            vector3f.add((float)this.x, (float)this.y, 0.0f);
        }
        float quadZ = this.getQuadZPosition();
        bufferBuilder.method_22912((double)vectors[0].x(), (double)vectors[0].y(), (double)quadZ).method_22913(u1, v1).method_22915(this.rCol, this.gCol, this.bCol, this.alpha).method_1344();
        bufferBuilder.method_22912((double)vectors[1].x(), (double)vectors[1].y(), (double)quadZ).method_22913(u1, v0).method_22915(this.rCol, this.gCol, this.bCol, this.alpha).method_1344();
        bufferBuilder.method_22912((double)vectors[2].x(), (double)vectors[2].y(), (double)quadZ).method_22913(u0, v0).method_22915(this.rCol, this.gCol, this.bCol, this.alpha).method_1344();
        bufferBuilder.method_22912((double)vectors[3].x(), (double)vectors[3].y(), (double)quadZ).method_22913(u0, v1).method_22915(this.rCol, this.gCol, this.bCol, this.alpha).method_1344();
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize;
    }

    public float getQuadZPosition() {
        return 390.0f;
    }

    protected abstract float getU0();

    protected abstract float getU1();

    protected abstract float getV0();

    protected abstract float getV1();
}

