/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.screen;

import java.awt.Color;
import java.util.function.Consumer;
import net.fabricmc.fabric.impl.client.particle.FabricSpriteProviderImpl;
import net.minecraft.class_1058;
import net.minecraft.class_287;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import org.joml.Vector3d;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.base.TextureSheetScreenParticle;

public class GenericScreenParticle
extends TextureSheetScreenParticle {
    private final LodestoneScreenParticleRenderType renderType;
    protected final FabricSpriteProviderImpl spriteSet;
    protected final SimpleParticleOptions.ParticleSpritePicker spritePicker;
    protected final SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType;
    protected final ColorParticleData colorData;
    protected final GenericParticleData transparencyData;
    protected final GenericParticleData scaleData;
    protected final SpinParticleData spinData;
    protected final Consumer<GenericScreenParticle> actor;
    private final boolean tracksStack;
    private final double stackTrackXOffset;
    private final double stackTrackYOffset;
    private boolean reachedPositiveAlpha;
    private boolean reachedPositiveScale;
    private int lifeDelay;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public GenericScreenParticle(class_638 world, ScreenParticleOptions options, FabricSpriteProviderImpl spriteSet, double x, double y, double xMotion, double yMotion) {
        super(world, x, y);
        this.renderType = options.renderType;
        this.spriteSet = spriteSet;
        this.spritePicker = options.spritePicker;
        this.discardFunctionType = options.discardFunctionType;
        this.colorData = options.colorData;
        this.transparencyData = GenericParticleData.constrictTransparency(options.transparencyData);
        this.scaleData = options.scaleData;
        this.spinData = options.spinData;
        this.actor = options.actor;
        this.tracksStack = options.tracksStack;
        this.stackTrackXOffset = options.stackTrackXOffset;
        this.stackTrackYOffset = options.stackTrackYOffset;
        this.roll = options.spinData.spinOffset + options.spinData.startingValue;
        this.xMotion = xMotion;
        this.yMotion = yMotion;
        this.setLifetime((Integer)options.lifetimeSupplier.get());
        this.lifeDelay = (Integer)options.lifeDelaySupplier.get();
        this.gravity = ((Float)options.gravityStrengthSupplier.get()).floatValue();
        this.friction = ((Float)options.frictionStrengthSupplier.get()).floatValue();
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r1)), (int)(255.0f * Math.min(1.0f, this.colorData.g1)), (int)(255.0f * Math.min(1.0f, this.colorData.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r2)), (int)(255.0f * Math.min(1.0f, this.colorData.g2)), (int)(255.0f * Math.min(1.0f, this.colorData.b2)), this.hsv2);
        this.updateTraits();
        if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE)) {
            this.pickSprite((class_4002)spriteSet);
        }
        if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.FIRST_INDEX) || this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
            this.pickSprite(0);
        }
        if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.LAST_INDEX)) {
            this.pickSprite(spriteSet.getSprites().size() - 1);
        }
        this.updateTraits();
    }

    public SimpleParticleOptions.ParticleSpritePicker getSpritePicker() {
        return this.spritePicker;
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.getSprites().size() && spriteIndex >= 0) {
            this.setSprite((class_1058)this.spriteSet.getSprites().get(spriteIndex));
        }
    }

    public void pickColor(float colorCoeff) {
        float h = class_3532.method_17821((float)colorCoeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = class_3532.method_16439((float)colorCoeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = class_3532.method_16439((float)colorCoeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)class_5253.class_5254.method_27765((int)packed) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)packed) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)packed) / 255.0f;
        this.setColor(r, g, b);
    }

    public float getCurve(float multiplier) {
        return class_3532.method_15363((float)((float)this.age * multiplier / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    protected void updateTraits() {
        boolean shouldAttemptRemoval;
        boolean bl = shouldAttemptRemoval = this.discardFunctionType == SimpleParticleOptions.ParticleDiscardFunctionType.INVISIBLE;
        if (this.discardFunctionType == SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE && (this.scaleData.getProgress(this.age, this.lifetime) > 0.5f || this.transparencyData.getProgress(this.age, this.lifetime) > 0.5f)) {
            shouldAttemptRemoval = true;
        }
        if (shouldAttemptRemoval && (this.reachedPositiveAlpha && this.alpha <= 0.0f || this.reachedPositiveScale && this.quadSize <= 0.0f)) {
            this.remove();
            return;
        }
        if (!this.reachedPositiveAlpha && this.alpha > 0.0f) {
            this.reachedPositiveAlpha = true;
        }
        if (!this.reachedPositiveScale && this.quadSize > 0.0f) {
            this.reachedPositiveScale = true;
        }
        this.pickColor(this.colorData.colorCurveEasing.ease(this.colorData.getProgress(this.age, this.lifetime), 0.0f, 1.0f, 1.0f));
        this.quadSize = this.scaleData.getValue(this.age, this.lifetime);
        this.alpha = class_3532.method_15363((float)this.transparencyData.getValue(this.age, this.lifetime), (float)0.0f, (float)1.0f);
        this.oRoll = this.roll;
        this.roll += this.spinData.getValue(this.age, this.lifetime);
        if (this.actor != null) {
            this.actor.accept(this);
        }
    }

    @Override
    public void render(class_287 bufferBuilder) {
        if (this.lifeDelay > 0) {
            return;
        }
        if (this.tracksStack) {
            this.x = (double)ScreenParticleHandler.currentItemX + this.stackTrackXOffset + this.xMoved;
            this.y = (double)ScreenParticleHandler.currentItemY + this.stackTrackYOffset + this.yMoved;
        }
        super.render(bufferBuilder);
    }

    @Override
    public void tick() {
        if (this.lifeDelay > 0) {
            --this.lifeDelay;
            return;
        }
        this.updateTraits();
        if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
            this.setSpriteFromAge((class_4002)this.spriteSet);
        }
        super.tick();
    }

    @Override
    public LodestoneScreenParticleRenderType getRenderType() {
        return this.renderType;
    }

    public void setParticleSpeed(Vector3d speed) {
        this.setParticleSpeed(speed.x, speed.y);
    }
}

