/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.render_types;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3999;
import net.minecraft.class_5944;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ShadersHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

@Environment(value=EnvType.CLIENT)
public class LodestoneWorldParticleRenderType
implements class_3999 {
    public static final Function<LodestoneWorldParticleRenderType, LodestoneWorldParticleRenderType> DEPTH_FADE = class_156.method_34866(LodestoneWorldParticleRenderType::addDepthFade);
    public static final LodestoneWorldParticleRenderType ADDITIVE = new LodestoneWorldParticleRenderType(LodestoneRenderTypeRegistry.ADDITIVE_PARTICLE, LodestoneShaderRegistry.PARTICLE, class_1059.field_17898, LodestoneRenderTypeRegistry.ADDITIVE_FUNCTION);
    public static final LodestoneWorldParticleRenderType TRANSPARENT = new LodestoneWorldParticleRenderType(LodestoneRenderTypeRegistry.TRANSPARENT_PARTICLE, LodestoneShaderRegistry.PARTICLE, class_1059.field_17898, LodestoneRenderTypeRegistry.TRANSPARENT_FUNCTION);
    public static final LodestoneWorldParticleRenderType LUMITRANSPARENT = new LodestoneWorldParticleRenderType(LodestoneRenderTypeRegistry.LUMITRANSPARENT_PARTICLE, LodestoneShaderRegistry.PARTICLE, class_1059.field_17898, LodestoneRenderTypeRegistry.TRANSPARENT_FUNCTION);
    public static final LodestoneWorldParticleRenderType TERRAIN_SHEET = new LodestoneWorldParticleRenderType(LodestoneRenderTypeRegistry.TRANSPARENT_BLOCK_PARTICLE, LodestoneShaderRegistry.PARTICLE, class_1059.field_5275, LodestoneRenderTypeRegistry.TRANSPARENT_FUNCTION);
    public static final LodestoneWorldParticleRenderType ADDITIVE_TERRAIN_SHEET = new LodestoneWorldParticleRenderType(LodestoneRenderTypeRegistry.ADDITIVE_BLOCK_PARTICLE, LodestoneShaderRegistry.PARTICLE, class_1059.field_5275, LodestoneRenderTypeRegistry.ADDITIVE_FUNCTION);
    public final LodestoneRenderType renderType;
    protected final Supplier<class_5944> shader;
    protected final class_2960 texture;
    protected final Runnable blendFunction;

    public LodestoneWorldParticleRenderType(LodestoneRenderType renderType, ShaderHolder shaderHolder, class_2960 texture, GlStateManager.class_4535 srcAlpha, GlStateManager.class_4534 dstAlpha) {
        this(renderType, shaderHolder.getInstance(), texture, srcAlpha, dstAlpha);
    }

    public LodestoneWorldParticleRenderType(LodestoneRenderType renderType, Supplier<class_5944> shader, class_2960 texture, GlStateManager.class_4535 srcAlpha, GlStateManager.class_4534 dstAlpha) {
        this(renderType, shader, texture, () -> RenderSystem.blendFunc((GlStateManager.class_4535)srcAlpha, (GlStateManager.class_4534)dstAlpha));
    }

    public LodestoneWorldParticleRenderType(LodestoneRenderType renderType, ShaderHolder shaderHolder, class_2960 texture, Runnable blendFunction) {
        this(renderType, shaderHolder.getInstance(), texture, blendFunction);
    }

    public LodestoneWorldParticleRenderType(LodestoneRenderType renderType, Supplier<class_5944> shader, class_2960 texture, Runnable blendFunction) {
        this.renderType = renderType;
        this.shader = shader;
        this.texture = texture;
        this.blendFunction = blendFunction;
    }

    public void method_18130(class_287 builder, class_1060 manager) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        this.blendFunction.run();
        RenderSystem.setShader(this.shader);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
        if (ShadersHelper.isShadersEnabled()) {
            RenderHandler.MATRIX4F = RenderSystem.getModelViewMatrix();
        }
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
    }

    public void method_18131(class_289 pTesselator) {
        pTesselator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
    }

    public LodestoneWorldParticleRenderType withDepthFade() {
        return DEPTH_FADE.apply(this);
    }

    private static LodestoneWorldParticleRenderType addDepthFade(LodestoneWorldParticleRenderType original) {
        LodestoneRenderType renderType = LodestoneRenderTypeRegistry.copyAndStore(original, original.renderType, original.equals(LUMITRANSPARENT) ? ShaderUniformHandler.LUMITRANSPARENT_DEPTH_FADE : ShaderUniformHandler.DEPTH_FADE);
        return new LodestoneWorldParticleRenderType(renderType, original.shader, original.texture, original.blendFunction);
    }
}

