/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.data.spin;

import net.minecraft.class_5819;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataBuilder;

public class SpinParticleData
extends GenericParticleData {
    public final float spinOffset;

    protected SpinParticleData(float spinOffset, float startingValue, float middleValue, float endingValue, float coefficient, Easing startToMiddleEasing, Easing middleToEndEasing) {
        super(startingValue, middleValue, endingValue, coefficient, startToMiddleEasing, middleToEndEasing);
        this.spinOffset = spinOffset;
    }

    @Override
    public SpinParticleData copy() {
        return new SpinParticleData(this.spinOffset, this.startingValue, this.middleValue, this.endingValue, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing).overrideValueMultiplier(this.valueMultiplier).overrideCoefficientMultiplier(this.coefficientMultiplier);
    }

    @Override
    public SpinParticleData bake() {
        return new SpinParticleData(this.spinOffset, this.startingValue * this.valueMultiplier, this.middleValue * this.valueMultiplier, this.endingValue * this.valueMultiplier, this.coefficient * this.coefficientMultiplier, this.startToMiddleEasing, this.middleToEndEasing);
    }

    @Override
    public SpinParticleData overrideValueMultiplier(float valueMultiplier) {
        return (SpinParticleData)super.overrideValueMultiplier(valueMultiplier);
    }

    @Override
    public SpinParticleData overrideCoefficientMultiplier(float coefficientMultiplier) {
        return (SpinParticleData)super.overrideCoefficientMultiplier(coefficientMultiplier);
    }

    public static SpinParticleDataBuilder create(float value) {
        return new SpinParticleDataBuilder(value, value, -1.0f);
    }

    public static SpinParticleDataBuilder create(float startingValue, float endingValue) {
        return new SpinParticleDataBuilder(startingValue, endingValue, -1.0f);
    }

    public static SpinParticleDataBuilder create(float startingValue, float middleValue, float endingValue) {
        return new SpinParticleDataBuilder(startingValue, middleValue, endingValue);
    }

    public static SpinParticleDataBuilder createRandomDirection(class_5819 random, float value) {
        return new SpinParticleDataBuilder(value *= random.method_43056() ? 1.0f : -1.0f, value, -1.0f);
    }

    public static SpinParticleDataBuilder createRandomDirection(class_5819 random, float startingValue, float endingValue) {
        int direction = random.method_43056() ? 1 : -1;
        return new SpinParticleDataBuilder(startingValue *= (float)direction, endingValue *= (float)direction, -1.0f);
    }

    public static SpinParticleDataBuilder createRandomDirection(class_5819 random, float startingValue, float middleValue, float endingValue) {
        int direction = random.method_43056() ? 1 : -1;
        return new SpinParticleDataBuilder(startingValue *= (float)direction, middleValue *= (float)direction, endingValue *= (float)direction);
    }
}

