/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.builder;

import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3999;
import org.joml.Vector3d;
import org.joml.Vector3f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class WorldParticleBuilder
extends AbstractParticleBuilder<WorldParticleOptions> {
    private static final Random RANDOM = new Random();
    final WorldParticleOptions options;
    boolean forceSpawn = false;
    double zMotion = 0.0;
    double maxZSpeed = 0.0;
    double maxZOffset = 0.0;

    public static WorldParticleBuilder create(LodestoneWorldParticleType particle) {
        return WorldParticleBuilder.create(particle, null);
    }

    public static WorldParticleBuilder create(LodestoneWorldParticleType particle, LodestoneBehaviorComponent behavior) {
        return WorldParticleBuilder.create(new WorldParticleOptions(particle).setBehavior(behavior));
    }

    public static WorldParticleBuilder create(RegistryObject<? extends LodestoneWorldParticleType> particle) {
        return WorldParticleBuilder.create(particle, null);
    }

    public static WorldParticleBuilder create(RegistryObject<? extends LodestoneWorldParticleType> particle, LodestoneBehaviorComponent behavior) {
        return WorldParticleBuilder.create(new WorldParticleOptions((class_2396)particle.get()).setBehavior(behavior));
    }

    public static WorldParticleBuilder create(WorldParticleOptions options) {
        return new WorldParticleBuilder(options);
    }

    protected WorldParticleBuilder(WorldParticleOptions options) {
        this.options = options;
    }

    @Override
    public WorldParticleOptions getParticleOptions() {
        return this.options;
    }

    public WorldParticleBuilder setBehavior(LodestoneBehaviorComponent behaviorComponent) {
        this.getParticleOptions().setBehavior(behaviorComponent);
        return this;
    }

    public <T extends LodestoneBehaviorComponent> Optional<T> getBehaviorComponent(Class<T> targetClass) {
        if (targetClass.isInstance(this.getParticleOptions().behaviorComponent)) {
            return Optional.of(this.getParticleOptions().behaviorComponent);
        }
        return Optional.empty();
    }

    public <T extends LodestoneBehaviorComponent> Optional<GenericParticleData> getBehaviorData(Class<T> targetClass, Function<T, GenericParticleData> dataFunction) {
        if (targetClass.isInstance(this.options.behaviorComponent)) {
            return Optional.of(dataFunction.apply(this.options.behaviorComponent));
        }
        return Optional.empty();
    }

    public <T extends LodestoneBehaviorComponent> Optional<LodestoneBehaviorComponent> getBehaviorComponent(Class<T> targetClass, Function<WorldParticleOptions, T> componentSupplier) {
        if (targetClass.isInstance(this.options.behaviorComponent)) {
            return Optional.of((LodestoneBehaviorComponent)componentSupplier.apply(this.getParticleOptions()));
        }
        return Optional.empty();
    }

    public <T extends LodestoneBehaviorComponent> WorldParticleBuilder replaceExistingBehavior(Class<T> targetClass, Function<T, LodestoneBehaviorComponent> behaviorFunction) {
        if (targetClass.isInstance(this.options.behaviorComponent)) {
            this.getParticleOptions().setBehavior(behaviorFunction.apply(this.options.behaviorComponent));
        }
        return this;
    }

    public <T extends LodestoneBehaviorComponent> WorldParticleBuilder modifyBehaviorData(Class<T> targetClass, Function<T, GenericParticleData> dataGetter, Consumer<GenericParticleData> dataConsumer) {
        if (targetClass.isInstance(this.options.behaviorComponent)) {
            dataConsumer.accept(dataGetter.apply(this.options.behaviorComponent));
        }
        return this;
    }

    public <T extends LodestoneBehaviorComponent> WorldParticleBuilder modifyBehavior(Class<T> targetClass, Consumer<T> behaviorConsumer) {
        if (targetClass.isInstance(this.options.behaviorComponent)) {
            behaviorConsumer.accept(this.options.behaviorComponent);
        }
        return this;
    }

    public WorldParticleBuilder modifyData(GenericParticleData dataType, Consumer<GenericParticleData> dataConsumer) {
        dataConsumer.accept(dataType);
        return this;
    }

    public WorldParticleBuilder modifyData(Supplier<GenericParticleData> dataType, Consumer<GenericParticleData> dataConsumer) {
        return this.modifyData(dataType.get(), dataConsumer);
    }

    public WorldParticleBuilder modifyData(Function<WorldParticleBuilder, GenericParticleData> dataType, Consumer<GenericParticleData> dataConsumer) {
        this.modifyData(dataType.apply(this), dataConsumer);
        return this;
    }

    public WorldParticleBuilder modifyOptionalData(Optional<GenericParticleData> dataType, Consumer<GenericParticleData> dataConsumer) {
        dataType.ifPresent(dataConsumer);
        return this;
    }

    public WorldParticleBuilder modifyOptionalData(Function<WorldParticleBuilder, Optional<GenericParticleData>> dataType, Consumer<GenericParticleData> dataConsumer) {
        this.modifyOptionalData(dataType.apply(this), dataConsumer);
        return this;
    }

    public final WorldParticleBuilder modifyData(Collection<Supplier<GenericParticleData>> dataTypes, Consumer<GenericParticleData> dataConsumer) {
        for (Supplier<GenericParticleData> dataFunction : dataTypes) {
            dataConsumer.accept(dataFunction.get());
        }
        return this;
    }

    public WorldParticleBuilder enableNoClip() {
        return this.setNoClip(true);
    }

    public WorldParticleBuilder disableNoClip() {
        return this.setNoClip(false);
    }

    public WorldParticleBuilder setNoClip(boolean noClip) {
        this.getParticleOptions().noClip = noClip;
        return this;
    }

    public WorldParticleBuilder setRenderType(class_3999 renderType) {
        this.getParticleOptions().renderType = renderType;
        return this;
    }

    public WorldParticleBuilder setRenderTarget(RenderHandler.LodestoneRenderLayer renderLayer) {
        this.getParticleOptions().renderLayer = renderLayer;
        return this;
    }

    public WorldParticleBuilder enableForcedSpawn() {
        return this.setForceSpawn(true);
    }

    public WorldParticleBuilder disableForcedSpawn() {
        return this.setForceSpawn(false);
    }

    public WorldParticleBuilder setForceSpawn(boolean forceSpawn) {
        this.forceSpawn = forceSpawn;
        return this;
    }

    public WorldParticleBuilder enableCull() {
        return this.setShouldCull(true);
    }

    public WorldParticleBuilder disableCull() {
        return this.setShouldCull(false);
    }

    public WorldParticleBuilder setShouldCull(boolean shouldCull) {
        this.getParticleOptions().shouldCull = shouldCull;
        return this;
    }

    public WorldParticleBuilder setRandomMotion(double maxSpeed) {
        return this.setRandomMotion(maxSpeed, maxSpeed, maxSpeed);
    }

    public WorldParticleBuilder setRandomMotion(double maxHSpeed, double maxVSpeed) {
        return this.setRandomMotion(maxHSpeed, maxVSpeed, maxHSpeed);
    }

    public WorldParticleBuilder setRandomMotion(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
        this.maxXSpeed = maxXSpeed;
        this.maxYSpeed = maxYSpeed;
        this.maxZSpeed = maxZSpeed;
        return this;
    }

    public WorldParticleBuilder addMotion(Vector3f motion) {
        return this.addMotion(motion.x(), motion.y(), motion.z());
    }

    public WorldParticleBuilder addMotion(class_243 motion) {
        return this.addMotion(motion.field_1352, motion.field_1351, motion.field_1350);
    }

    public WorldParticleBuilder addMotion(double vx, double vy, double vz) {
        this.xMotion += vx;
        this.yMotion += vy;
        this.zMotion += vz;
        return this;
    }

    public WorldParticleBuilder setMotion(Vector3f motion) {
        return this.setMotion(motion.x(), motion.y(), motion.z());
    }

    public WorldParticleBuilder setMotion(class_243 motion) {
        return this.setMotion(motion.field_1352, motion.field_1351, motion.field_1350);
    }

    public WorldParticleBuilder setMotion(double vx, double vy, double vz) {
        this.xMotion = vx;
        this.yMotion = vy;
        this.zMotion = vz;
        return this;
    }

    public WorldParticleBuilder setRandomOffset(double maxDistance) {
        return this.setRandomOffset(maxDistance, maxDistance, maxDistance);
    }

    public WorldParticleBuilder setRandomOffset(double maxHDist, double maxVDist) {
        return this.setRandomOffset(maxHDist, maxVDist, maxHDist);
    }

    public WorldParticleBuilder setRandomOffset(double maxXDist, double maxYDist, double maxZDist) {
        this.maxXOffset = maxXDist;
        this.maxYOffset = maxYDist;
        this.maxZOffset = maxZDist;
        return this;
    }

    public WorldParticleBuilder act(Consumer<WorldParticleBuilder> particleBuilderConsumer) {
        particleBuilderConsumer.accept(this);
        return this;
    }

    public WorldParticleBuilder addTickActor(Consumer<LodestoneWorldParticle> particleActor) {
        this.getParticleOptions().tickActors.add(particleActor);
        return this;
    }

    public WorldParticleBuilder addSpawnActor(Consumer<LodestoneWorldParticle> particleActor) {
        this.getParticleOptions().spawnActors.add(particleActor);
        return this;
    }

    public WorldParticleBuilder addRenderActor(Consumer<LodestoneWorldParticle> particleActor) {
        this.getParticleOptions().renderActors.add(particleActor);
        return this;
    }

    public WorldParticleBuilder clearActors() {
        return this.clearTickActor().clearSpawnActors().clearRenderActors();
    }

    public WorldParticleBuilder clearTickActor() {
        this.getParticleOptions().tickActors.clear();
        return this;
    }

    public WorldParticleBuilder clearSpawnActors() {
        this.getParticleOptions().spawnActors.clear();
        return this;
    }

    public WorldParticleBuilder clearRenderActors() {
        this.getParticleOptions().renderActors.clear();
        return this;
    }

    public WorldParticleBuilder setNaturalLighting() {
        return this.setLightLevel(-1);
    }

    public WorldParticleBuilder setFullBrightLighting() {
        return this.setLightLevel(0xF000F0);
    }

    public WorldParticleBuilder setLightLevel(int particleLight) {
        this.options.particleLight = particleLight;
        return this;
    }

    public WorldParticleBuilder spawn(class_1937 level, double x, double y, double z) {
        double yaw = (double)RANDOM.nextFloat() * Math.PI * 2.0;
        double pitch = (double)RANDOM.nextFloat() * Math.PI - 1.5707963267948966;
        double xSpeed = (double)RANDOM.nextFloat() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.nextFloat() * this.maxYSpeed;
        double zSpeed = (double)RANDOM.nextFloat() * this.maxZSpeed;
        this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
        this.yMotion += Math.sin(pitch) * ySpeed;
        this.zMotion += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
        double yaw2 = (double)RANDOM.nextFloat() * Math.PI * 2.0;
        double pitch2 = (double)RANDOM.nextFloat() * Math.PI - 1.5707963267948966;
        double xDist = (double)RANDOM.nextFloat() * this.maxXOffset;
        double yDist = (double)RANDOM.nextFloat() * this.maxYOffset;
        double zDist = (double)RANDOM.nextFloat() * this.maxZOffset;
        double xPos = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
        double yPos = Math.sin(pitch2) * yDist;
        double zPos = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
        level.method_8466((class_2394)this.getParticleOptions(), this.forceSpawn, x + xPos, y + yPos, z + zPos, this.xMotion, this.yMotion, this.zMotion);
        return this;
    }

    public WorldParticleBuilder repeat(class_1937 level, double x, double y, double z, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawn(level, x, y, z);
        }
        return this;
    }

    public WorldParticleBuilder surroundBlock(class_1937 level, class_2338 pos, class_2350 ... directions) {
        if (directions.length == 0) {
            directions = class_2350.values();
        }
        for (class_2350 direction : directions) {
            double yaw = (double)RANDOM.nextFloat() * Math.PI * 2.0;
            double pitch = (double)RANDOM.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)RANDOM.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)RANDOM.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)RANDOM.nextFloat() * this.maxZSpeed;
            this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.yMotion += Math.sin(pitch) * ySpeed;
            this.zMotion += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            class_2350.class_2351 direction$axis = direction.method_10166();
            double d0 = 0.5625;
            double xPos = direction$axis == class_2350.class_2351.field_11048 ? 0.5 + d0 * (double)direction.method_10148() : RANDOM.nextDouble();
            double yPos = direction$axis == class_2350.class_2351.field_11052 ? 0.5 + d0 * (double)direction.method_10164() : RANDOM.nextDouble();
            double zPos = direction$axis == class_2350.class_2351.field_11051 ? 0.5 + d0 * (double)direction.method_10165() : RANDOM.nextDouble();
            level.method_8466((class_2394)this.getParticleOptions(), this.forceSpawn, (double)pos.method_10263() + xPos, (double)pos.method_10264() + yPos, (double)pos.method_10260() + zPos, this.xMotion, this.yMotion, this.zMotion);
        }
        return this;
    }

    public WorldParticleBuilder repeatSurroundBlock(class_1937 level, class_2338 pos, int n) {
        for (int i = 0; i < n; ++i) {
            this.surroundBlock(level, pos, new class_2350[0]);
        }
        return this;
    }

    public WorldParticleBuilder repeatSurroundBlock(class_1937 level, class_2338 pos, int n, class_2350 ... directions) {
        for (int i = 0; i < n; ++i) {
            this.surroundBlock(level, pos, directions);
        }
        return this;
    }

    public WorldParticleBuilder surroundVoxelShape(class_1937 level, class_2338 pos, class_265 voxelShape, int max) {
        int[] c = new int[1];
        int perBoxMax = max / voxelShape.method_1090().size();
        Supplier<Boolean> r = () -> {
            c[0] = c[0] + 1;
            if (c[0] >= perBoxMax) {
                c[0] = 0;
                return true;
            }
            return false;
        };
        class_243 v = BlockHelper.fromBlockPos(pos);
        voxelShape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            class_243 b = v.method_1031(x1, y1, z1);
            class_243 e = v.method_1031(x2, y2, z2);
            ArrayList<Runnable> runs = new ArrayList<Runnable>();
            runs.add(() -> this.spawnLine(level, b, v.method_1031(x2, y1, z1)));
            runs.add(() -> this.spawnLine(level, b, v.method_1031(x1, y2, z1)));
            runs.add(() -> this.spawnLine(level, b, v.method_1031(x1, y1, z2)));
            runs.add(() -> this.spawnLine(level, v.method_1031(x1, y2, z1), v.method_1031(x2, y2, z1)));
            runs.add(() -> this.spawnLine(level, v.method_1031(x1, y2, z1), v.method_1031(x1, y2, z2)));
            runs.add(() -> this.spawnLine(level, e, v.method_1031(x2, y2, z1)));
            runs.add(() -> this.spawnLine(level, e, v.method_1031(x1, y2, z2)));
            runs.add(() -> this.spawnLine(level, e, v.method_1031(x2, y1, z2)));
            runs.add(() -> this.spawnLine(level, v.method_1031(x2, y1, z1), v.method_1031(x2, y1, z2)));
            runs.add(() -> this.spawnLine(level, v.method_1031(x1, y1, z2), v.method_1031(x2, y1, z2)));
            runs.add(() -> this.spawnLine(level, v.method_1031(x2, y1, z1), v.method_1031(x2, y2, z1)));
            runs.add(() -> this.spawnLine(level, v.method_1031(x1, y1, z2), v.method_1031(x1, y2, z2)));
            Collections.shuffle(runs);
            for (Runnable runnable : runs) {
                runnable.run();
                if (!((Boolean)r.get()).booleanValue()) continue;
                break;
            }
        });
        return this;
    }

    public WorldParticleBuilder surroundVoxelShape(class_1937 level, class_2338 pos, class_2680 state, int max) {
        class_265 voxelShape = state.method_26218((class_1922)level, pos);
        if (voxelShape.method_1110()) {
            voxelShape = class_259.method_1077();
        }
        return this.surroundVoxelShape(level, pos, voxelShape, max);
    }

    public WorldParticleBuilder spawnAtRandomFace(class_1937 level, class_2338 pos) {
        class_2350 direction = class_2350.values()[RANDOM.nextInt(class_2350.values().length)];
        double yaw = (double)RANDOM.nextFloat() * Math.PI * 2.0;
        double pitch = (double)RANDOM.nextFloat() * Math.PI - 1.5707963267948966;
        double xSpeed = (double)RANDOM.nextFloat() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.nextFloat() * this.maxYSpeed;
        double zSpeed = (double)RANDOM.nextFloat() * this.maxZSpeed;
        this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
        this.yMotion += Math.sin(pitch) * ySpeed;
        this.zMotion += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
        class_2350.class_2351 direction$axis = direction.method_10166();
        double d0 = 0.5625;
        double xPos = direction$axis == class_2350.class_2351.field_11048 ? 0.5 + d0 * (double)direction.method_10148() : RANDOM.nextDouble();
        double yPos = direction$axis == class_2350.class_2351.field_11052 ? 0.5 + d0 * (double)direction.method_10164() : RANDOM.nextDouble();
        double zPos = direction$axis == class_2350.class_2351.field_11051 ? 0.5 + d0 * (double)direction.method_10165() : RANDOM.nextDouble();
        level.method_8466((class_2394)this.getParticleOptions(), this.forceSpawn, (double)pos.method_10263() + xPos, (double)pos.method_10264() + yPos, (double)pos.method_10260() + zPos, this.xMotion, this.yMotion, this.zMotion);
        return this;
    }

    public WorldParticleBuilder repeatRandomFace(class_1937 level, class_2338 pos, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawnAtRandomFace(level, pos);
        }
        return this;
    }

    public WorldParticleBuilder createCircle(class_1937 level, double x, double y, double z, double distance, double currentCount, double totalCount) {
        double xSpeed = (double)RANDOM.nextFloat() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.nextFloat() * this.maxYSpeed;
        double zSpeed = (double)RANDOM.nextFloat() * this.maxZSpeed;
        double theta = Math.PI * 2 / totalCount;
        double finalAngle = currentCount / totalCount + theta * currentCount;
        double dx2 = distance * Math.cos(finalAngle);
        double dz2 = distance * Math.sin(finalAngle);
        Vector3d vector2f = new Vector3d(dx2, 0.0, dz2);
        this.xMotion = vector2f.x * xSpeed;
        this.zMotion = vector2f.z * zSpeed;
        double yaw2 = (double)RANDOM.nextFloat() * Math.PI * 2.0;
        double pitch2 = (double)RANDOM.nextFloat() * Math.PI - 1.5707963267948966;
        double xDist = (double)RANDOM.nextFloat() * this.maxXOffset;
        double yDist = (double)RANDOM.nextFloat() * this.maxYOffset;
        double zDist = (double)RANDOM.nextFloat() * this.maxZOffset;
        double xPos = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
        double yPos = Math.sin(pitch2) * yDist;
        double zPos = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
        level.method_8466((class_2394)this.getParticleOptions(), this.forceSpawn, x + xPos + dx2, y + yPos, z + zPos + dz2, this.xMotion, ySpeed, this.zMotion);
        return this;
    }

    public WorldParticleBuilder repeatCircle(class_1937 level, double x, double y, double z, double distance, int times) {
        for (int i = 0; i < times; ++i) {
            this.createCircle(level, x, y, z, distance, i, times);
        }
        return this;
    }

    public WorldParticleBuilder createBlockOutline(class_1937 level, class_2338 pos, class_2680 state) {
        class_265 voxelShape = state.method_26218((class_1922)level, pos);
        double d = 0.25;
        voxelShape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            class_243 v = BlockHelper.fromBlockPos(pos);
            class_243 b = BlockHelper.fromBlockPos(pos).method_1031(x1, y1, z1);
            class_243 e = BlockHelper.fromBlockPos(pos).method_1031(x2, y2, z2);
            this.spawnLine(level, b, v.method_1031(x2, y1, z1));
            this.spawnLine(level, b, v.method_1031(x1, y2, z1));
            this.spawnLine(level, b, v.method_1031(x1, y1, z2));
            this.spawnLine(level, v.method_1031(x1, y2, z1), v.method_1031(x2, y2, z1));
            this.spawnLine(level, v.method_1031(x1, y2, z1), v.method_1031(x1, y2, z2));
            this.spawnLine(level, e, v.method_1031(x2, y2, z1));
            this.spawnLine(level, e, v.method_1031(x1, y2, z2));
            this.spawnLine(level, e, v.method_1031(x2, y1, z2));
            this.spawnLine(level, v.method_1031(x2, y1, z1), v.method_1031(x2, y1, z2));
            this.spawnLine(level, v.method_1031(x1, y1, z2), v.method_1031(x2, y1, z2));
            this.spawnLine(level, v.method_1031(x2, y1, z1), v.method_1031(x2, y2, z1));
            this.spawnLine(level, v.method_1031(x1, y1, z2), v.method_1031(x1, y2, z2));
        });
        return this;
    }

    public WorldParticleBuilder spawnLine(class_1937 level, class_243 one, class_243 two) {
        double yaw = (double)RANDOM.nextFloat() * Math.PI * 2.0;
        double pitch = (double)RANDOM.nextFloat() * Math.PI - 1.5707963267948966;
        double xSpeed = (double)RANDOM.nextFloat() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.nextFloat() * this.maxYSpeed;
        double zSpeed = (double)RANDOM.nextFloat() * this.maxZSpeed;
        this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
        this.yMotion += Math.sin(pitch) * ySpeed;
        this.zMotion += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
        class_243 pos = one.method_35590(two, RANDOM.nextDouble());
        level.method_8466((class_2394)this.getParticleOptions(), this.forceSpawn, pos.field_1352, pos.field_1351, pos.field_1350, this.xMotion, this.yMotion, this.zMotion);
        return this;
    }

    public WorldParticleBuilder modifyColorData(Consumer<ColorParticleData> dataConsumer) {
        return (WorldParticleBuilder)super.modifyColorData(dataConsumer);
    }

    public WorldParticleBuilder setColorData(ColorParticleData colorData) {
        return (WorldParticleBuilder)super.setColorData(colorData);
    }

    public WorldParticleBuilder setScaleData(GenericParticleData scaleData) {
        return (WorldParticleBuilder)super.setScaleData(scaleData);
    }

    public WorldParticleBuilder setTransparencyData(GenericParticleData transparencyData) {
        return (WorldParticleBuilder)super.setTransparencyData(transparencyData);
    }

    public WorldParticleBuilder setSpinData(SpinParticleData spinData) {
        return (WorldParticleBuilder)super.setSpinData(spinData);
    }

    public WorldParticleBuilder multiplyGravity(float gravityMultiplier) {
        return (WorldParticleBuilder)super.multiplyGravity(gravityMultiplier);
    }

    public WorldParticleBuilder modifyGravity(Function<Float, Supplier<Float>> gravityReplacement) {
        return (WorldParticleBuilder)super.modifyGravity(gravityReplacement);
    }

    public WorldParticleBuilder setGravityStrength(float gravity) {
        return (WorldParticleBuilder)super.setGravityStrength(gravity);
    }

    public WorldParticleBuilder setGravityStrength(Supplier<Float> gravityStrengthSupplier) {
        return (WorldParticleBuilder)super.setGravityStrength(gravityStrengthSupplier);
    }

    public WorldParticleBuilder multiplyFriction(float GravityMultiplier) {
        return (WorldParticleBuilder)super.multiplyFriction(GravityMultiplier);
    }

    public WorldParticleBuilder modifyFriction(Function<Float, Supplier<Float>> GravityReplacement) {
        return (WorldParticleBuilder)super.modifyFriction(GravityReplacement);
    }

    public WorldParticleBuilder setFrictionStrength(float Gravity) {
        return (WorldParticleBuilder)super.setFrictionStrength(Gravity);
    }

    public WorldParticleBuilder setFrictionStrength(Supplier<Float> GravityStrengthSupplier) {
        return (WorldParticleBuilder)super.setFrictionStrength(GravityStrengthSupplier);
    }

    public WorldParticleBuilder multiplyLifetime(float lifetimeMultiplier) {
        return (WorldParticleBuilder)super.multiplyLifetime(lifetimeMultiplier);
    }

    public WorldParticleBuilder modifyLifetime(Function<Integer, Supplier<Integer>> lifetimeReplacement) {
        return (WorldParticleBuilder)super.modifyLifetime(lifetimeReplacement);
    }

    public WorldParticleBuilder setLifetime(int lifetime) {
        return (WorldParticleBuilder)super.setLifetime(lifetime);
    }

    public WorldParticleBuilder setLifetime(Supplier<Integer> lifetimeSupplier) {
        return (WorldParticleBuilder)super.setLifetime(lifetimeSupplier);
    }

    public WorldParticleBuilder multiplyLifeDelay(float lifeDelayMultiplier) {
        return (WorldParticleBuilder)super.multiplyLifeDelay(lifeDelayMultiplier);
    }

    public WorldParticleBuilder modifyLifeDelay(Function<Integer, Supplier<Integer>> lifeDelayReplacement) {
        return (WorldParticleBuilder)super.modifyLifeDelay(lifeDelayReplacement);
    }

    public WorldParticleBuilder setLifeDelay(int lifeDelay) {
        return (WorldParticleBuilder)super.setLifeDelay(lifeDelay);
    }

    public WorldParticleBuilder setLifeDelay(Supplier<Integer> lifeDelaySupplier) {
        return (WorldParticleBuilder)super.setLifeDelay(lifeDelaySupplier);
    }

    public WorldParticleBuilder setSpritePicker(SimpleParticleOptions.ParticleSpritePicker spritePicker) {
        return (WorldParticleBuilder)super.setSpritePicker(spritePicker);
    }

    public WorldParticleBuilder setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType) {
        return (WorldParticleBuilder)super.setDiscardFunction(discardFunctionType);
    }
}

