/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.obj.lod;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.systems.model.obj.ObjModel;
import team.lodestar.lodestone.systems.model.obj.lod.LODBuilder;
import team.lodestar.lodestone.systems.model.obj.lod.LevelOfDetail;

public abstract class LODStrategy<T>
implements LODBuilder<T> {
    public List<LevelOfDetail<T>> levelsOfDetail = new ArrayList<LevelOfDetail<T>>();

    public static LODStrategy<Float> Distance(LODBuilderSetup<Float> lodBuilderSetup) {
        return new DistanceLODStrategy(lodBuilderSetup);
    }

    public static LODStrategy<Integer> Performance(LODBuilderSetup<Integer> lodBuilderSetup) {
        return new PerformanceLODStrategy(lodBuilderSetup);
    }

    public abstract LevelOfDetail<T> getLODLevel(Vector3f var1);

    public LODStrategy(LODBuilderSetup<T> lodBuilderSetup) {
        lodBuilderSetup.lodBuilder(this);
    }

    private static class DistanceLODStrategy
    extends LODStrategy<Float> {
        public DistanceLODStrategy(LODBuilderSetup<Float> lodBuilderSetup) {
            super(lodBuilderSetup);
        }

        @Override
        public LevelOfDetail<Float> getLODLevel(Vector3f modelPosition) {
            Vector3f cameraPosition = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
            float distanceSq = cameraPosition.distanceSquared((Vector3fc)modelPosition);
            for (LevelOfDetail levelOfDetail : this.levelsOfDetail) {
                if (!(distanceSq <= ((Float)levelOfDetail.getArgument()).floatValue())) continue;
                return levelOfDetail;
            }
            return (LevelOfDetail)this.levelsOfDetail.get(this.levelsOfDetail.size() - 1);
        }

        @Override
        public void create(Float argument, class_2960 modelLocation) {
            this.levelsOfDetail.add(new LevelOfDetail<Float>(new ObjModel(modelLocation), argument));
        }
    }

    public static interface LODBuilderSetup<T> {
        public void lodBuilder(LODBuilder<T> var1);
    }

    private static class PerformanceLODStrategy
    extends LODStrategy<Integer> {
        public PerformanceLODStrategy(LODBuilderSetup<Integer> lodBuilderSetup) {
            super(lodBuilderSetup);
        }

        @Override
        public LevelOfDetail<Integer> getLODLevel(Vector3f modelPosition) {
            int fps = class_310.method_1551().method_47599();
            int monitorRefreshRate = class_310.method_1551().method_22683().method_22092();
            int optionsRefreshRate = (Integer)class_310.method_1551().field_1690.method_42524().method_41753();
            int steps = this.levelsOfDetail.size();
            int step = Math.min(steps - 1, (int)Math.floor((double)fps / (double)monitorRefreshRate * (double)steps));
            return (LevelOfDetail)this.levelsOfDetail.get(step);
        }

        @Override
        public void create(Integer argument, class_2960 modelLocation) {
            this.levelsOfDetail.add(new LevelOfDetail<Integer>(new ObjModel(modelLocation), argument));
        }
    }
}

