/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.obj;

import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.systems.model.obj.Vertex;

public record Face(List<Vertex> vertices) {
    public void renderFace(class_4587 poseStack, class_1921 renderType, int packedLight) {
        class_4597.class_4598 mcBufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 buffer = mcBufferSource.getBuffer(renderType);
        int vertexCount = this.vertices.size();
        if (vertexCount == 4) {
            this.renderQuad(poseStack, buffer, packedLight);
        } else if (vertexCount == 3) {
            this.renderTriangle(poseStack, buffer, packedLight);
        } else {
            throw new RuntimeException("Face has invalid number of vertices. Supported vertex counts are 3 and 4.");
        }
    }

    public void renderTriangle(class_4587 poseStack, class_4588 buffer, int packedLight) {
        this.vertices().forEach(vertex -> this.addVertex(buffer, (Vertex)vertex, poseStack, packedLight));
        this.addVertex(buffer, this.vertices().get(0), poseStack, packedLight);
    }

    public void renderQuad(class_4587 poseStack, class_4588 buffer, int packedLight) {
        this.vertices().forEach(vertex -> this.addVertex(buffer, (Vertex)vertex, poseStack, packedLight));
    }

    private void addVertex(class_4588 buffer, Vertex vertex, class_4587 poseStack, int packedLight) {
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        Matrix3f normalMatrix = poseStack.method_23760().method_23762();
        Vector3f position = vertex.position();
        Vector3f normal = vertex.normal();
        class_241 uv = vertex.uv();
        buffer.method_22918(matrix4f, position.x(), position.y(), position.z()).method_1336(255, 255, 255, 255).method_22913(uv.field_1343, -uv.field_1342).method_22922(class_4608.field_21444).method_23763(normalMatrix, normal.x(), normal.y(), normal.z()).method_22916(packedLight).method_1344();
    }

    public Vector3f getCentroid() {
        Vector3f centroid = new Vector3f();
        for (Vertex vertex : this.vertices) {
            centroid.add((Vector3fc)vertex.position());
        }
        centroid.div((float)this.vertices.size());
        return centroid;
    }
}

