/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.fireeffect;

import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import team.lodestar.lodestone.component.LodestoneComponents;
import team.lodestar.lodestone.registry.common.LodestoneFireEffectRegistry;
import team.lodestar.lodestone.systems.fireeffect.FireEffectType;

public class FireEffectInstance {
    public int duration;
    public final FireEffectType type;

    public FireEffectInstance(FireEffectType type) {
        this.type = type;
    }

    public FireEffectInstance extendDuration(int increase) {
        this.duration += increase;
        return this;
    }

    public FireEffectInstance setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public void tick(class_1297 target) {
        if (target.field_27857 || target.method_5637()) {
            this.type.extinguish(this, target);
        }
        if (this.canDamageTarget(target)) {
            --this.duration;
            if (this.type.isValid(this) && this.duration % this.type.getTickInterval(this) == 0) {
                this.type.tick(this, target);
            }
        } else {
            this.duration -= 4;
        }
    }

    public void entityAttack() {
    }

    public boolean canDamageTarget(class_1297 target) {
        return !target.method_5753();
    }

    public boolean isValid() {
        return this.type.isValid(this);
    }

    public void serializeNBT(class_2487 tag) {
        class_2487 fireTag = new class_2487();
        fireTag.method_10582("type", this.type.id);
        fireTag.method_10569("duration", this.duration);
        tag.method_10566("fireEffect", (class_2520)fireTag);
    }

    public static FireEffectInstance deserializeNBT(class_2487 tag) {
        if (!tag.method_10545("fireEffect")) {
            return null;
        }
        class_2487 fireTag = tag.method_10562("fireEffect");
        FireEffectInstance instance = new FireEffectInstance(LodestoneFireEffectRegistry.FIRE_TYPES.get(fireTag.method_10558("type")));
        instance.setDuration(fireTag.method_10550("duration"));
        return instance;
    }

    public void sync(class_1297 entity) {
        LodestoneComponents.LODESTONE_ENTITY_COMPONENT.sync((Object)entity);
    }
}

