/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.statesmith;

import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_7923;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockStateProvider;
import team.lodestar.lodestone.systems.datagen.statesmith.AbstractBlockStateSmith;

public class ModularBlockStateSmith<T extends class_2248>
extends AbstractBlockStateSmith<T> {
    public final ModularSmithStateSupplier<T> stateSupplier;

    public ModularBlockStateSmith(Class<T> blockClass, ModularSmithStateSupplier<T> stateSupplier) {
        super(blockClass);
        this.stateSupplier = stateSupplier;
    }

    @SafeVarargs
    public final void act(AbstractBlockStateSmith.StateSmithData data, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Supplier<? extends class_2248> ... blocks) {
        this.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, actor, modelFileSupplier, blocks);
    }

    @SafeVarargs
    public final void act(AbstractBlockStateSmith.StateSmithData data, ItemModelSmith itemModelSmith, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Supplier<? extends class_2248> ... blocks) {
        for (Supplier<? extends class_2248> block : blocks) {
            this.act(data, itemModelSmith, actor, modelFileSupplier, block);
        }
        List.of(blocks).forEach(data.consumer);
    }

    public void act(AbstractBlockStateSmith.StateSmithData data, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Collection<Supplier<? extends class_2248>> blocks) {
        this.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, actor, modelFileSupplier, blocks);
    }

    public void act(AbstractBlockStateSmith.StateSmithData data, ItemModelSmith itemModelSmith, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Collection<Supplier<? extends class_2248>> blocks) {
        blocks.forEach(r -> this.act(data, itemModelSmith, actor, modelFileSupplier, (Supplier<? extends class_2248>)r));
        new ArrayList<Supplier<? extends class_2248>>(blocks).forEach(data.consumer);
    }

    private void act(AbstractBlockStateSmith.StateSmithData data, ItemModelSmith itemModelSmith, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Supplier<? extends class_2248> registryObject) {
        class_2248 block = registryObject.get();
        if (this.blockClass.isInstance(block)) {
            this.stateSupplier.act((class_2248)this.blockClass.cast(block), data.provider, actor, modelFileSupplier);
            itemModelSmith.act(() -> ((class_2248)block).method_8389(), data.provider.itemModelProvider);
        } else {
            LodestoneLib.LOGGER.warn("Block does not match the state smith it was assigned: " + class_7923.field_41175.method_10221((Object)block));
        }
    }

    public static interface ModularSmithStateSupplier<T extends class_2248> {
        public void act(T var1, LodestoneBlockStateProvider var2, AbstractBlockStateSmith.StateFunction<T> var3, ModelFileSupplier var4);
    }

    public static interface ModelFileSupplier {
        public ModelFile generateModel(class_2248 var1);
    }
}

