/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.statesmith;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_7923;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockStateProvider;
import team.lodestar.lodestone.systems.datagen.statesmith.AbstractBlockStateSmith;

public class BlockStateSmith<T extends class_2248>
extends AbstractBlockStateSmith<T> {
    public final SmithStateSupplier<T> stateSupplier;
    public final ItemModelSmith itemModelSmith;

    public BlockStateSmith(Class<T> blockClass, SmithStateSupplier<T> stateSupplier) {
        this(blockClass, ItemModelSmithTypes.BLOCK_MODEL_ITEM, stateSupplier);
    }

    public BlockStateSmith(Class<T> blockClass, ItemModelSmith itemModelSmith, SmithStateSupplier<T> stateSupplier) {
        super(blockClass);
        this.stateSupplier = stateSupplier;
        this.itemModelSmith = itemModelSmith;
    }

    @SafeVarargs
    public final void act(AbstractBlockStateSmith.StateSmithData data, Supplier<? extends class_2248> ... blocks) {
        for (Supplier<? extends class_2248> block : blocks) {
            this.act(data, block);
        }
        List.of(blocks).forEach(data.consumer);
    }

    public void act(AbstractBlockStateSmith.StateSmithData data, Collection<Supplier<? extends class_2248>> blocks) {
        blocks.forEach(r -> this.act(data, (Supplier<? extends class_2248>)r));
        new ArrayList<Supplier<? extends class_2248>>(blocks).forEach(data.consumer);
    }

    private void act(AbstractBlockStateSmith.StateSmithData data, Supplier<? extends class_2248> registryObject) {
        class_2248 block = registryObject.get();
        if (this.blockClass.isInstance(block)) {
            this.stateSupplier.act((class_2248)this.blockClass.cast(block), data.provider);
            this.itemModelSmith.act(() -> ((class_2248)block).method_8389(), data.provider.itemModelProvider);
        } else {
            LodestoneLib.LOGGER.warn("Block does not match the state smith it was assigned: " + class_7923.field_41175.method_10221((Object)block));
        }
    }

    public static interface SmithStateSupplier<T extends class_2248> {
        public void act(T var1, LodestoneBlockStateProvider var2);
    }
}

