/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.providers;

import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockStateProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockModelProvider;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;
import team.lodestar.lodestone.systems.datagen.statesmith.ModularBlockStateSmith;

public abstract class LodestoneBlockStateProvider
extends BlockStateProvider {
    public final Set<class_2960> staticTextures = new HashSet<class_2960>();
    private final LodestoneBlockModelProvider blockModels;
    public final LodestoneItemModelProvider itemModelProvider;
    private static String texturePath = "";

    public LodestoneBlockStateProvider(class_7784 output, String modid, ExistingFileHelper exFileHelper, LodestoneItemModelProvider itemModelProvider) {
        super(output, modid, exFileHelper);
        this.itemModelProvider = itemModelProvider;
        this.blockModels = new LodestoneBlockModelProvider(this, output, modid, exFileHelper);
    }

    public LodestoneBlockModelProvider models() {
        return this.blockModels;
    }

    public LodestoneItemModelProvider itemModels() {
        return this.itemModelProvider;
    }

    public void setTexturePath(String texturePath) {
        LodestoneBlockStateProvider.texturePath = texturePath;
    }

    public static String getTexturePath() {
        return texturePath;
    }

    public ModularBlockStateSmith.ModelFileSupplier fromFunction(BiFunction<String, class_2960, ModelFile> modelFileFunction) {
        return b -> {
            String name = this.getBlockName(b);
            return (ModelFile)modelFileFunction.apply(name, this.getBlockTexture(name));
        };
    }

    public ModelFile predefinedModel(class_2248 block) {
        return this.models().getExistingFile(class_7923.field_41175.method_10221((Object)block));
    }

    public ModelFile predefinedModel(class_2248 block, String extension) {
        return this.models().getExistingFile(this.extend(class_7923.field_41175.method_10221((Object)block), extension));
    }

    public ModelFile grassBlockModel(class_2248 block) {
        String name = this.getBlockName(block);
        class_2960 side = this.getBlockTexture(name);
        class_2960 dirt = new class_2960("block/dirt");
        class_2960 top = this.getBlockTexture(name + "_top");
        return this.models().cubeBottomTop(name, side, dirt, top);
    }

    public ModelFile leavesBlockModel(class_2248 block) {
        String name = this.getBlockName(block);
        return ((BlockModelBuilder)this.models().withExistingParent(name, new class_2960("block/leaves"))).texture("all", this.getBlockTexture(name));
    }

    public ModelFile airModel(class_2248 block) {
        String name = this.getBlockName(block);
        return this.models().withExistingParent(name, new class_2960("block/air"));
    }

    public ModelFile cubeModelAirTexture(class_2248 block) {
        String name = this.getBlockName(block);
        return this.models().cubeAll(name, new class_2960("block/air"));
    }

    public String getBlockName(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block).method_12832();
    }

    public class_2960 getBlockTexture(String path) {
        return this.modLoc("block/" + path);
    }

    public class_2960 getStaticBlockTexture(String path) {
        return this.markTextureAsStatic(this.getBlockTexture(path));
    }

    public class_2960 markTextureAsStatic(class_2960 texture) {
        this.staticTextures.add(texture);
        return texture;
    }

    public class_2960 extend(class_2960 resourceLocation, String suffix) {
        return new class_2960(resourceLocation.method_12836(), resourceLocation.method_12832() + suffix);
    }
}

