/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.blockentity;

import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.forge_stuff.IItemHandler;
import team.lodestar.lodestone.forge_stuff.ItemHandlerHelper;
import team.lodestar.lodestone.forge_stuff.ItemStackHandler;
import team.lodestar.lodestone.helpers.BlockHelper;

public class LodestoneBlockEntityInventory
extends ItemStackHandler {
    public final int slotCount;
    public final int allowedItemSize;
    public Predicate<class_1799> inputPredicate;
    public Predicate<class_1799> outputPredicate;
    public final LazyOptional<IItemHandler> inventoryOptional = LazyOptional.of(() -> this);
    public ArrayList<class_1799> nonEmptyItemStacks = new ArrayList();
    public int emptyItemAmount;
    public int nonEmptyItemAmount;
    public int firstEmptyItemIndex;

    public LodestoneBlockEntityInventory(int slotCount, int allowedItemSize, Predicate<class_1799> inputPredicate, Predicate<class_1799> outputPredicate) {
        this(slotCount, allowedItemSize, inputPredicate);
        this.outputPredicate = outputPredicate;
    }

    public LodestoneBlockEntityInventory(int slotCount, int allowedItemSize, Predicate<class_1799> inputPredicate) {
        this(slotCount, allowedItemSize);
        this.inputPredicate = inputPredicate;
    }

    public LodestoneBlockEntityInventory(int slotCount, int allowedItemSize) {
        super(slotCount);
        this.slotCount = slotCount;
        this.allowedItemSize = allowedItemSize;
        this.updateData();
    }

    @Override
    public void onContentsChanged(int slot) {
        this.updateData();
    }

    @Override
    public int getSlots() {
        return this.slotCount;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.allowedItemSize;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        if (this.inputPredicate != null && !this.inputPredicate.test(stack)) {
            return false;
        }
        return super.isItemValid(slot, stack);
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (this.outputPredicate != null && !this.outputPredicate.test(super.extractItem(slot, amount, true))) {
            return class_1799.field_8037;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public void updateData() {
        class_2371<class_1799> stacks = this.getStacks();
        this.nonEmptyItemStacks = stacks.stream().filter(s -> !s.method_7960()).collect(Collectors.toCollection(ArrayList::new));
        this.nonEmptyItemAmount = this.nonEmptyItemStacks.size();
        this.emptyItemAmount = (int)stacks.stream().filter(class_1799::method_7960).count();
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 stack = (class_1799)stacks.get(i);
            if (!stack.method_7960()) continue;
            this.firstEmptyItemIndex = i;
            return;
        }
        this.firstEmptyItemIndex = -1;
    }

    public void load(class_2487 compound) {
        this.load(compound, "inventory");
    }

    public void load(class_2487 compound, String name) {
        this.deserializeNBT(compound.method_10562(name));
        if (this.stacks.size() != this.slotCount) {
            int missing = this.slotCount - this.stacks.size();
            for (int i = 0; i < missing; ++i) {
                this.stacks.add((Object)class_1799.field_8037);
            }
        }
        this.updateData();
    }

    public void save(class_2487 compound) {
        this.save(compound, "inventory");
    }

    public void save(class_2487 compound, String name) {
        compound.method_10566(name, (class_2520)this.serializeNBT());
    }

    public class_2371<class_1799> getStacks() {
        return this.stacks;
    }

    public boolean isEmpty() {
        return this.nonEmptyItemAmount == 0;
    }

    public void clear() {
        for (int i = 0; i < this.slotCount; ++i) {
            this.setStackInSlot(i, class_1799.field_8037);
        }
    }

    public void dumpItems(class_1937 level, class_2338 pos) {
        this.dumpItems(level, BlockHelper.fromBlockPos(pos).method_1031(0.5, 0.5, 0.5));
    }

    public void dumpItems(class_1937 level, class_243 pos) {
        for (int i = 0; i < this.slotCount; ++i) {
            if (!this.getStackInSlot(i).method_7960()) {
                level.method_8649((class_1297)new class_1542(level, pos.method_10216(), pos.method_10214(), pos.method_10215(), this.getStackInSlot(i)));
            }
            this.setStackInSlot(i, class_1799.field_8037);
        }
    }

    public class_1799 interact(class_1937 level, class_1657 player, class_1268 handIn) {
        if (!level.field_9236) {
            class_1799 held = player.method_5998(handIn);
            player.method_23667(handIn, true);
            int size = this.nonEmptyItemStacks.size() - 1;
            if ((held.method_7960() || this.firstEmptyItemIndex == -1) && size != -1) {
                boolean success;
                class_1799 takeOutStack = this.nonEmptyItemStacks.get(size);
                if (takeOutStack.method_7909().equals(held.method_7909())) {
                    return this.insertItem(player, held);
                }
                class_1799 extractedStack = this.extractItem(level, held, player);
                boolean bl = success = !extractedStack.method_7960();
                if (success) {
                    this.insertItem(player, held);
                }
                return extractedStack;
            }
            return this.insertItem(player, held);
        }
        return class_1799.field_8037;
    }

    public class_1799 extractItem(class_1937 level, class_1799 heldStack, class_1657 player) {
        if (!level.field_9236) {
            ArrayList<class_1799> nonEmptyStacks = this.nonEmptyItemStacks;
            if (nonEmptyStacks.isEmpty()) {
                return heldStack;
            }
            class_1799 takeOutStack = (class_1799)nonEmptyStacks.get(nonEmptyStacks.size() - 1);
            int slot = this.stacks.indexOf((Object)takeOutStack);
            if (this.extractItem(slot, takeOutStack.method_7947(), true).equals(class_1799.field_8037)) {
                return heldStack;
            }
            this.extractItem(player, takeOutStack, slot);
            return takeOutStack;
        }
        return class_1799.field_8037;
    }

    public void extractItem(class_1657 playerEntity, class_1799 stack, int slot) {
        try (Transaction tx = TransferUtil.getTransaction();){
            PlayerInventoryStorage.of((class_1657)playerEntity).offerOrDrop(ItemVariant.of((class_1935)stack.method_7909(), (class_2487)stack.method_7969()), (long)stack.method_7947(), (TransactionContext)tx);
            tx.commit();
        }
        this.setStackInSlot(slot, class_1799.field_8037);
    }

    public class_1799 insertItem(class_1657 playerEntity, class_1799 stack) {
        return this.insertItem(stack);
    }

    public class_1799 insertItem(class_1799 stack) {
        if (!stack.method_7960()) {
            class_1799 simulate = this.insertItem(stack, true);
            if (simulate.equals(stack)) {
                return class_1799.field_8037;
            }
            int count = stack.method_7947() - simulate.method_7947();
            if (count > this.allowedItemSize) {
                count = this.allowedItemSize;
            }
            class_1799 input = stack.method_7971(count);
            this.insertItem(input, false);
            return input;
        }
        return class_1799.field_8037;
    }

    public class_1799 insertItem(class_1799 stack, boolean simulate) {
        return ItemHandlerHelper.insertItem(this, stack, simulate);
    }
}

