/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TrinketsHelper {
    public static Optional<class_3545<SlotReference, class_1799>> getEquippedTrinket(class_1309 entity, Predicate<class_1799> predicate) {
        return TrinketsApi.TRINKET_COMPONENT.maybeGet((Object)entity).flatMap(trinketComponent -> trinketComponent.getEquipped(predicate).stream().findFirst());
    }

    public static Optional<class_3545<SlotReference, class_1799>> getEquippedTrinket(class_1309 entity, class_1792 curio) {
        Optional comp = TrinketsApi.TRINKET_COMPONENT.maybeGet((Object)entity);
        return comp.flatMap(trinketComponent -> trinketComponent.getEquipped(curio).stream().findFirst());
    }

    public static boolean hasTrinketEquipped(class_1309 entity, class_1792 curio) {
        return TrinketsHelper.getEquippedTrinket(entity, curio).isPresent();
    }

    public static List<class_3545<SlotReference, class_1799>> getEquippedTrinkets(class_1309 entity) {
        Optional v = TrinketsApi.TRINKET_COMPONENT.maybeGet((Object)entity);
        if (v.isPresent()) {
            TrinketComponent component = (TrinketComponent)v.get();
            return component.getAllEquipped();
        }
        return List.of();
    }

    public static ArrayList<class_3545<SlotReference, class_1799>> getEquippedTrinkets(class_1309 entity, Predicate<class_1799> predicate) {
        Optional v = TrinketsApi.TRINKET_COMPONENT.maybeGet((Object)entity);
        if (v.isPresent()) {
            TrinketComponent component = (TrinketComponent)v.get();
            return new ArrayList<class_3545<SlotReference, class_1799>>(component.getEquipped(predicate));
        }
        return new ArrayList<class_3545<SlotReference, class_1799>>();
    }

    public static Optional<ImmutablePair<SlotReference, class_1799>> findCosmeticCurio(Predicate<class_1799> filter, class_1309 livingEntity) {
        Optional optionalTrinketComponent = TrinketsApi.TRINKET_COMPONENT.maybeGet((Object)livingEntity);
        if (optionalTrinketComponent.isPresent()) {
            TrinketComponent comp = (TrinketComponent)optionalTrinketComponent.get();
            List equipped = comp.getAllEquipped();
            for (class_3545 i : equipped) {
                class_1799 stack = (class_1799)i.method_15441();
                if (stack.method_7960() || !filter.test(stack)) continue;
                return Optional.of(new ImmutablePair((Object)((SlotReference)i.method_15442()), (Object)stack));
            }
        }
        return Optional.empty();
    }
}

