/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.Iris;
import org.joml.Matrix4fc;
import team.lodestar.lodestone.events.Stage;
import team.lodestar.lodestone.handlers.RenderHandler;

public class ShadersHelper {
    public static boolean LOADED;

    public static void init() {
        LOADED = FabricLoader.getInstance().isModLoaded("iris");
    }

    public static boolean isLoaded() {
        return LOADED;
    }

    public static boolean isShadersEnabled() {
        if (ShadersHelper.isLoaded()) {
            return LoadedOnly.isShadersEnabled();
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static void renderStages(Stage stage) {
        if (stage == Stage.AFTER_LEVEL) {
            RenderSystem.getModelViewStack().method_22903();
            RenderSystem.getModelViewStack().method_34426();
            if (RenderHandler.MATRIX4F != null) {
                RenderSystem.getModelViewMatrix().set((Matrix4fc)RenderHandler.MATRIX4F);
            }
            ShadersHelper.endBatchesParticles();
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
            ShadersHelper.endBatches();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void endBatchesParticles() {
        RenderHandler.copyDepthBuffer(RenderHandler.LODESTONE_DEPTH_CACHE);
        ShadersHelper.endBatchesParticles(RenderHandler.DELAYED_RENDER);
        ShadersHelper.endBatchesParticles(RenderHandler.LATE_DELAYED_RENDER);
    }

    @Environment(value=EnvType.CLIENT)
    public static void endBatches() {
        RenderHandler.copyDepthBuffer(RenderHandler.LODESTONE_DEPTH_CACHE);
        ShadersHelper.endBatches(RenderHandler.DELAYED_RENDER);
        ShadersHelper.endBatches(RenderHandler.LATE_DELAYED_RENDER);
    }

    @Environment(value=EnvType.CLIENT)
    public static void endBatchesParticles(RenderHandler.LodestoneRenderLayer renderLayer) {
        RenderHandler.beginBufferedRendering();
        RenderHandler.renderBufferedParticles(renderLayer, true);
        RenderHandler.renderBufferedParticles(renderLayer, false);
        RenderHandler.endBufferedRendering();
    }

    @Environment(value=EnvType.CLIENT)
    public static void endBatches(RenderHandler.LodestoneRenderLayer renderLayer) {
        RenderHandler.beginBufferedRendering();
        RenderHandler.renderBufferedBatches(renderLayer, true);
        RenderHandler.renderBufferedBatches(renderLayer, false);
        RenderHandler.endBufferedRendering();
    }

    public static class LoadedOnly {
        public static boolean isShadersEnabled() {
            return Iris.getIrisConfig().areShadersEnabled();
        }
    }
}

