/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;

public class RenderHelper {
    public static final int FULL_BRIGHT = 0xF000F0;

    public static class_5944 getShader(class_1921 type) {
        if (type instanceof LodestoneRenderType) {
            LodestoneRenderType renderType = (LodestoneRenderType)type;
            Optional shader = renderType.state.field_29461.field_29455;
            if (shader.isPresent()) {
                return (class_5944)((Supplier)shader.get()).get();
            }
        }
        return null;
    }

    public static class_4668.class_4685 getTransparencyShard(class_1921 type) {
        if (type instanceof LodestoneRenderType) {
            LodestoneRenderType compositeRenderType = (LodestoneRenderType)type;
            return compositeRenderType.state.field_21407;
        }
        return null;
    }

    public static void vertexPos(class_4588 vertexConsumer, Matrix4f last, float x, float y, float z) {
        vertexConsumer.method_22918(last, x, y, z).method_1344();
    }

    public static void vertexPosUV(class_4588 vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v) {
        vertexConsumer.method_22918(last, x, y, z).method_22913(u, v).method_1344();
    }

    public static void vertexPosUVLight(class_4588 vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v, int light) {
        vertexConsumer.method_22918(last, x, y, z).method_22913(u, v).method_22916(light).method_1344();
    }

    public static void vertexPosColor(class_4588 vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a) {
        vertexConsumer.method_22918(last, x, y, z).method_22915(r, g, b, a).method_1344();
    }

    public static void vertexPosColorUV(class_4588 vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v) {
        vertexConsumer.method_22918(last, x, y, z).method_22915(r, g, b, a).method_22913(u, v).method_1344();
    }

    public static void vertexPosColorUVLight(class_4588 vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light) {
        vertexConsumer.method_22918(last, x, y, z).method_22915(r, g, b, a).method_22913(u, v).method_22916(light).method_1344();
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(class_3532.method_15362((float)u) * class_3532.method_15374((float)v) * r, class_3532.method_15362((float)v) * r, class_3532.method_15374((float)u) * class_3532.method_15374((float)v) * r);
    }

    public static class_241 perpendicularTrailPoints(Vector4f start, Vector4f end, float width) {
        float x = -start.x();
        float y = -start.y();
        if (Math.abs(start.z()) > 0.0f) {
            float ratio = end.z() / start.z();
            x = end.x() + x * ratio;
            y = end.y() + y * ratio;
        } else if (Math.abs(end.z()) <= 0.0f) {
            x += end.x();
            y += end.y();
        }
        if (start.z() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / DataHelper.distance(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new class_241(-y, x);
    }

    public static Vector4f midpoint(Vector4f a, Vector4f b) {
        return new Vector4f((a.x() + b.x()) * 0.5f, (a.y() + b.y()) * 0.5f, (a.z() + b.z()) * 0.5f, (a.w() + b.w()) * 0.5f);
    }

    public static class_241 worldPosToTexCoord(Vector3f worldPos, class_4587 viewModelStack) {
        Matrix4f viewMat = viewModelStack.method_23760().method_23761();
        Matrix4f projMat = RenderSystem.getProjectionMatrix();
        Vector3f localPos = new Vector3f((Vector3fc)worldPos);
        localPos.sub((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
        Vector4f pos = new Vector4f((Vector3fc)localPos, 0.0f);
        pos.mul((Matrix4fc)viewMat);
        pos.mul((Matrix4fc)projMat);
        VecHelper.Vector4fHelper.perspectiveDivide(pos);
        return new class_241((pos.x() + 1.0f) / 2.0f, (pos.y() + 1.0f) / 2.0f);
    }

    public static void drawSteppedLineBetween(class_4597 buffer, class_4587 ps, List<class_243> points, float lineWidth, int r, int g, int b, int a) {
        class_243 origin = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            class_243 target = points.get(i);
            RenderHelper.drawLineBetween(buffer, ps, origin, target, lineWidth, r, g, b, a);
            origin = target;
        }
    }

    public static void drawSteppedLineBetween(class_4597 buffer, class_4587 ps, class_243 start, class_243 end, int steps, float lineWidth, int r, int g, int b, int a, Consumer<class_243> pointConsumer) {
        class_243 origin = start;
        for (int i = 1; i <= steps; ++i) {
            class_243 target = start.method_1019(end.method_1020(start).method_1021((double)((float)i / (float)steps)));
            pointConsumer.accept(target);
            RenderHelper.drawLineBetween(buffer, ps, origin, target, lineWidth, r, g, b, a);
            origin = target;
        }
    }

    public static void drawLineBetween(class_4597 buffer, class_4587 ps, class_243 local, class_243 target, float lineWidth, int r, int g, int b, int a) {
        class_4588 builder = buffer.getBuffer(class_1921.method_23587());
        float rotY = (float)class_3532.method_15349((double)(target.field_1352 - local.field_1352), (double)(target.field_1350 - local.field_1350));
        double distX = target.field_1352 - local.field_1352;
        double distZ = target.field_1350 - local.field_1350;
        float rotX = (float)class_3532.method_15349((double)(target.field_1351 - local.field_1351), (double)class_3532.method_15355((float)((float)(distX * distX + distZ * distZ))));
        ps.method_22903();
        ps.method_22904(local.field_1352, local.field_1351, local.field_1350);
        ps.method_22907(VecHelper.Vector3fHelper.rotation(rotY, VecHelper.Vector3fHelper.YP));
        ps.method_22907(VecHelper.Vector3fHelper.rotation(rotX, VecHelper.Vector3fHelper.XN));
        float distance = (float)local.method_1022(target);
        Matrix4f matrix = ps.method_23760().method_23761();
        float halfWidth = lineWidth / 2.0f;
        builder.method_22918(matrix, -halfWidth, 0.0f, 0.0f).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        builder.method_22918(matrix, halfWidth, 0.0f, 0.0f).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        builder.method_22918(matrix, halfWidth, 0.0f, distance).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        builder.method_22918(matrix, -halfWidth, 0.0f, distance).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        builder.method_22918(matrix, 0.0f, -halfWidth, 0.0f).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        builder.method_22918(matrix, 0.0f, halfWidth, 0.0f).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        builder.method_22918(matrix, 0.0f, halfWidth, distance).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        builder.method_22918(matrix, 0.0f, -halfWidth, distance).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        ps.method_22909();
    }
}

