/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.EasingHelper;
import team.lodestar.lodestone.systems.easing.Easing;

public class RandomHelper {
    public static float weightedEasingLerp(Easing easing, float pDelta, float pStart, float pEnd) {
        float distanceFromMiddle = class_3532.method_15379((float)(0.5f - pDelta)) / 0.5f;
        float middleBasedDelta = easing.ease(1.0f - distanceFromMiddle, 0.0f, 1.0f, 1.0f);
        float pMiddle = (pStart + pEnd) / 2.0f;
        if (pDelta < 0.5f) {
            return class_3532.method_16439((float)middleBasedDelta, (float)pStart, (float)pMiddle);
        }
        return class_3532.method_16439((float)(1.0f - middleBasedDelta), (float)pMiddle, (float)pEnd);
    }

    public static float interpolateWithEasing(Easing easing, double pDelta, double pStart, double pEnd) {
        return RandomHelper.weightedEasingLerp(easing, (float)pDelta, (float)pStart, (float)pEnd);
    }

    public static int randomBetween(class_5819 pRandom, int min, int max) {
        return RandomHelper.randomBetween(pRandom, Easing.SINE_IN_OUT, min, max);
    }

    public static int randomBetween(class_5819 pRandom, Easing easing, int min, int max) {
        return Math.round(EasingHelper.weightedEasingLerp(easing, pRandom.method_43057(), min, max));
    }

    public static float randomBetween(class_5819 pRandom, float min, float max) {
        return RandomHelper.randomBetween(pRandom, Easing.SINE_IN_OUT, min, max);
    }

    public static float randomBetween(class_5819 pRandom, Easing easing, float min, float max) {
        return EasingHelper.weightedEasingLerp(easing, pRandom.method_43057(), min, max);
    }

    public static double randomBetween(class_5819 pRandom, double min, double max) {
        return RandomHelper.randomBetween(pRandom, Easing.SINE_IN_OUT, min, max);
    }

    public static double randomBetween(class_5819 pRandom, Easing easing, double min, double max) {
        return EasingHelper.weightedEasingLerp(easing, (double)pRandom.method_43057(), min, max);
    }
}

