/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class DataHelper {
    public static <T, K extends Collection<T>> K reverseOrder(K reversed, Collection<T> items) {
        ArrayList<T> original = new ArrayList<T>(items);
        for (int i = items.size() - 1; i >= 0; --i) {
            reversed.add(original.get(i));
        }
        return reversed;
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    public static int[] nextInts(int count, int range) {
        Random rand = new Random();
        int[] ints = new int[count];
        for (int i = 0; i < count; ++i) {
            int nextInt;
            do {
                nextInt = rand.nextInt(range);
            } while (!Arrays.stream(ints).noneMatch(j -> j == nextInt));
            ints[i] = nextInt;
        }
        return ints;
    }

    public static <T> boolean hasDuplicate(T[] things) {
        HashSet thingSet = new HashSet();
        return !Arrays.stream(things).allMatch(thingSet::add);
    }

    public static <T> T take(Collection<? extends T> src, T item) {
        src.remove(item);
        return item;
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Collection<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            return Collections.emptyList();
        }
        if (!src.removeAll(ret)) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Collection<T> getAll(Collection<? extends T> src, T ... items) {
        return List.copyOf(DataHelper.getAll(src, t -> Arrays.stream(items).anyMatch(tAgain -> tAgain.getClass().isInstance(t))));
    }

    public static <T> Collection<T> getAll(Collection<T> src, Predicate<T> pred) {
        return src.stream().filter(pred).collect(Collectors.toList());
    }

    public static class_243 radialOffset(class_243 pos, float distance, float current, float total) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distance * Math.cos(angle);
        double dz2 = (double)distance * Math.sin(angle);
        class_243 vector = new class_243(dx2, 0.0, dz2);
        double x = vector.field_1352 * (double)distance;
        double z = vector.field_1350 * (double)distance;
        return pos.method_1019(new class_243(x, 0.0, z));
    }

    public static ArrayList<class_243> rotatingRadialOffsets(class_243 pos, float distance, float total, long gameTime, float time) {
        return DataHelper.rotatingRadialOffsets(pos, distance, distance, total, gameTime, time);
    }

    public static ArrayList<class_243> rotatingRadialOffsets(class_243 pos, float distanceX, float distanceZ, float total, long gameTime, float time) {
        ArrayList<class_243> positions = new ArrayList<class_243>();
        int i = 0;
        while ((float)i <= total) {
            positions.add(DataHelper.rotatingRadialOffset(pos, distanceX, distanceZ, i, total, gameTime, time));
            ++i;
        }
        return positions;
    }

    public static class_243 rotatingRadialOffset(class_243 pos, float distance, float current, float total, long gameTime, float time) {
        return DataHelper.rotatingRadialOffset(pos, distance, distance, current, total, gameTime, time);
    }

    public static class_243 rotatingRadialOffset(class_243 pos, float distanceX, float distanceZ, float current, float total, long gameTime, float time) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distanceX * Math.cos(angle += (double)((float)gameTime % time / time) * (Math.PI * 2));
        double dz2 = (double)distanceZ * Math.sin(angle);
        class_243 vector2f = new class_243(dx2, 0.0, dz2);
        double x = vector2f.field_1352 * (double)distanceX;
        double z = vector2f.field_1350 * (double)distanceZ;
        return pos.method_1031(x, 0.0, z);
    }

    public static ArrayList<class_243> blockOutlinePositions(class_1937 level, class_2338 pos) {
        ArrayList<class_243> arrayList = new ArrayList<class_243>();
        double d0 = 0.5625;
        class_5819 random = level.field_9229;
        for (class_2350 direction : class_2350.values()) {
            class_2338 blockpos = pos.method_10093(direction);
            if (level.method_8320(blockpos).method_26216((class_1922)level, blockpos)) continue;
            class_2350.class_2351 direction$axis = direction.method_10166();
            double d1 = direction$axis == class_2350.class_2351.field_11048 ? 0.5 + d0 * (double)direction.method_10148() : (double)random.method_43057();
            double d2 = direction$axis == class_2350.class_2351.field_11052 ? 0.5 + d0 * (double)direction.method_10164() : (double)random.method_43057();
            double d3 = direction$axis == class_2350.class_2351.field_11051 ? 0.5 + d0 * (double)direction.method_10165() : (double)random.method_43057();
            arrayList.add(new class_243((double)pos.method_10263() + d1, (double)pos.method_10264() + d2, (double)pos.method_10260() + d3));
        }
        return arrayList;
    }

    public static float distSqr(float ... a) {
        float d = 0.0f;
        for (float f : a) {
            d += f * f;
        }
        return d;
    }

    public static float distance(float ... a) {
        return class_3532.method_15355((float)DataHelper.distSqr(a));
    }
}

