/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_11;
import net.minecraft.class_1299;
import net.minecraft.class_1453;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_9;

public class BlockHelper {
    public static class_2680 getBlockStateWithExistingProperties(class_2680 oldState, class_2680 newState) {
        class_2680 finalState = newState;
        for (class_2769 property : oldState.method_28501()) {
            if (!newState.method_28498(property)) continue;
            finalState = BlockHelper.newStateWithOldProperty(oldState, finalState, property);
        }
        return finalState;
    }

    public static class_2680 setBlockStateWithExistingProperties(class_1937 level, class_2338 pos, class_2680 newState, int flags) {
        class_2680 oldState = level.method_8320(pos);
        class_2680 finalState = BlockHelper.getBlockStateWithExistingProperties(oldState, newState);
        level.method_8413(pos, oldState, finalState, flags);
        level.method_8652(pos, finalState, flags);
        return finalState;
    }

    public static <T extends Comparable<T>> class_2680 newStateWithOldProperty(class_2680 oldState, class_2680 newState, class_2769<T> property) {
        return (class_2680)newState.method_11657(property, oldState.method_11654(property));
    }

    public static class_2487 saveBlockPos(class_2487 compoundNBT, class_2338 pos) {
        compoundNBT.method_10569("X", pos.method_10263());
        compoundNBT.method_10569("Y", pos.method_10264());
        compoundNBT.method_10569("Z", pos.method_10260());
        return compoundNBT;
    }

    public static class_2487 saveBlockPos(class_2487 compoundNBT, class_2338 pos, String extra) {
        compoundNBT.method_10569(extra + "_X", pos.method_10263());
        compoundNBT.method_10569(extra + "_Y", pos.method_10264());
        compoundNBT.method_10569(extra + "_Z", pos.method_10260());
        return compoundNBT;
    }

    public static class_2338 loadBlockPos(class_2487 tag) {
        return tag.method_10545("X") ? new class_2338(tag.method_10550("X"), tag.method_10550("Y"), tag.method_10550("Z")) : null;
    }

    public static class_2338 loadBlockPos(class_2487 tag, String extra) {
        return tag.method_10545(extra + "_X") ? new class_2338(tag.method_10550(extra + "_X"), tag.method_10550(extra + "_Y"), tag.method_10550(extra + "_Z")) : null;
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, class_1937 level, class_2338 pos, int range, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, range, predicate).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, class_1937 level, class_2338 pos, int range, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, range, range, range, predicate);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, class_1937 level, class_2338 pos, int x, int z, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, z, predicate).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, class_1937 level, class_2338 pos, int x, int z, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, z).filter(predicate);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, class_1937 level, class_2338 pos, int x, int y, int z, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, y, z, predicate).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, class_1937 level, class_2338 pos, int x, int y, int z, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, y, z).filter(predicate);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, class_1937 level, class_2338 pos, int range) {
        return BlockHelper.getBlockEntities(type, level, pos, range, range, range);
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, class_1937 level, class_2338 pos, int range) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, range, range, range);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, class_1937 level, class_2338 pos, int x, int z) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, z).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, class_1937 level, class_2338 pos, int x, int z) {
        return BlockHelper.getBlockEntitiesStream(type, level, new class_238((double)pos.method_10263() - (double)x, (double)pos.method_10264(), (double)pos.method_10260() - (double)z, (double)pos.method_10263() + (double)x, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + (double)z));
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, class_1937 level, class_2338 pos, int x, int y, int z) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, y, z).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, class_1937 level, class_2338 pos, int x, int y, int z) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, -x, -y, -z, x, y, z);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, class_1937 level, class_2338 pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x1, y1, z1, x2, y2, z2).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, class_1937 level, class_2338 pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockHelper.getBlockEntitiesStream(type, level, new class_238((double)pos.method_10263() + 1.5 + (double)x1, (double)pos.method_10264() + 1.5 + (double)y1, (double)pos.method_10260() + 1.5 + (double)z1, (double)pos.method_10263() + 0.5 + (double)x2, (double)pos.method_10264() + 0.5 + (double)y2, (double)pos.method_10260() + 0.5 + (double)z2));
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, class_1937 world, class_238 bb) {
        return BlockHelper.getBlockEntitiesStream(type, world, bb).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, class_1937 world, class_238 bb) {
        return IntStream.iterate((int)Math.floor(bb.field_1323), i -> (double)i < Math.ceil(bb.field_1320) + 16.0, i -> i + 16).boxed().flatMap(i -> IntStream.iterate((int)Math.floor(bb.field_1321), j -> (double)j < Math.ceil(bb.field_1324) + 16.0, j -> j + 16).boxed().flatMap(j -> {
            class_2791 c = world.method_22350(new class_2338(i.intValue(), 0, j.intValue()));
            return c.method_12021().stream();
        })).filter(p -> bb.method_1008((double)p.method_10263() + 0.5, (double)p.method_10264() + 0.5, (double)p.method_10260() + 0.5)).map(arg_0 -> ((class_1937)world).method_8321(arg_0)).filter(type::isInstance).map(type::cast);
    }

    public static Collection<class_2338> getBlocks(class_2338 pos, int range, Predicate<class_2338> predicate) {
        return BlockHelper.getBlocksStream(pos, range, predicate).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getBlocksStream(class_2338 pos, int range, Predicate<class_2338> predicate) {
        return BlockHelper.getBlocksStream(pos, range, range, range, predicate);
    }

    public static Collection<class_2338> getBlocks(class_2338 pos, int x, int y, int z, Predicate<class_2338> predicate) {
        return BlockHelper.getBlocksStream(pos, x, y, z, predicate).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getBlocksStream(class_2338 pos, int x, int y, int z, Predicate<class_2338> predicate) {
        return BlockHelper.getBlocksStream(pos, x, y, z).filter(predicate);
    }

    public static Collection<class_2338> getBlocks(class_2338 pos, int x, int y, int z) {
        return BlockHelper.getBlocksStream(pos, x, y, z).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getBlocksStream(class_2338 pos, int x, int y, int z) {
        return BlockHelper.getBlocksStream(pos, -x, -y, -z, x, y, z);
    }

    public static Collection<class_2338> getBlocks(class_2338 pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockHelper.getBlocksStream(pos, x1, y1, z1, x2, y2, z2).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getBlocksStream(class_2338 pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return IntStream.rangeClosed(x1, x2).boxed().flatMap(i -> IntStream.rangeClosed(y1, y2).boxed().flatMap(j -> IntStream.rangeClosed(z1, z2).boxed().map(k -> pos.method_10069(i.intValue(), j.intValue(), k.intValue()))));
    }

    public static Collection<class_2338> getPlaneOfBlocks(class_2338 pos, int range, Predicate<class_2338> predicate) {
        return BlockHelper.getPlaneOfBlocksStream(pos, range, predicate).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getPlaneOfBlocksStream(class_2338 pos, int range, Predicate<class_2338> predicate) {
        return BlockHelper.getPlaneOfBlocksStream(pos, range, range, predicate);
    }

    public static Collection<class_2338> getPlaneOfBlocks(class_2338 pos, int x, int z, Predicate<class_2338> predicate) {
        return BlockHelper.getPlaneOfBlocksStream(pos, x, z, predicate).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getPlaneOfBlocksStream(class_2338 pos, int x, int z, Predicate<class_2338> predicate) {
        return BlockHelper.getPlaneOfBlocksStream(pos, x, z).filter(predicate);
    }

    public static Collection<class_2338> getPlaneOfBlocks(class_2338 pos, int x, int z) {
        return BlockHelper.getPlaneOfBlocksStream(pos, x, z).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getPlaneOfBlocksStream(class_2338 pos, int x, int z) {
        return BlockHelper.getPlaneOfBlocksStream(pos, -x, -z, x, z);
    }

    public static Collection<class_2338> getPlaneOfBlocks(class_2338 pos, int x1, int z1, int x2, int z2) {
        return BlockHelper.getPlaneOfBlocksStream(pos, x1, z1, x2, z2).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getPlaneOfBlocksStream(class_2338 pos, int x1, int z1, int x2, int z2) {
        return IntStream.rangeClosed(x1, x2).boxed().flatMap(x -> IntStream.rangeClosed(z1, z2).boxed().map(z -> pos.method_10069(x.intValue(), 0, z.intValue())));
    }

    public static Collection<class_2338> getSphereOfBlocks(class_2338 pos, float range, Predicate<class_2338> predicate) {
        return BlockHelper.getSphereOfBlocksStream(pos, range, predicate).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getSphereOfBlocksStream(class_2338 pos, float range, Predicate<class_2338> predicate) {
        return BlockHelper.getSphereOfBlocksStream(pos, range, range).filter(predicate);
    }

    public static Collection<class_2338> getSphereOfBlocks(class_2338 pos, float width, float height, Predicate<class_2338> predicate) {
        return BlockHelper.getSphereOfBlocksStream(pos, width, height, predicate).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getSphereOfBlocksStream(class_2338 pos, float width, float height, Predicate<class_2338> predicate) {
        return BlockHelper.getSphereOfBlocksStream(pos, width, height).filter(predicate);
    }

    public static Collection<class_2338> getSphereOfBlocks(class_2338 pos, float range) {
        return BlockHelper.getSphereOfBlocksStream(pos, range).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getSphereOfBlocksStream(class_2338 pos, float range) {
        return BlockHelper.getSphereOfBlocksStream(pos, range, range);
    }

    public static Collection<class_2338> getSphereOfBlocks(class_2338 pos, float width, float height) {
        return BlockHelper.getSphereOfBlocksStream(pos, width, height).collect(Collectors.toSet());
    }

    public static Stream<class_2338> getSphereOfBlocksStream(class_2338 pos, float width, float height) {
        return IntStream.rangeClosed((int)(-width), (int)width).boxed().flatMap(x -> IntStream.rangeClosed((int)(-height), (int)height).boxed().flatMap(y -> IntStream.rangeClosed((int)(-width), (int)width).boxed().filter(z -> {
            double d = Math.sqrt(x * x + y * y + z * z);
            return d <= (double)width;
        }).map(z -> pos.method_10069(x.intValue(), y.intValue(), z.intValue()))));
    }

    public static Collection<class_2338> getNeighboringBlocks(class_2338 current) {
        return BlockHelper.getBlocks(current, -1, -1, -1, 1, 1, 1);
    }

    public static Stream<class_2338> getNeighboringBlocksStream(class_2338 current) {
        return BlockHelper.getBlocksStream(current, -1, -1, -1, 1, 1, 1);
    }

    public static Collection<class_2338> getPath(class_2338 start, class_2338 end, int speed, boolean inclusive, class_1937 level) {
        class_1453 parrot = new class_1453(class_1299.field_6104, level);
        parrot.method_5814((double)start.method_10263() + 0.5, (double)start.method_10264() - 0.5, (double)start.method_10260() + 0.5);
        parrot.method_5942().method_6337((double)end.method_10263() + 0.5, (double)end.method_10264() - 0.5, (double)end.method_10260() + 0.5, (double)speed);
        class_11 path = parrot.method_5942().method_6345();
        parrot.method_31472();
        int nodes = path != null ? path.method_38() : 0;
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        for (int i = 0; i < nodes; ++i) {
            class_9 node = path.method_40(i);
            positions.add(new class_2338(node.field_40, (int)((double)node.field_39 - 0.5), node.field_38));
        }
        if (!inclusive) {
            positions.remove(0);
            positions.remove(positions.size() - 1);
        }
        return positions;
    }

    public static void updateState(class_1937 level, class_2338 pos) {
        BlockHelper.updateState(level.method_8320(pos), level, pos);
    }

    public static void updateState(class_2680 state, class_1937 level, class_2338 pos) {
        level.method_8413(pos, state, state, 2);
        level.method_8524(pos);
    }

    public static void updateAndNotifyState(class_1937 level, class_2338 pos) {
        BlockHelper.updateAndNotifyState(level.method_8320(pos), level, pos);
    }

    public static void updateAndNotifyState(class_2680 state, class_1937 level, class_2338 pos) {
        BlockHelper.updateState(state, level, pos);
        state.method_30101((class_1936)level, pos, 2);
        level.method_8455(pos, state.method_26204());
    }

    public static class_243 fromBlockPos(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_243 withinBlock(Random rand, class_2338 pos) {
        double x = (double)pos.method_10263() + rand.nextDouble();
        double y = (double)pos.method_10264() + rand.nextDouble();
        double z = (double)pos.method_10260() + rand.nextDouble();
        return new class_243(x, y, z);
    }
}

