/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers.screenparticle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleItemStackKey;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleItemStackRetrievalKey;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

public class ScreenParticleHandler {
    public static final Map<ScreenParticleItemStackKey, ScreenParticleHolder> ITEM_PARTICLES = new HashMap<ScreenParticleItemStackKey, ScreenParticleHolder>();
    public static final Map<ScreenParticleItemStackRetrievalKey, class_1799> ITEM_STACK_CACHE = new HashMap<ScreenParticleItemStackRetrievalKey, class_1799>();
    public static final Collection<ScreenParticleItemStackRetrievalKey> ACTIVELY_ACCESSED_KEYS = new ArrayList<ScreenParticleItemStackRetrievalKey>();
    public static ScreenParticleHolder cachedItemParticles = null;
    public static int currentItemX;
    public static int currentItemY;
    public static final class_289 TESSELATOR;
    public static boolean canSpawnParticles;
    public static boolean renderingHotbar;

    public static void tickParticles() {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        ITEM_PARTICLES.values().forEach(ScreenParticleHolder::tick);
        ITEM_PARTICLES.values().removeIf(ScreenParticleHolder::isEmpty);
        ITEM_STACK_CACHE.keySet().removeIf(k -> !ACTIVELY_ACCESSED_KEYS.contains(k));
        ACTIVELY_ACCESSED_KEYS.clear();
        canSpawnParticles = true;
    }

    public static void renderTick() {
        canSpawnParticles = false;
    }

    public static void renderItemStackEarly(class_4587 poseStack, class_1799 stack, int x, int y) {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 != null && minecraft.field_1724 != null) {
            List<ParticleEmitterHandler.ItemParticleSupplier> emitters;
            if (minecraft.method_1493()) {
                return;
            }
            if (!stack.method_7960() && (emitters = ParticleEmitterHandler.EMITTERS.get(stack.method_7909())) != null) {
                currentItemX = x + 8;
                currentItemY = y + 8;
                Matrix4f pose = poseStack.method_23760().method_23761();
                float xOffset = pose.m30();
                float yOffset = pose.m31();
                currentItemX += (int)xOffset;
                currentItemY += (int)yOffset;
                for (ParticleEmitterHandler.ItemParticleSupplier emitter : emitters) {
                    ScreenParticleHandler.renderParticles(ScreenParticleHandler.spawnAndPullParticles(minecraft.field_1687, emitter, stack, false));
                    cachedItemParticles = ScreenParticleHandler.spawnAndPullParticles(minecraft.field_1687, emitter, stack, true);
                }
            }
        }
    }

    public static ScreenParticleHolder spawnAndPullParticles(class_638 level, ParticleEmitterHandler.ItemParticleSupplier emitter, class_1799 stack, boolean isRenderedAfterItem) {
        ScreenParticleItemStackRetrievalKey cacheKey = new ScreenParticleItemStackRetrievalKey(renderingHotbar, isRenderedAfterItem, currentItemX, currentItemY);
        ScreenParticleHolder target = ITEM_PARTICLES.computeIfAbsent(new ScreenParticleItemStackKey(renderingHotbar, isRenderedAfterItem, stack), s -> new ScreenParticleHolder());
        ScreenParticleHandler.pullFromParticleVault(cacheKey, stack, target, isRenderedAfterItem);
        if (canSpawnParticles) {
            if (isRenderedAfterItem) {
                emitter.spawnLateParticles(target, (class_1937)level, class_310.method_1551().field_1728.field_1970, stack, currentItemX, currentItemY);
            } else {
                emitter.spawnEarlyParticles(target, (class_1937)level, class_310.method_1551().field_1728.field_1970, stack, currentItemX, currentItemY);
            }
        }
        ACTIVELY_ACCESSED_KEYS.add(cacheKey);
        return target;
    }

    public static void pullFromParticleVault(ScreenParticleItemStackRetrievalKey cacheKey, class_1799 currentStack, ScreenParticleHolder target, boolean isRenderedAfterItem) {
        class_1799 oldStack;
        if (ITEM_STACK_CACHE.containsKey(cacheKey) && (oldStack = ITEM_STACK_CACHE.get(cacheKey)) != currentStack && oldStack.method_7909().equals(currentStack.method_7909())) {
            ScreenParticleItemStackKey oldKey = new ScreenParticleItemStackKey(renderingHotbar, isRenderedAfterItem, oldStack);
            ScreenParticleHolder oldParticles = ITEM_PARTICLES.get(oldKey);
            if (oldParticles != null) {
                target.addFrom(oldParticles);
            }
            ITEM_STACK_CACHE.remove(cacheKey);
            ITEM_PARTICLES.remove(oldKey);
        }
        ITEM_STACK_CACHE.put(cacheKey, currentStack);
    }

    public static void renderItemStackLate() {
        if (cachedItemParticles != null) {
            ScreenParticleHandler.renderParticles(cachedItemParticles);
            cachedItemParticles = null;
        }
    }

    public static void renderParticles(ScreenParticleHolder screenParticleTarget) {
        screenParticleTarget.particles.forEach((renderType, particles) -> {
            renderType.begin(TESSELATOR.method_1349(), class_310.method_1551().method_1531());
            for (ScreenParticle next : particles) {
                next.render(TESSELATOR.method_1349());
            }
            renderType.end(TESSELATOR);
        });
    }

    public static void clearParticles() {
        ITEM_PARTICLES.values().forEach(ScreenParticleHandler::clearParticles);
    }

    public static void clearParticles(ScreenParticleHolder screenParticleTarget) {
        screenParticleTarget.particles.values().forEach(ArrayList::clear);
    }

    public static <T extends ScreenParticleOptions> ScreenParticle addParticle(ScreenParticleHolder screenParticleTarget, T options, double x, double y, double xMotion, double yMotion) {
        class_310 minecraft = class_310.method_1551();
        ScreenParticleType<?> type = options.type;
        ScreenParticle particle = type.provider.createParticle(minecraft.field_1687, options, x, y, xMotion, yMotion);
        ArrayList list = screenParticleTarget.particles.computeIfAbsent(options.renderType, a -> new ArrayList());
        list.add(particle);
        return particle;
    }

    static {
        TESSELATOR = new class_289();
    }
}

