/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers.screenparticle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_7923;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;

public class ParticleEmitterHandler {
    public static final Map<class_1792, List<ItemParticleSupplier>> EMITTERS = new HashMap<class_1792, List<ItemParticleSupplier>>();

    public static void registerParticleEmitters() {
        DataHelper.getAll(class_7923.field_41178.method_10220().toList(), i -> i instanceof ItemParticleSupplier).forEach(i -> {
            ItemParticleSupplier emitter = (ItemParticleSupplier)i;
            ParticleEmitterHandler.registerItemParticleEmitter(i, emitter);
        });
    }

    public static void registerItemParticleEmitter(class_1792 item, ItemParticleSupplier emitter) {
        if (EMITTERS.containsKey(item)) {
            EMITTERS.get(item).add(emitter);
        } else {
            EMITTERS.put(item, new ArrayList<ItemParticleSupplier>(List.of(emitter)));
        }
    }

    public static void registerItemParticleEmitter(ItemParticleSupplier emitter, class_1792 ... items) {
        for (class_1792 item : items) {
            ParticleEmitterHandler.registerItemParticleEmitter(item, emitter);
        }
    }

    public static interface ItemParticleSupplier {
        default public void spawnEarlyParticles(ScreenParticleHolder target, class_1937 level, float partialTick, class_1799 stack, float x, float y) {
        }

        default public void spawnLateParticles(ScreenParticleHolder target, class_1937 level, float partialTick, class_1799 stack, float x, float y) {
        }
    }
}

