/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import java.util.Iterator;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import team.lodestar.lodestone.component.LodestoneComponents;
import team.lodestar.lodestone.component.LodestoneWorldComponent;
import team.lodestar.lodestone.events.types.worldevent.WorldEventClientEvents;
import team.lodestar.lodestone.events.types.worldevent.WorldEventEvents;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.network.worldevent.UpdateWorldEventPacket;
import team.lodestar.lodestone.registry.client.LodestoneWorldEventRendererRegistry;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.registry.common.LodestoneWorldEventTypeRegistry;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventRenderer;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class WorldEventHandler {
    public static boolean playerJoin(class_1297 entity, class_1937 level, boolean b) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                LodestoneComponents.LODESTONE_PLAYER_COMPONENT.maybeGet((Object)player).ifPresent(c -> LodestoneComponents.LODESTONE_WORLD_COMPONENT.maybeGet((Object)serverLevel).ifPresent(wc -> {
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        for (WorldEventInstance instance : wc.activeWorldEvents) {
                            if (!instance.type.isClientSynced()) continue;
                            WorldEventInstance.sync(instance, serverPlayer);
                        }
                    }
                }));
            }
        }
        return true;
    }

    public static <T extends WorldEventInstance> T addWorldEvent(class_1937 level, T instance) {
        return WorldEventHandler.addWorldEvent(level, true, instance);
    }

    public static <T extends WorldEventInstance> T addWorldEvent(class_1937 level, boolean shouldStart, T instance) {
        ((WorldEventEvents.Creation)WorldEventEvents.CREATION.invoker()).onCreation(instance, level);
        LodestoneComponents.LODESTONE_WORLD_COMPONENT.maybeGet((Object)level).ifPresent(c -> {
            c.inboundWorldEvents.add(instance);
            if (shouldStart) {
                instance.start(level);
            }
            instance.sync(level);
        });
        return instance;
    }

    public static void worldTick(class_1937 level) {
        if (!level.field_9236) {
            WorldEventHandler.tick(level);
        }
    }

    public static void tick(class_1937 level) {
        LodestoneComponents.LODESTONE_WORLD_COMPONENT.maybeGet((Object)level).ifPresent(c -> {
            c.activeWorldEvents.addAll(c.inboundWorldEvents);
            c.inboundWorldEvents.clear();
            Iterator<WorldEventInstance> iterator = c.activeWorldEvents.iterator();
            while (iterator.hasNext()) {
                WorldEventInstance instance = iterator.next();
                if (instance.discarded) {
                    ((WorldEventEvents.Discard)WorldEventEvents.DISCARD.invoker()).onDiscard(instance, level);
                    iterator.remove();
                    continue;
                }
                if (!instance.isFrozen()) {
                    ((WorldEventEvents.Tick)WorldEventEvents.TICK.invoker()).onTick(instance, level);
                    instance.tick(level);
                }
                if (!instance.dirty) continue;
                LodestonePacketRegistry.LODESTONE_CHANNEL.sendToClientsInCurrentServer((S2CPacket)new UpdateWorldEventPacket(instance.uuid, instance.synchronizeNBT()));
                instance.dirty = false;
            }
        });
    }

    public static void serializeNBT(LodestoneWorldComponent capability, class_2487 tag) {
        class_2487 worldTag = new class_2487();
        worldTag.method_10569("worldEventCount", capability.activeWorldEvents.size());
        for (int i = 0; i < capability.activeWorldEvents.size(); ++i) {
            WorldEventInstance instance = capability.activeWorldEvents.get(i);
            class_2487 instanceTag = new class_2487();
            instance.serializeNBT(instanceTag);
            worldTag.method_10566("worldEvent_" + i, (class_2520)instanceTag);
        }
        tag.method_10566("worldEventData", (class_2520)worldTag);
    }

    public static void deserializeNBT(LodestoneWorldComponent capability, class_2487 tag) {
        capability.activeWorldEvents.clear();
        class_2487 worldTag = tag.method_10562("worldEventData");
        int worldEventCount = worldTag.method_10550("worldEventCount");
        for (int i = 0; i < worldEventCount; ++i) {
            class_2487 instanceTag = worldTag.method_10562("worldEvent_" + i);
            WorldEventType reader = LodestoneWorldEventTypeRegistry.EVENT_TYPES.get(new class_2960(instanceTag.method_10558("type")));
            WorldEventInstance eventInstance = reader.createInstance(instanceTag);
            capability.activeWorldEvents.add(eventInstance);
        }
    }

    public static class ClientOnly {
        public static void renderWorldEvents(class_4587 stack, float partialTicks) {
            LodestoneComponents.LODESTONE_WORLD_COMPONENT.maybeGet((Object)class_310.method_1551().field_1687).ifPresent(c -> {
                for (WorldEventInstance instance : c.activeWorldEvents) {
                    WorldEventRenderer<WorldEventInstance> renderer = LodestoneWorldEventRendererRegistry.RENDERERS.get(instance.type);
                    if (renderer == null || !renderer.canRender(instance)) continue;
                    ((WorldEventClientEvents.Render)WorldEventClientEvents.RENDER.invoker()).onRender(instance, renderer, stack, (class_4597)RenderHandler.DELAYED_RENDER.getTarget(), partialTicks);
                    renderer.render(instance, stack, (class_4597)RenderHandler.DELAYED_RENDER.getTarget(), partialTicks);
                }
            });
        }
    }
}

