/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_6854;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.helpers.RenderHelper;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class RenderHandler {
    public static final HashMap<class_1921, class_287> BUFFERS = new HashMap();
    public static final HashMap<class_1921, class_287> PARTICLE_BUFFERS = new HashMap();
    public static final HashMap<class_1921, class_287> LATE_BUFFERS = new HashMap();
    public static final HashMap<class_1921, class_287> LATE_PARTICLE_BUFFERS = new HashMap();
    public static final HashMap<class_1921, ShaderUniformHandler> UNIFORM_HANDLERS = new HashMap();
    public static final Collection<class_1921> TRANSPARENT_RENDER_TYPES = new ArrayList<class_1921>();
    public static boolean LARGER_BUFFER_SOURCES = FabricLoader.getInstance().isModLoaded("sodium");
    public static boolean IRIS_LOADED = FabricLoader.getInstance().isModLoaded("iris");
    public static class_276 LODESTONE_DEPTH_CACHE;
    public static LodestoneRenderLayer DELAYED_RENDER;
    public static LodestoneRenderLayer LATE_DELAYED_RENDER;
    public static class_4587 MAIN_POSE_STACK;
    public static Matrix4f MATRIX4F;
    public static float FOG_NEAR;
    public static float FOG_FAR;
    public static class_6854 FOG_SHAPE;
    public static float FOG_RED;
    public static float FOG_GREEN;
    public static float FOG_BLUE;

    public static void onClientSetup() {
        LodestoneLib.debug("onClientSetup()");
        DELAYED_RENDER = new LodestoneRenderLayer(BUFFERS, PARTICLE_BUFFERS);
        LATE_DELAYED_RENDER = new LodestoneRenderLayer(LATE_BUFFERS, LATE_PARTICLE_BUFFERS);
    }

    public static void resize(int width, int height) {
        if (LODESTONE_DEPTH_CACHE != null) {
            LODESTONE_DEPTH_CACHE.method_1234(width, height, class_310.field_1703);
        }
    }

    public static void endBatches() {
        RenderHandler.copyDepthBuffer(LODESTONE_DEPTH_CACHE);
        RenderHandler.endBatches(DELAYED_RENDER);
        RenderHandler.endBatches(LATE_DELAYED_RENDER);
    }

    public static void endBatches(LodestoneRenderLayer renderLayer) {
        Matrix4f last = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderHandler.beginBufferedRendering();
        RenderHandler.renderBufferedParticles(renderLayer, true);
        if (MATRIX4F != null) {
            RenderSystem.getModelViewMatrix().set((Matrix4fc)MATRIX4F);
        }
        RenderHandler.renderBufferedBatches(renderLayer, true);
        RenderHandler.renderBufferedBatches(renderLayer, false);
        RenderSystem.getModelViewMatrix().set((Matrix4fc)last);
        RenderHandler.renderBufferedParticles(renderLayer, false);
        RenderHandler.endBufferedRendering();
    }

    public static void cacheFogData(float start, float end, class_6854 shape) {
        FOG_NEAR = start;
        FOG_FAR = end;
        FOG_SHAPE = shape;
    }

    public static void cacheFogData(float fogRed, float fogGreen, float fogBlue) {
        FOG_RED = fogRed;
        FOG_GREEN = fogGreen;
        FOG_BLUE = fogBlue;
    }

    public static void beginBufferedRendering() {
        float[] shaderFogColor = RenderSystem.getShaderFogColor();
        float fogRed = shaderFogColor[0];
        float fogGreen = shaderFogColor[1];
        float fogBlue = shaderFogColor[2];
        float shaderFogStart = RenderSystem.getShaderFogStart();
        float shaderFogEnd = RenderSystem.getShaderFogEnd();
        class_6854 shaderFogShape = RenderSystem.getShaderFogShape();
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((class_6854)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
        FOG_RED = fogRed;
        FOG_GREEN = fogGreen;
        FOG_BLUE = fogBlue;
        FOG_NEAR = shaderFogStart;
        FOG_FAR = shaderFogEnd;
        FOG_SHAPE = shaderFogShape;
    }

    public static void endBufferedRendering() {
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((class_6854)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
    }

    public static void renderBufferedParticles(LodestoneRenderLayer renderLayer, boolean transparentOnly) {
        RenderHandler.renderBufferedBatches(renderLayer.particleTarget, PARTICLE_BUFFERS, transparentOnly);
    }

    public static void renderBufferedBatches(LodestoneRenderLayer renderLayer, boolean transparentOnly) {
        RenderHandler.renderBufferedBatches(renderLayer.target, BUFFERS, transparentOnly);
    }

    private static void renderBufferedBatches(class_4597.class_4598 bufferSource, HashMap<class_1921, class_287> buffer, boolean transparentOnly) {
        if (transparentOnly) {
            RenderHandler.endBatches(bufferSource, TRANSPARENT_RENDER_TYPES);
        } else {
            ArrayList<class_1921> nonTransparentRenderTypes = new ArrayList<class_1921>(buffer.keySet());
            nonTransparentRenderTypes.removeIf(TRANSPARENT_RENDER_TYPES::contains);
            RenderHandler.endBatches(bufferSource, nonTransparentRenderTypes);
        }
    }

    public static void endBatches(class_4597.class_4598 source, Collection<class_1921> renderTypes) {
        for (class_1921 type : renderTypes) {
            class_5944 instance = RenderHelper.getShader(type);
            if (UNIFORM_HANDLERS.containsKey(type)) {
                ShaderUniformHandler handler = UNIFORM_HANDLERS.get(type);
                handler.updateShaderData(instance);
            }
            if (LODESTONE_DEPTH_CACHE != null) {
                instance.method_34583("SceneDepthBuffer", (Object)LODESTONE_DEPTH_CACHE.method_30278());
                instance.method_35785("InvProjMat").method_1250(new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).invert());
            }
            source.method_22994(type);
            if (!(instance instanceof ExtendedShaderInstance)) continue;
            ExtendedShaderInstance extendedShaderInstance = (ExtendedShaderInstance)instance;
            extendedShaderInstance.setUniformDefaults();
        }
    }

    public static void addRenderType(class_1921 renderType) {
        boolean isParticle = renderType.field_21363.contains("particle");
        HashMap<class_1921, class_287> buffers = isParticle ? PARTICLE_BUFFERS : BUFFERS;
        HashMap<class_1921, class_287> lateBuffers = isParticle ? LATE_PARTICLE_BUFFERS : LATE_BUFFERS;
        buffers.put(renderType, new class_287(LARGER_BUFFER_SOURCES ? 0x200000 : renderType.method_22722()));
        lateBuffers.put(renderType, new class_287(LARGER_BUFFER_SOURCES ? 0x200000 : renderType.method_22722()));
        if (StateShards.NORMAL_TRANSPARENCY.equals(RenderHelper.getTransparencyShard(renderType))) {
            TRANSPARENT_RENDER_TYPES.add(renderType);
        }
    }

    public static void copyDepthBuffer(class_276 tempRenderTarget) {
        RenderHandler.setupDepthBuffer();
        RenderHandler.enableStencil();
        if (tempRenderTarget == null) {
            return;
        }
        class_276 mainRenderTarget = class_310.method_1551().method_1522();
        tempRenderTarget.method_29329(mainRenderTarget);
        GlStateManager._glBindFramebuffer((int)36009, (int)mainRenderTarget.field_1476);
    }

    public static void setupDepthBuffer() {
        if (LODESTONE_DEPTH_CACHE == null) {
            LODESTONE_DEPTH_CACHE = new class_6367(class_310.method_1551().method_1522().field_1482, class_310.method_1551().method_1522().field_1481, true, class_310.field_1703);
        }
    }

    public static void enableStencil() {
        if (class_310.method_1551().method_1522().isStencilEnabled()) {
            LODESTONE_DEPTH_CACHE.enableStencil();
        }
    }

    public static class LodestoneRenderLayer {
        protected final HashMap<class_1921, class_287> buffers;
        protected final HashMap<class_1921, class_287> particleBuffers;
        protected final class_4597.class_4598 target;
        protected final class_4597.class_4598 particleTarget;

        public LodestoneRenderLayer(HashMap<class_1921, class_287> buffers, HashMap<class_1921, class_287> particleBuffers) {
            this(buffers, particleBuffers, LARGER_BUFFER_SOURCES ? 0x200000 : 256);
        }

        public LodestoneRenderLayer(HashMap<class_1921, class_287> buffers, HashMap<class_1921, class_287> particleBuffers, int size) {
            this.buffers = buffers;
            this.particleBuffers = particleBuffers;
            this.target = class_4597.method_22992(buffers, (class_287)new class_287(size));
            this.particleTarget = class_4597.method_22992(particleBuffers, (class_287)new class_287(size));
        }

        public HashMap<class_1921, class_287> getBuffers() {
            return this.buffers;
        }

        public HashMap<class_1921, class_287> getParticleBuffers() {
            return this.particleBuffers;
        }

        public class_4597.class_4598 getTarget() {
            return this.target;
        }

        public class_4597.class_4598 getParticleTarget() {
            return this.particleTarget;
        }
    }
}

