/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.placementassistance.IPlacementAssistant;

public class PlacementAssistantHandler {
    public static final ArrayList<IPlacementAssistant> ASSISTANTS = new ArrayList();
    public static int animationTick = 0;
    public static class_3965 target;

    public static void registerPlacementAssistants() {
        DataHelper.getAll(new ArrayList(class_7923.field_41175.method_10220().toList()), b -> b instanceof IPlacementAssistant).forEach(i -> {
            IPlacementAssistant assistant = (IPlacementAssistant)i;
            ASSISTANTS.add(assistant);
        });
    }

    public static boolean placeBlock(class_1657 player, class_1268 interactionHand, class_2338 pos, class_3965 blockHitResult) {
        class_1937 level = player.method_37908();
        if (level.field_9236) {
            List<Pair<IPlacementAssistant, class_1799>> assistants = PlacementAssistantHandler.findAssistants(level, player, (class_239)blockHitResult);
            for (Pair<IPlacementAssistant, class_1799> pair : assistants) {
                IPlacementAssistant assistant = (IPlacementAssistant)pair.getFirst();
                class_2680 state = level.method_8320(pos);
                assistant.onPlaceBlock(player, level, blockHitResult, state, (class_1799)pair.getSecond());
            }
            animationTick = Math.max(0, animationTick - 5);
        }
        return false;
    }

    public static void tick(class_1657 player, class_239 hitResult) {
        class_3965 blockHitResult;
        if (player == null) {
            return;
        }
        class_1937 level = player.method_37908();
        List<Pair<IPlacementAssistant, class_1799>> placementAssistants = PlacementAssistantHandler.findAssistants(level, player, hitResult);
        if (hitResult instanceof class_3965 && !(blockHitResult = (class_3965)hitResult).method_17783().equals((Object)class_239.class_240.field_1333)) {
            target = blockHitResult;
            for (Pair<IPlacementAssistant, class_1799> pair : placementAssistants) {
                IPlacementAssistant assistant = (IPlacementAssistant)pair.getFirst();
                class_2680 state = level.method_8320(blockHitResult.method_17777());
                assistant.onObserveBlock(player, level, blockHitResult, state, (class_1799)pair.getSecond());
            }
        } else {
            target = null;
        }
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    private static List<Pair<IPlacementAssistant, class_1799>> findAssistants(class_1937 level, class_1657 player, class_239 hitResult) {
        if (!(hitResult instanceof class_3965)) {
            return Collections.emptyList();
        }
        return PlacementAssistantHandler.findAssistants(level, player);
    }

    private static List<Pair<IPlacementAssistant, class_1799>> findAssistants(class_1937 level, class_1657 player) {
        if (level == null || player == null || player.method_5715()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<IPlacementAssistant, class_1799>> matchingAssistants = new ArrayList<Pair<IPlacementAssistant, class_1799>>();
        for (class_1268 hand : class_1268.values()) {
            class_1799 held = player.method_5998(hand);
            matchingAssistants.addAll(ASSISTANTS.stream().filter(s -> s.canAssist().test(held)).map(a -> Pair.of((Object)a, (Object)held)).collect(Collectors.toCollection(ArrayList::new)));
        }
        return matchingAssistants;
    }

    public static float getCurrentAlpha() {
        return Math.min((float)animationTick / 10.0f, 1.0f);
    }
}

