/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import team.lodestar.lodestone.component.LodestoneComponents;
import team.lodestar.lodestone.component.LodestoneEntityComponent;
import team.lodestar.lodestone.network.ClearFireEffectInstancePacket;
import team.lodestar.lodestone.registry.client.LodestoneFireEffectRendererRegistry;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.systems.fireeffect.FireEffectInstance;
import team.lodestar.lodestone.systems.fireeffect.FireEffectRenderer;

public class FireEffectHandler {
    public static void entityUpdate(class_1297 entity) {
        FireEffectInstance instance = FireEffectHandler.getFireEffectInstance(entity);
        if (instance != null) {
            instance.tick(entity);
            if (!instance.isValid()) {
                FireEffectHandler.setCustomFireInstance(entity, null);
            }
        }
    }

    public static void onVanillaFireTimeUpdate(class_1297 entity) {
        FireEffectHandler.setCustomFireInstance(entity, null);
    }

    public static FireEffectInstance getFireEffectInstance(class_1297 entity) {
        return ((LodestoneEntityComponent)LodestoneComponents.LODESTONE_ENTITY_COMPONENT.get((Object)entity)).fireEffectInstance;
    }

    public static void setCustomFireInstance(class_1297 entity, FireEffectInstance instance) {
        LodestoneComponents.LODESTONE_ENTITY_COMPONENT.maybeGet((Object)entity).ifPresent(c -> {
            c.fireEffectInstance = instance;
            if (c.fireEffectInstance != null) {
                if (entity.method_20802() > 0) {
                    entity.method_20803(0);
                }
                if (!entity.method_37908().field_9236) {
                    c.fireEffectInstance.sync(entity);
                }
            } else if (!entity.method_37908().field_9236) {
                LodestonePacketRegistry.LODESTONE_CHANNEL.sendToClientsTracking((S2CPacket)new ClearFireEffectInstancePacket(entity.method_5628()), entity);
            }
        });
    }

    public static void serializeNBT(LodestoneEntityComponent capability, class_2487 tag) {
        if (capability.fireEffectInstance != null) {
            capability.fireEffectInstance.serializeNBT(tag);
        }
    }

    public static void deserializeNBT(LodestoneEntityComponent capability, class_2487 tag) {
        capability.fireEffectInstance = FireEffectInstance.deserializeNBT(tag);
    }

    public static class ClientOnly {
        public static void renderUIFireEffect(class_310 pMinecraft, class_4587 pPoseStack) {
            if (pMinecraft.field_1724 != null && FireEffectHandler.getFireEffectInstance((class_1297)pMinecraft.field_1724) == null) {
                return;
            }
            FireEffectInstance instance = FireEffectHandler.getFireEffectInstance((class_1297)pMinecraft.field_1724);
            FireEffectRenderer<FireEffectInstance> renderer = LodestoneFireEffectRendererRegistry.RENDERERS.get(instance.type);
            if (renderer != null && renderer.canRender(instance)) {
                renderer.renderScreen(instance, pMinecraft, pPoseStack);
            }
        }

        public static void renderWorldFireEffect(class_4587 pMatrixStack, class_4597 pBuffer, class_4184 camera, class_1297 pEntity) {
            if (FireEffectHandler.getFireEffectInstance(pEntity) == null) {
                return;
            }
            FireEffectInstance instance = FireEffectHandler.getFireEffectInstance(pEntity);
            FireEffectRenderer<FireEffectInstance> renderer = LodestoneFireEffectRendererRegistry.RENDERERS.get(instance.type);
            if (renderer != null && renderer.canRender(instance)) {
                renderer.renderWorld(instance, pMatrixStack, pBuffer, camera, pEntity);
            }
        }
    }
}

