/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.data.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.registry.common.LodestoneRecipeSerializerRegistry;

public class NBTCarryRecipeBuilder {
    private final class_1792 result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final class_161.class_162 advancementBuilder = class_161.class_162.method_707();
    private final class_1856 nbtCarry;
    private String group;

    public NBTCarryRecipeBuilder(class_1935 resultIn, int countIn, class_1856 nbtCarry) {
        this.result = resultIn.method_8389();
        this.count = countIn;
        this.nbtCarry = nbtCarry;
    }

    public static NBTCarryRecipeBuilder shapedRecipe(class_1935 resultIn, class_1856 nbtCarry) {
        return NBTCarryRecipeBuilder.shapedRecipe(resultIn, 1, nbtCarry);
    }

    public static NBTCarryRecipeBuilder shapedRecipe(class_1935 resultIn, int countIn, class_1856 nbtCarry) {
        return new NBTCarryRecipeBuilder(resultIn, countIn, nbtCarry);
    }

    public NBTCarryRecipeBuilder key(Character symbol, class_6862<class_1792> tagIn) {
        return this.key(symbol, class_1856.method_8106(tagIn));
    }

    public NBTCarryRecipeBuilder key(Character symbol, class_1935 itemIn) {
        return this.key(symbol, class_1856.method_8091((class_1935[])new class_1935[]{itemIn}));
    }

    public NBTCarryRecipeBuilder key(Character symbol, class_1856 ingredientIn) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredientIn);
        return this;
    }

    public NBTCarryRecipeBuilder patternLine(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public NBTCarryRecipeBuilder addCriterion(String name, class_184 criterionIn) {
        this.advancementBuilder.method_709(name, criterionIn);
        return this;
    }

    public NBTCarryRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void build(Consumer<class_2444> consumerIn) {
        this.build(consumerIn, class_7923.field_41178.method_10221((Object)this.result));
    }

    public void build(Consumer<class_2444> consumerIn, String save) {
        class_2960 resourcelocation = class_7923.field_41178.method_10221((Object)this.result);
        if (new class_2960(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new class_2960(save));
    }

    public void build(Consumer<class_2444> consumerIn, class_2960 id) {
        this.validate(id);
        this.advancementBuilder.method_708(new class_2960("recipes/root")).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_193.field_1257);
        consumerIn.accept(new Result(id, this.nbtCarry, this.result, this.count, this.group == null ? "" : this.group, this.pattern, this.key, this.advancementBuilder, new class_2960(id.method_12836(), "recipes/" + id.method_12832())));
    }

    private void validate(class_2960 id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancementBuilder.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1856 nbtCarry;
        private final class_1792 result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, class_1856> key;
        private final class_161.class_162 advancementBuilder;
        private final class_2960 advancementId;

        public Result(class_2960 idIn, class_1856 nbtCarry, class_1792 resultIn, int countIn, String groupIn, List<String> patternIn, Map<Character, class_1856> keyIn, class_161.class_162 advancementBuilderIn, class_2960 advancementIdIn) {
            this.id = idIn;
            this.nbtCarry = nbtCarry;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.pattern = patternIn;
            this.key = keyIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
        }

        public void method_10416(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            json.add("key", (JsonElement)jsonobject);
            json.add("nbtCarry", this.nbtCarry.method_8089());
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public class_1865<?> method_17800() {
            return (class_1865)LodestoneRecipeSerializerRegistry.NBT_CARRY_RECIPE_SERIALIZER.get();
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancementBuilder.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

