/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.data;

import java.util.HashSet;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;

public class LodestoneLangDatagen
extends FabricLanguageProvider {
    protected LodestoneLangDatagen(FabricDataOutput dataOutput) {
        super(dataOutput, "en_us");
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        HashSet attributes = new HashSet(LodestoneAttributeRegistry.ATTRIBUTES.getEntries());
        attributes.forEach(a -> {
            String name = DataHelper.toTitleCase(a.getId().method_12832(), "_");
            builder.add("attribute.name.lodestone." + a.getId().method_12832(), name);
        });
        this.addOption(builder, "screenshake_intensity", "Screenshake Intensity");
        this.addOptionTooltip(builder, "screenshake_intensity", "Controls how much screenshake is applied to your screen.");
        this.addOption(builder, "fire_offset", "Fire Overlay Offset");
        this.addOptionTooltip(builder, "fire_offset", "Offsets the fire overlay effect downwards, clearing up your vision.");
        this.addCommand(builder, "devsetup", "World setup for not-annoying development work");
        this.addCommand(builder, "screenshake", "Command Successful, enjoy your screenshake.");
    }

    public void addCommand(FabricLanguageProvider.TranslationBuilder builder, String command, String feedback) {
        this.addOption(builder, LodestoneLangDatagen.getCommand(command), feedback);
    }

    public static String getCommand(String command) {
        return "command.lodestone." + command;
    }

    public void addOption(FabricLanguageProvider.TranslationBuilder builder, String option, String result) {
        builder.add(LodestoneLangDatagen.getOption(option), result);
    }

    public static String getOption(String option) {
        return "options.lodestone." + option;
    }

    public void addOptionTooltip(FabricLanguageProvider.TranslationBuilder builder, String option, String result) {
        this.addOption(builder, LodestoneLangDatagen.getOptionTooltip(option), result);
    }

    public static String getOptionTooltip(String option) {
        return "options.lodestone." + option + ".tooltip";
    }

    public String method_10321() {
        return "Lodestone Lang Entries";
    }
}

