/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import me.pepperbell.simplenetworking.C2SPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import team.lodestar.lodestone.component.LodestoneComponents;
import team.lodestar.lodestone.network.interaction.UpdateLeftClickPacket;
import team.lodestar.lodestone.network.interaction.UpdateRightClickPacket;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;

public class LodestonePlayerComponent
implements AutoSyncedComponent {
    private final class_1657 player;
    public boolean hasJoinedBefore;
    public boolean rightClickHeld;
    public int rightClickTime;
    public boolean leftClickHeld;
    public int leftClickTime;

    public LodestonePlayerComponent(class_1657 player) {
        this.player = player;
    }

    public static void playerTick(class_1657 player) {
        LodestoneComponents.LODESTONE_PLAYER_COMPONENT.maybeGet((Object)player).ifPresent(c -> {
            c.rightClickTime = c.rightClickHeld ? c.rightClickTime + 1 : 0;
            c.leftClickTime = c.leftClickHeld ? c.leftClickTime + 1 : 0;
        });
    }

    public static boolean playerJoin(class_1297 entity, class_1937 level, boolean b) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            LodestoneComponents.LODESTONE_PLAYER_COMPONENT.maybeGet((Object)serverPlayer).ifPresent(capability -> {
                capability.hasJoinedBefore = true;
            });
            LodestoneComponents.LODESTONE_PLAYER_COMPONENT.sync((Object)serverPlayer);
        }
        return true;
    }

    public void readFromNbt(class_2487 tag) {
        this.hasJoinedBefore = tag.method_10577("firstTimeJoin");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("firstTimeJoin", this.hasJoinedBefore);
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientTick(class_310 minecraft) {
        class_746 player = minecraft.field_1724;
        LodestoneComponents.LODESTONE_PLAYER_COMPONENT.maybeGet((Object)player).ifPresent(c -> {
            boolean left = minecraft.field_1690.field_1886.method_1434();
            boolean right = minecraft.field_1690.field_1904.method_1434();
            if (left != c.leftClickHeld) {
                c.leftClickHeld = left;
                LodestonePacketRegistry.LODESTONE_CHANNEL.sendToServer((C2SPacket)new UpdateLeftClickPacket(c.leftClickHeld));
            }
            if (right != c.rightClickHeld) {
                c.rightClickHeld = right;
                LodestonePacketRegistry.LODESTONE_CHANNEL.sendToServer((C2SPacket)new UpdateRightClickPacket(c.rightClickHeld));
            }
        });
    }
}

