/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.fabricators_of_create.porting_lib.util.ServerLifecycleHooks;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5242;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import team.lodestar.lodestone.component.LodestoneComponents;
import team.lodestar.lodestone.mixin.client.ClientSuggestionProviderMixin;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class WorldEventInstanceArgument
implements ArgumentType<WorldEventInstance> {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_WORLD_EVENT_INSTANCE = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"argument.lodestone.id.invalid", (Object[])new Object[]{object.toString()}));
    private static final Pattern ALLOWED_CHARACTERS = Pattern.compile("^([-A-Fa-f0-9]+)");

    protected WorldEventInstanceArgument() {
    }

    public static WorldEventInstanceArgument worldEventInstance() {
        return new WorldEventInstanceArgument();
    }

    public static WorldEventInstance getEventInstance(CommandContext<?> context, String name) {
        return (WorldEventInstance)context.getArgument(name, WorldEventInstance.class);
    }

    public WorldEventInstance parse(StringReader reader) throws CommandSyntaxException {
        String s = reader.readString();
        Matcher matcher = ALLOWED_CHARACTERS.matcher(s);
        AtomicReference eventInstance = new AtomicReference();
        if (matcher.find()) {
            String s1 = matcher.group(1);
            try {
                UUID uuid = UUID.fromString(s1);
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return null;
                }
                Set levels = ((class_2378)server.method_30611().method_33310(class_7924.field_41223).get()).method_42021();
                levels.forEach(levelResourceKey -> {
                    if (levelResourceKey == null) {
                        return;
                    }
                    class_3218 level = server.method_3847(levelResourceKey);
                    if (level == null) {
                        return;
                    }
                    LodestoneComponents.LODESTONE_WORLD_COMPONENT.maybeGet((Object)level).ifPresent(capability -> capability.activeWorldEvents.forEach(worldEventInstance -> {
                        if (worldEventInstance.uuid.equals(uuid)) {
                            eventInstance.set(worldEventInstance);
                        }
                    }));
                });
                if (eventInstance.get() == null) {
                    throw ERROR_UNKNOWN_WORLD_EVENT_INSTANCE.create((Object)uuid);
                }
                return (WorldEventInstance)eventInstance.get();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw class_5242.field_24318.create();
            }
        }
        return (WorldEventInstance)eventInstance.get();
    }

    @Environment(value=EnvType.CLIENT)
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object s = context.getSource();
        if (s instanceof class_2172) {
            class_2172 sharedsuggestionprovider = (class_2172)s;
            sharedsuggestionprovider.method_29310().forEach(levelResourceKey -> {
                if (levelResourceKey == null) {
                    return;
                }
                class_310 client = ((ClientSuggestionProviderMixin)sharedsuggestionprovider).getMinecraft();
                if (client == null) {
                    return;
                }
                LodestoneComponents.LODESTONE_WORLD_COMPONENT.maybeGet((Object)client).ifPresent(capability -> capability.activeWorldEvents.forEach(worldEventInstance -> builder.suggest(worldEventInstance.uuid.toString())));
            });
        }
        return builder.buildFuture();
    }
}

